/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.job;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

public class BathhouseAttendant
extends NPCJob {
    public static final String BATH_ACTION = "runecraftory.npc.action.bath";
    public static final String BATH_ACTION_SUCCESS = "runecraftory.npc.action.bath.success";
    public static final String BATH_ACTION_FAIL = "runecraftory.npc.action.bath.fail";
    public static final String BATH_COST = "runecraftory.npc.shop.bath.cost";

    public BathhouseAttendant(NPCJob.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(EntityNPCBase npc, class_1657 player, String action) {
        if (npc.canTrade() == ShopState.OPEN && action.equals(BATH_ACTION)) {
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> {
                int baths = d.getDailyUpdater().getBathCounter() + 1;
                int amount = 300 * baths + Math.max(0, baths - 1) * 100;
                if (d.useMoney(player, amount)) {
                    player.method_9203((class_2561)new class_2588(BATH_ACTION_SUCCESS, new Object[]{player.method_5477()}), class_156.field_25140);
                    player.method_6092(new class_1293((class_1291)ModEffects.BATH.get(), 1700, 0, false, true, false));
                    d.getDailyUpdater().increaseBathCounter();
                } else {
                    player.method_9203((class_2561)new class_2588(BATH_ACTION_FAIL, new Object[]{player.method_5477(), amount}), class_156.field_25140);
                }
            });
        }
    }

    @Override
    public Map<String, List<class_2561>> actions(EntityNPCBase entity, class_3222 player) {
        return Map.of(BATH_ACTION, List.of(new class_2588(BATH_COST, new Object[]{Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> {
            int baths = d.getDailyUpdater().getBathCounter() + 1;
            return 300 * baths + Math.max(0, baths - 1) * 100;
        }).orElse(-1)})));
    }
}

