/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.job;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class Cook
extends NPCJob {
    public static final String FORGE_BREAD_ACTION = "runecraftory.npc.action.bread.forge";
    public static final String ARMOR_BREAD_DESCRIPTION = "runecraftory.npc.action.bread.armor";
    public static final String CHEM_BREAD_SUCCESS = "runecraftory.npc.action.bread.chem";
    public static final String COOKING_BREAD_SUCCESS = "runecraftory.npc.action.bread.cooking";
    public static final String BREAD_ACTION_SUCCESS = "runecraftory.npc.action.bread.success";
    public static final String BREAD_ACTION_SUCCESS_GOOD = "runecraftory.npc.action.bread.success.good";
    public static final String BREAD_ACTION_FAIL = "runecraftory.npc.action.bread.fail";
    public static final String BREAD_COST = "runecraftory.npc.shop.bread.cost";
    public static final int BREAD_PRICE = 500;

    public Cook(NPCJob.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(EntityNPCBase npc, class_1657 player, String action) {
        if (npc.updater.getBreadToBuy() <= 0) {
            return;
        }
        if (Platform.INSTANCE.getPlayerData(player).map(d -> !d.useMoney(player, 500)).orElse(true).booleanValue()) {
            player.method_9203((class_2561)new class_2588(BREAD_ACTION_FAIL, new Object[]{player.method_5477(), 500}), class_156.field_25140);
            return;
        }
        class_1799 bread = switch (action) {
            case ARMOR_BREAD_DESCRIPTION -> new class_1799((class_1935)ModItems.ARMOR_BREAD.get());
            case CHEM_BREAD_SUCCESS -> new class_1799((class_1935)ModItems.CHEMISTRY_BREAD.get());
            case COOKING_BREAD_SUCCESS -> new class_1799((class_1935)ModItems.COOKING_BREAD.get());
            default -> new class_1799((class_1935)ModItems.FORGING_BREAD.get());
        };
        int level = class_3532.method_15384((double)Math.abs(npc.method_6051().nextGaussian() * 4.0));
        Cook.withLevel(bread, level);
        if (!player.method_7270(bread)) {
            player.method_5775(bread);
        }
        npc.updater.onBuyBread();
        if (level >= 7) {
            player.method_9203((class_2561)new class_2588(BREAD_ACTION_SUCCESS_GOOD, new Object[]{player.method_5477()}), class_156.field_25140);
        } else {
            player.method_9203((class_2561)new class_2588(BREAD_ACTION_SUCCESS, new Object[]{player.method_5477()}), class_156.field_25140);
        }
    }

    @Override
    public Map<String, List<class_2561>> actions(EntityNPCBase entity, class_3222 player) {
        int bread = entity.updater.getBreadToBuy();
        if (bread > 0) {
            class_2588 comp = new class_2588(BREAD_COST, new Object[]{500, bread});
            return ImmutableMap.of((Object)FORGE_BREAD_ACTION, List.of(comp), (Object)ARMOR_BREAD_DESCRIPTION, List.of(comp), (Object)CHEM_BREAD_SUCCESS, List.of(comp), (Object)COOKING_BREAD_SUCCESS, List.of(comp));
        }
        return Map.of();
    }

    public static class_1799 withLevel(class_1799 stack, int level) {
        class_2487 tag = ItemNBT.getItemNBT(stack);
        if (tag == null) {
            tag = new class_2487();
        }
        tag.method_10569("ItemLevel", class_3532.method_15340((int)level, (int)1, (int)10));
        class_2487 stackTag = stack.method_7948();
        stackTag.method_10566("runecraftory", (class_2520)tag);
        return stack;
    }
}

