/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.events;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attackactions.NaiveBladeAttack;
import io.github.flemmli97.runecraftory.common.blocks.BlockMineral;
import io.github.flemmli97.runecraftory.common.blocks.Growable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHammer;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolSickle;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.common.network.S2CDataPackSync;
import io.github.flemmli97.runecraftory.common.network.S2CEntityDataSyncAll;
import io.github.flemmli97.runecraftory.common.network.S2CSyncConfig;
import io.github.flemmli97.runecraftory.common.network.S2CTriggers;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.family.FamilyHandler;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.LivingEntityAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_3738;
import net.minecraft.class_4208;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EntityCalls {
    public static void joinPlayer(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            for (S2CDataPackSync.SyncedType type : S2CDataPackSync.SyncedType.values()) {
                Platform.INSTANCE.sendToClient(new S2CDataPackSync(type), serverPlayer);
            }
            Platform.INSTANCE.sendToClient(new S2CCalendar(WorldHandler.get(serverPlayer.method_5682()).getCalendar()), serverPlayer);
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> {
                data.recalculateStats(serverPlayer, false);
                if (!data.starting) {
                    data.starting = true;
                    data.setMaxHealth(player, GeneralConfig.startingHealth, true);
                    player.method_6033(player.method_6063());
                }
            });
            QuestHandler.removeNPCQuestsFor(serverPlayer);
            Platform.INSTANCE.sendToClient(new S2CSyncConfig(), serverPlayer);
            FamilyHandler.get(serverPlayer.method_5682()).getOrCreateEntry((class_1657)serverPlayer).updateName((class_1297)player);
        }
    }

    public static void onResourceReloadEnd(MinecraftServer server) {
        for (S2CDataPackSync.SyncedType type : S2CDataPackSync.SyncedType.values()) {
            DataPackHandler.prepareResync(type);
            S2CDataPackSync pkt = new S2CDataPackSync(type);
            Platform.INSTANCE.sendToAll(pkt, server);
        }
    }

    public static void onPlayerLoad(class_3222 serverPlayer) {
        serverPlayer.method_5682().method_18858((Runnable)new class_3738(2, () -> {
            Set<WorldHandler.UnloadedPartyMember> party = WorldHandler.get(serverPlayer.method_5682()).getUnloadedPartyMembersFor((class_1657)serverPlayer);
            party.forEach(p -> {
                class_4208 pos = p.pos();
                class_3218 level = serverPlayer.method_14220();
                if (level.method_27983() != p.pos().method_19442()) {
                    level = serverPlayer.method_5682().method_3847(pos.method_19442());
                }
                if (level != null) {
                    level.method_14178().method_17297(class_3230.field_19280, new class_1923(pos.method_19446()), 3, (Object)pos.method_19446());
                }
            });
            party.clear();
        }));
        Set<UUID> toRemove = WorldHandler.get(serverPlayer.method_5682()).removedPartyMembersFor((class_1657)serverPlayer);
        Platform.INSTANCE.getPlayerData((class_1657)serverPlayer).ifPresent(d -> toRemove.forEach(d.party::removePartyMember));
        toRemove.clear();
    }

    public static void trackEntity(class_1657 player, class_1297 target) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (target instanceof class_1309) {
                class_1309 living = (class_1309)target;
                Platform.INSTANCE.sendToClient(new S2CEntityDataSyncAll(living), serverPlayer);
            }
        }
    }

    public static void onLoadEntity(class_1309 living) {
        if (living instanceof class_3222) {
            class_3222 player = (class_3222)living;
            EntityCalls.onPlayerLoad(player);
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> Platform.INSTANCE.sendToClient(new S2CCapSync((PlayerData)data), player));
        }
    }

    public static void updateEquipment(class_1309 entity, Map<class_1304, class_1799> changed, class_1799 lastMainhandItem, Function<class_1304, class_1799> lastArmor) {
        class_1324 inst;
        class_1799 off;
        for (class_1304 slot : class_1304.values()) {
            if (changed.containsKey(slot)) continue;
            EntityCalls.reAddAttackDamage(entity, entity.method_6118(slot), slot);
        }
        for (Map.Entry entry : changed.entrySet()) {
            if (((class_1304)entry.getKey()).method_5925() != class_1304.class_1305.field_6178) continue;
            class_1799 now = (class_1799)entry.getValue();
            class_1799 last = lastArmor.apply((class_1304)entry.getKey());
            Platform.INSTANCE.getArmorEffects(last).ifPresent(d -> d.triggerEvent(last, e -> e.onRemove(entity, last)));
            Platform.INSTANCE.getArmorEffects(now).ifPresent(d -> d.triggerEvent(now, e -> e.onEquip(entity, now)));
        }
        boolean hasWeapon = ItemNBT.isWeapon(entity.method_6047());
        float f = ItemUtils.getShieldEfficiency(entity);
        if (changed.containsKey(class_1304.field_6173) && !changed.containsKey(class_1304.field_6171)) {
            EntityCalls.recalcOffhandBonus(entity, entity.method_6079(), f);
        }
        if ((off = changed.get(class_1304.field_6171)) != null) {
            EntityCalls.recalcOffhandBonus(entity, off, f);
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            EntityUtils.sendAttributesTo((class_1309)serverPlayer, serverPlayer);
        }
        if (!hasWeapon && (inst = entity.method_5996(class_5134.field_23721)) != null) {
            for (class_1304 slot : class_1304.values()) {
                inst.method_6200(LibConstants.EQUIPMENT_MODIFIERS[slot.ordinal()]);
            }
        }
    }

    private static void reAddAttackDamage(class_1309 entity, class_1799 stack, class_1304 slot) {
        stack.method_7926(slot).get((Object)class_5134.field_23721).forEach(mod -> {
            class_1324 inst = entity.method_5996(class_5134.field_23721);
            if (inst != null) {
                inst.method_6202(mod);
                inst.method_26835(mod);
            }
        });
    }

    private static void recalcOffhandBonus(class_1309 entity, class_1799 stack, float efficiency) {
        stack.method_7926(class_1304.field_6171).forEach((att, mod) -> {
            class_1324 inst = entity.method_5996(att);
            if (inst != null) {
                inst.method_6202(mod);
                inst.method_26835(new class_1322(mod.method_6189(), mod.method_6185(), mod.method_6186() * (double)efficiency, mod.method_6182()));
            }
        });
    }

    public static boolean cancelLivingAttack(class_1282 source, class_1297 target, float amount) {
        class_1309 living;
        class_1297 attacker = source.method_5529();
        if (!source.method_5538() && target instanceof class_1657) {
            PlayerData data;
            class_1657 player = (class_1657)target;
            if (Platform.INSTANCE.getPlayerData(player).map(d -> d.getWeaponHandler().isInvulnerable((class_1309)player)).orElse(false).booleanValue()) {
                return true;
            }
            if (source.method_5526() != null && amount > 0.0f && (data = (PlayerData)Platform.INSTANCE.getPlayerData(player).orElse(null)) != null && NaiveBladeAttack.canCounter(data.getWeaponHandler())) {
                data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)ModAttackActions.NAIVE_BLADE.get()), player.method_6047(), null);
                return true;
            }
        }
        if (source instanceof CustomDamage || attacker instanceof class_1657) {
            return false;
        }
        if (attacker instanceof class_1309 && (living = (class_1309)attacker).method_6047().method_31573(RunecraftoryTags.UPGRADABLE_HELD) && !living.method_5864().method_20210(RunecraftoryTags.HELD_WEAPON_EXEMPT)) {
            CombatUtils.mobAttack(living, target);
            return true;
        }
        return false;
    }

    public static boolean playerAttack(class_1657 player, class_1297 target) {
        if (!player.field_6002.field_9236 && ItemNBT.isWeapon(player.method_6047())) {
            CombatUtils.playerAttackWithItem(player, target, true, true);
            return true;
        }
        return false;
    }

    public static boolean playerAoeAttack(class_1657 player, class_1799 stack, List<class_1297> list) {
        if (ItemNBT.isWeapon(stack)) {
            for (int i = 0; i < list.size(); ++i) {
                CombatUtils.playerAttackWithItem(player, list.get(i), i == list.size() - 1, i == list.size() - 1);
            }
            return true;
        }
        return false;
    }

    public static boolean playerDeath(class_1309 entity, class_1282 source) {
        if (!entity.field_6002.field_9236) {
            Object object;
            if (!source.method_5538()) {
                class_1657 player;
                class_1799 deathProt = class_1799.field_8037;
                for (class_1799 stack : entity.method_5743()) {
                    if (stack.method_7909() != ModItems.LAWN.get()) continue;
                    deathProt = stack;
                }
                if (deathProt.method_7960() && entity instanceof class_1657) {
                    player = (class_1657)entity;
                    object = player.method_31548().field_7547.iterator();
                    while (object.hasNext()) {
                        class_1799 stack = (class_1799)object.next();
                        if (stack.method_7909() != ModItems.LAWN.get()) continue;
                        deathProt = stack;
                    }
                }
                if (!deathProt.method_7960()) {
                    if (entity instanceof class_3222) {
                        player = (class_3222)entity;
                        player.method_7259(class_3468.field_15372.method_14956((Object)deathProt.method_7909()));
                        class_174.field_1198.method_8821((class_3222)player, deathProt);
                    }
                    entity.method_6033(entity.method_6063() * 0.33f);
                    entity.method_6012();
                    entity.method_6092(new class_1293(class_1294.field_5907, 5, 100));
                    entity.field_6002.method_8421((class_1297)entity, (byte)35);
                    deathProt.method_7934(1);
                    return true;
                }
            }
            if (MobConfig.vanillaGiveXp && entity instanceof class_1308) {
                class_1308 m = (class_1308)entity;
                if (!(entity instanceof IBaseMob) && (object = source.method_5529()) instanceof class_1309) {
                    class_1309 attacker = (class_1309)object;
                    LevelCalc.addXP(attacker, (int)Math.log(m.method_6063() + 1.0f) * 10, 0, 0, false);
                }
            }
        }
        return false;
    }

    public static void dropInventoryDeath(class_1309 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (!player.field_6002.method_8450().method_8355(class_1928.field_19389)) {
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.getInv().dropItemsAt((class_1309)player));
            }
        }
    }

    public static void clone(class_1657 origin, class_1657 player, boolean death) {
        if (player instanceof class_3222) {
            Platform.INSTANCE.getPlayerData(origin).ifPresent(data -> {
                if (death) {
                    data.useMoney(origin, (int)((double)data.getMoney() * 0.2));
                }
                Platform.INSTANCE.getPlayerData(player).ifPresent(newData -> newData.readFromNBT(data.writeToNBT(new class_2487(), origin, death), player));
            });
        }
    }

    public static void cropRightClickHarvest(class_1657 player, class_2680 state, class_2338 pos, class_1268 hand) {
        class_2248 class_22482;
        if (!player.field_6002.field_9236 && (class_22482 = state.method_26204()) instanceof class_2302) {
            class_2302 crop = (class_2302)class_22482;
            class_1799 stack = player.method_5998(hand);
            if (stack.method_31573(RunecraftoryTags.QUICKHARVEST_BYPASS)) {
                return;
            }
            if (crop.method_9825(state)) {
                CropProperties props = CropUtils.getPropertiesFor(crop);
                CropUtils.harvestCropRightClick(state, player.field_6002, pos, (class_1297)player, player.method_6047(), props, hand, null);
            }
        }
    }

    public static boolean onTryBonemeal(class_1937 level, class_1799 stack, class_2680 state, class_2338 pos, @Nullable class_1657 player) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_2338 targetPos = null;
            boolean swing = false;
            if (state.method_26204() instanceof Growable) {
                class_2338 below;
                CropProperties props = DataPackHandler.INSTANCE.cropManager().get(state.method_26204().method_9574((class_1922)level, pos, state).method_7909());
                if (props != null && FarmlandHandler.isFarmBlock(level.method_8320(below = pos.method_10074()))) {
                    targetPos = below;
                }
                swing = !(state.method_26204() instanceof class_2256);
            } else if (FarmlandHandler.isFarmBlock(state)) {
                targetPos = pos;
                swing = true;
            }
            if (targetPos != null) {
                class_2338 target = targetPos;
                if (player != null && swing) {
                    player.method_23667(player.method_6079().equals(stack) ? class_1268.field_5810 : class_1268.field_5808, true);
                }
                FarmlandHandler.get(serverLevel.method_8503()).getData(serverLevel, target).ifPresent(d -> {
                    if (d.canUseBonemeal()) {
                        d.applyBonemeal(serverLevel);
                        stack.method_7934(1);
                        Platform.INSTANCE.sendToAll(new S2CTriggers(S2CTriggers.Type.FERTILIZER, target), level.method_8503());
                    }
                });
                return true;
            }
        }
        return player == null && FarmlandHandler.isFarmBlock(state);
    }

    public static void updateLivingTick(class_1309 entity) {
        class_1308 mob;
        boolean disabled;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> data.tick(player));
            if (GeneralConfig.disableHunger) {
                int food = EntityUtils.paralysed((class_1309)player) ? 6 : 14;
                player.method_7344().method_7580(food);
                player.method_7344().method_7581(0.0f);
            }
        }
        for (class_1657 slot : class_1304.values()) {
            class_1799 stack;
            if (slot.method_5925() != class_1304.class_1305.field_6178 || (stack = entity.method_6118((class_1304)slot)).method_7960()) continue;
            Platform.INSTANCE.getArmorEffects(stack).ifPresent(d -> d.triggerEvent(stack, e -> e.onTick(entity, stack)));
        }
        if (entity instanceof class_1308 && (disabled = EntityUtils.isDisabled((class_1309)(mob = (class_1308)entity))) && !mob.method_5942().method_6357()) {
            mob.method_5942().method_6340();
        }
    }

    public static boolean rootTick(class_1309 entity) {
        if (entity instanceof class_1657) {
            return false;
        }
        if (Platform.INSTANCE.getEntityData(entity).map(EntityData::isStunned).orElse(false).booleanValue()) {
            ((LivingEntityAccessor)entity).tickEffectsManually();
            return true;
        }
        return false;
    }

    public static void foodHandling(class_1309 entity, class_1799 stack) {
        if (!entity.field_6002.field_9236) {
            if (entity instanceof IBaseMob) {
                IBaseMob mob = (IBaseMob)entity;
                mob.applyFoodEffect(stack);
                return;
            }
            FoodProperties prop = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909());
            if (prop == null) {
                if (entity instanceof class_3222) {
                    class_3222 player = (class_3222)entity;
                    if (stack.method_19267()) {
                        Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                            LevelCalc.levelSkill(player, data, EnumSkills.EATING, 5.0f);
                            data.refreshRunePoints((class_1657)player, EntityUtils.getRPFromVanillaFood(stack));
                        });
                    }
                }
                return;
            }
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                    if (data.foodBuffDuration() <= 0) {
                        data.getDailyUpdater().onFoodEaten(player);
                    }
                    data.applyFoodEffect((class_1657)player, stack);
                    data.refreshRunePoints((class_1657)player, prop.getRPRegen() + (int)((double)(data.getMaxRunePoints() * prop.getRpPercentRegen()) * 0.01));
                });
            }
            Pair<Map<class_1320, Double>, Map<class_1320, Double>> map = ItemNBT.foodStats(stack);
            int healthGain = ((Map)map.getFirst()).getOrDefault(ModAttributes.HEALTHGAIN.get(), 0.0).intValue();
            EntityUtils.foodHealing(entity, healthGain);
            int healthPercent = ((Map)map.getSecond()).getOrDefault(ModAttributes.HEALTHGAIN.get(), 0.0).intValue();
            EntityUtils.foodHealing(entity, entity.method_6063() * (float)healthPercent * 0.01f);
            if (prop.potionHeals() != null) {
                for (class_1291 class_12912 : prop.potionHeals()) {
                    entity.method_6016(class_12912);
                }
            }
            if (prop.potionApply() != null) {
                for (SimpleEffect simpleEffect : prop.potionApply()) {
                    entity.method_6092(simpleEffect.create());
                }
            }
        }
    }

    public static void wakeUp(class_1657 player) {
        if (GeneralConfig.healOnWakeUp && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            player.method_6025(player.method_6063());
            Platform.INSTANCE.getPlayerData((class_1657)serverPlayer).ifPresent(data -> {
                data.refreshRunePoints(player, data.getMaxRunePoints());
                LevelCalc.levelSkill(serverPlayer, data, EnumSkills.SLEEPING, 75.0f);
            });
            player.method_6016((class_1291)ModEffects.FATIGUE.get());
        }
    }

    public static boolean disableNatural(class_3730 spawnType, class_1299<?> entity) {
        if (MobConfig.disableNaturalSpawn) {
            return (spawnType == class_3730.field_16472 || spawnType == class_3730.field_16459) && entity != ModEntities.GATE.get();
        }
        return false;
    }

    public static float damageCalculation(class_1309 entity, class_1282 source, float dmg) {
        float damage = CombatUtils.reduceDamageFromStats(entity, source, dmg);
        if (damage < 0.0f) {
            entity.method_6025(-damage);
        } else if (damage > 1.0f && source != class_1282.field_5849 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.DEFENCE, Math.min(7.0f, (float)(0.5 + Math.log((double)damage * 0.25))) * 1.5f));
        }
        return damage;
    }

    public static void postDamage(class_1309 entity, class_1282 src, float amount) {
        class_1309 living;
        float drainPercent;
        class_1297 attacker = src.method_5529();
        if (attacker instanceof class_1309) {
            entity.method_6016((class_1291)ModEffects.SLEEP.get());
        }
        if (amount > 0.0f && attacker instanceof class_1309 && (drainPercent = (float)CombatUtils.statusEffectValue(living = (class_1309)attacker, (class_1320)ModAttributes.DRAIN.get(), (class_1297)entity)) > 0.0f) {
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                player.method_6025(drainPercent * amount);
            } else {
                living.method_6025(drainPercent * amount);
            }
        }
    }

    public static void onBlockBreak(class_3222 player, class_2680 state, class_2338 pos) {
        if (state.method_26204() instanceof class_2302) {
            ModCriteria.HARVEST_CROP.trigger(player, state);
        }
        if (!player.method_7305(state)) {
            return;
        }
        if (state.method_26164(RunecraftoryTags.HAMMER_BREAKABLE)) {
            ItemToolHammer.onHammering(player, true);
        } else if (state.method_26164(class_3481.field_33715)) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.MINING, state.method_26204() instanceof BlockMineral ? 10.0f : 1.0f));
        }
        if (state.method_26164(class_3481.field_33713)) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.LOGGING, 1.0f));
        }
        if (state.method_26164(class_3481.field_33714) && !(player.method_6047().method_7909() instanceof ItemToolSickle)) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 1.0f));
        }
        if (state.method_26204() instanceof class_2261) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 0.5f));
        }
    }

    public static void onLootTableBlockGen(class_1657 player, class_2586 blockEntity) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> LevelCalc.levelSkill(serverPlayer, data, EnumSkills.SEARCHING, 7.0f));
        }
    }

    public static boolean shouldPreventFarmlandTrample(class_1297 entity, class_1936 world) {
        return GeneralConfig.disableFarmlandTrample;
    }

    public static boolean onPlayerUseItem(class_1657 player, class_1268 hand) {
        return Platform.INSTANCE.getPlayerData(player).map(d -> d.getWeaponHandler().getCurrentAction() == ModAttackActions.NONE.get() || class_1799.method_31577((class_1799)player.method_5998(hand), (class_1799)d.getWeaponHandler().get(DataKey.USED_WEAPON))).orElse(true);
    }
}

