/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.blocks.tile.CraftingBlockEntity;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.crafting.SpecialSextupleRecipe;
import io.github.flemmli97.runecraftory.common.inventory.DummyInventory;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.inventory.container.CraftingOutputSlot;
import io.github.flemmli97.runecraftory.common.network.S2CCraftingRecipes;
import io.github.flemmli97.runecraftory.common.registry.ModContainer;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.mixin.AbstractContainerMenuAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import net.minecraft.class_3915;
import net.minecraft.class_3917;

public class ContainerCrafting
extends class_1703 {
    private final PlayerContainerInv craftingInv;
    private final EnumCrafting type;
    private final DummyInventory outPutInv;
    private final CraftingBlockEntity tile;
    private final class_3915 rpCost;
    private List<SextupleRecipe> matchingRecipes;
    private List<Pair<Integer, class_1799>> matchingRecipesClient = new ArrayList<Pair<Integer, class_1799>>();
    private boolean updatedRecipes;
    private boolean init = true;
    private SextupleRecipe currentRecipe;

    public ContainerCrafting(int windowId, class_1661 inv, class_2540 data) {
        this(windowId, inv, ContainerCrafting.getTile(inv.field_7546.field_6002, data));
    }

    public ContainerCrafting(int windowID, class_1661 playerInv, CraftingBlockEntity tile) {
        super((class_3917)ModContainer.CRAFTING_CONTAINER.get(), windowID);
        int i;
        this.outPutInv = new DummyInventory((class_1263)new class_1277(2));
        this.craftingInv = PlayerContainerInv.create(this, tile.getInventory(), playerInv.field_7546);
        this.tile = tile;
        this.type = tile.craftingType();
        this.method_7621(new CraftingOutputSlot(this.outPutInv, this, this.craftingInv, 0, 116, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.method_7621(new class_1735((class_1263)playerInv, k, 8 + k * 18, 142));
        }
        for (i = 0; i < 3; ++i) {
            this.method_7621(new class_1735((class_1263)this.craftingInv, i, 20 + i * 18, 26));
            this.method_7621(new class_1735((class_1263)this.craftingInv, i + 3, 20 + i * 18, 44));
        }
        this.rpCost = class_3915.method_17403();
        this.method_17362(this.rpCost);
        this.initCraftingMatrix(this.craftingInv);
        this.init = false;
    }

    public static List<SextupleRecipe> getRecipes(PlayerContainerInv inv, EnumCrafting type) {
        class_1657 class_16572 = inv.getPlayer();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            List recipes = serverPlayer.method_5682().method_3772().method_17877(CraftingUtils.getType(type), (class_1263)inv, (class_1937)serverPlayer.method_14220());
            recipes.sort(Comparator.comparingInt(SextupleRecipe::getCraftingLevel));
            return recipes;
        }
        return new ArrayList<SextupleRecipe>();
    }

    public static CraftingBlockEntity getTile(class_1937 world, class_2540 buffer) {
        class_2586 blockEntity = world.method_8321(buffer.method_10811());
        if (blockEntity instanceof CraftingBlockEntity) {
            return (CraftingBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Expected tile entity of type TileCrafting but got " + String.valueOf(blockEntity));
    }

    public EnumCrafting craftingType() {
        return this.type;
    }

    private void initCraftingMatrix(class_1263 inv) {
        if (inv == this.craftingInv) {
            this.updateCraftingOutput(true);
        }
    }

    public void updateCraftingOutput(boolean init) {
        if (this.craftingInv.getPlayer().field_6002.field_9236) {
            return;
        }
        if (this.craftingInv.refreshAndSet()) {
            this.matchingRecipes = ContainerCrafting.getRecipes(this.craftingInv, this.type);
            if (this.matchingRecipes.isEmpty()) {
                SpecialSextupleRecipe recipe;
                this.matchingRecipes = new ArrayList<SextupleRecipe>();
                switch (this.type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ARMOR: 
                    case FORGE: {
                        SpecialSextupleRecipe specialSextupleRecipe = SpecialSextupleRecipe.SCRAP.get();
                        break;
                    }
                    case CHEM: {
                        SpecialSextupleRecipe specialSextupleRecipe = SpecialSextupleRecipe.OBJECT_X.get();
                        break;
                    }
                    case COOKING: {
                        SpecialSextupleRecipe specialSextupleRecipe = recipe = SpecialSextupleRecipe.FAILED_DISH.get();
                    }
                }
                if (recipe.matches(this.craftingInv, this.craftingInv.getPlayer().field_6002)) {
                    this.matchingRecipes.add(recipe);
                }
            }
            this.updatedRecipes = true;
            if (!init) {
                this.tile.resetIndex();
            }
        }
        this.updateCraftingSlot();
    }

    private void updateCraftingSlot() {
        class_1799 clientOutput;
        class_1799 trueOutput;
        if (this.matchingRecipes != null && !this.matchingRecipes.isEmpty()) {
            if (this.updatedRecipes) {
                if (this.currentRecipe != null) {
                    int i;
                    for (i = this.matchingRecipes.size() - 1; i > 0 && !this.currentRecipe.equals(this.matchingRecipes.get(i)); --i) {
                    }
                    this.tile.setIndex(i);
                } else if (!this.init || this.tile.craftingIndex() >= this.matchingRecipes.size()) {
                    this.tile.resetIndex();
                }
            }
            this.currentRecipe = this.matchingRecipes.get(this.tile.craftingIndex());
            SextupleRecipe.RecipeOutput output = this.currentRecipe.getCraftingOutput(this.craftingInv);
            this.rpCost.method_17404(CraftingUtils.craftingCost(this.type, Platform.INSTANCE.getPlayerData(this.craftingInv.getPlayer()).orElseThrow(EntityUtils::playerDataException), this.currentRecipe, output.bonusItems(), output.clientResult().method_7909() != ModItems.UNKNOWN.get()));
            trueOutput = output.serverResult();
            clientOutput = output.clientResult();
        } else {
            trueOutput = class_1799.field_8037;
            clientOutput = class_1799.field_8037;
            this.rpCost.method_17404(-1);
            this.currentRecipe = null;
        }
        this.outPutInv.method_5447(0, trueOutput);
        this.outPutInv.method_5447(1, clientOutput);
        class_1657 class_16572 = this.craftingInv.getPlayer();
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            if (this.updatedRecipes) {
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> this.sendCraftingRecipesToClient(player, (PlayerData)data));
            }
            player.field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.method_37422(), 0, clientOutput));
        }
        this.updatedRecipes = false;
    }

    public void sendCraftingRecipesToClient(class_3222 player, PlayerData data) {
        List<Pair<Integer, class_1799>> clientData = IntStream.range(0, this.matchingRecipes.size()).mapToObj(i -> {
            SextupleRecipe recipe = this.matchingRecipes.get(i);
            return Pair.of((Object)i, (Object)(recipe instanceof SpecialSextupleRecipe || data.getRecipeKeeper().isUnlocked(recipe) ? this.matchingRecipes.get(i).method_8110() : new class_1799((class_1935)ModItems.UNKNOWN.get())));
        }).toList();
        if (!this.init) {
            Platform.INSTANCE.sendToClient(new S2CCraftingRecipes(clientData, 0), player);
        } else {
            player.method_5682().method_18858((Runnable)new class_3738(1, () -> Platform.INSTANCE.sendToClient(new S2CCraftingRecipes(clientData, this.currentRecipe == null ? 0 : this.matchingRecipes.indexOf(this.currentRecipe)), player)));
        }
    }

    public SextupleRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void updateCurrentRecipeIndex(int id) {
        id = class_3532.method_15340((int)id, (int)0, (int)(this.matchingRecipes != null ? this.matchingRecipes.size() - 1 : 0));
        this.tile.setIndex(id);
        this.updateCraftingSlot();
    }

    public int rpCost() {
        return this.rpCost.method_17407();
    }

    public void method_7623() {
        int i;
        AbstractContainerMenuAccessor acc = (AbstractContainerMenuAccessor)((Object)this);
        for (i = 0; i < this.field_7761.size(); ++i) {
            class_1799 class_17992;
            class_1735 slot = (class_1735)this.field_7761.get(i);
            if (slot instanceof CraftingOutputSlot) {
                CraftingOutputSlot outputSlot = (CraftingOutputSlot)slot;
                class_17992 = outputSlot.getStackToSync();
            } else {
                class_17992 = ((class_1735)this.field_7761.get(i)).method_7677();
            }
            class_1799 itemStack = class_17992;
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((class_1799)itemStack).method_7972());
            acc.doTriggerSlotListeners(i, itemStack, (Supplier<class_1799>)supplier);
            acc.doSynchronizeSlotToRemote(i, itemStack, (Supplier<class_1799>)supplier);
        }
        acc.doSynchronizeCarriedToRemote();
        for (i = 0; i < acc.getDataSlots().size(); ++i) {
            class_3915 dataSlot = acc.getDataSlots().get(i);
            int j = dataSlot.method_17407();
            if (dataSlot.method_17408()) {
                acc.doUpdateDataSlotListeners(i, j);
            }
            acc.doSynchronizeDataSlotToRemote(i, j);
        }
    }

    public void method_34252() {
        int i;
        AbstractContainerMenuAccessor acc = (AbstractContainerMenuAccessor)((Object)this);
        for (i = 0; i < this.field_7761.size(); ++i) {
            class_1799 class_17992;
            class_1735 slot = (class_1735)this.field_7761.get(i);
            if (slot instanceof CraftingOutputSlot) {
                CraftingOutputSlot outputSlot = (CraftingOutputSlot)slot;
                class_17992 = outputSlot.getStackToSync();
            } else {
                class_17992 = ((class_1735)this.field_7761.get(i)).method_7677();
            }
            class_1799 itemStack = class_17992;
            this.method_34245(i, itemStack.method_7972());
        }
        this.method_34250(this.method_34255());
        for (i = 0; i < acc.getDataSlots().size(); ++i) {
            acc.getRemoteDataSlots().set(i, acc.getDataSlots().get(i).method_17407());
        }
        if (acc.getSynchronizer() != null) {
            acc.getSynchronizer().method_34263((class_1703)this, acc.getRemoteSlots(), acc.getRemoteCarried(), acc.getRemoteDataSlots().toIntArray());
        }
    }

    public class_1799 method_7601(class_1657 player, int slotID) {
        if (!player.method_5805()) {
            return class_1799.field_8037;
        }
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotID);
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            if (slotID == 0) {
                itemstack1.method_7982(player.field_6002, player, itemstack1.method_7947());
                Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.onCrafted(player));
                if (!this.method_7616(itemstack1, 1, 37, false)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemstack);
            } else if (slotID < 37 ? !this.method_7616(itemstack1, 37, this.field_7761.size(), false) : !this.method_7616(itemstack1, 1, 37, false)) {
                return class_1799.field_8037;
            }
            if (itemstack1.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemstack1);
            if (slotID == 0) {
                player.method_7328(itemstack1, false);
            }
        }
        return itemstack;
    }

    public void method_7595(class_1657 entity) {
        super.method_7595(entity);
    }

    public void method_7609(class_1263 inv) {
        if (inv == this.craftingInv) {
            this.updateCraftingOutput(false);
        }
        super.method_7609(inv);
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public List<Pair<Integer, class_1799>> getMatchingRecipesClient() {
        return this.matchingRecipesClient;
    }

    public void setMatchingRecipesClient(List<Pair<Integer, class_1799>> matchingRecipesClient) {
        this.matchingRecipesClient = matchingRecipesClient;
    }
}

