/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;

public class CraftingOutputSlot
extends class_1735 {
    private final PlayerContainerInv ingredientInv;
    private final ContainerCrafting craftingContainer;
    private int amountCrafted;
    private final int id;

    public CraftingOutputSlot(class_1263 output, ContainerCrafting container, PlayerContainerInv ingredientInv, int id, int x, int y) {
        super(output, id, x, y);
        this.ingredientInv = ingredientInv;
        this.craftingContainer = container;
        this.id = id;
    }

    public class_1799 getStackToSync() {
        return this.field_7871.method_5438(this.id + 1);
    }

    protected void method_7678(class_1799 stack, int amount) {
        this.amountCrafted += amount;
        this.method_7669(stack);
    }

    protected void method_7672(int amount) {
        super.method_7672(amount);
        this.amountCrafted += amount;
    }

    protected void method_7669(class_1799 stack) {
        class_1657 player = this.ingredientInv.getPlayer();
        if (this.amountCrafted > 0) {
            stack.method_7982(player.field_6002, player, this.amountCrafted);
            Platform.INSTANCE.craftingEvent(player, stack, this.ingredientInv);
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.onCrafted(player));
        }
        this.amountCrafted = 0;
    }

    public void method_7667(class_1657 player, class_1799 stack) {
        class_2371 remaining;
        this.method_7669(stack);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_2371 class_23712 = remaining = this.craftingContainer.getCurrentRecipe() != null ? this.craftingContainer.getCurrentRecipe().method_8111(this.ingredientInv) : class_2371.method_10213((int)0, (Object)class_1799.field_8037);
        if (this.craftingContainer.rpCost() >= 0) {
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> {
                data.decreaseRunePoints(player, this.craftingContainer.rpCost(), true);
                SextupleRecipe recipe = this.craftingContainer.getCurrentRecipe();
                if (recipe != null && !recipe.method_8118() && !data.getRecipeKeeper().isUnlocked(recipe)) {
                    data.getRecipeKeeper().unlockRecipe(player, recipe);
                    this.craftingContainer.sendCraftingRecipesToClient(serverPlayer, (PlayerData)data);
                }
                switch (this.craftingContainer.craftingType()) {
                    case FORGE: {
                        CraftingUtils.giveCraftingXPTo(serverPlayer, data, EnumSkills.FORGING, this.craftingContainer.getCurrentRecipe());
                        break;
                    }
                    case ARMOR: {
                        CraftingUtils.giveCraftingXPTo(serverPlayer, data, EnumSkills.CRAFTING, this.craftingContainer.getCurrentRecipe());
                        break;
                    }
                    case CHEM: {
                        CraftingUtils.giveCraftingXPTo(serverPlayer, data, EnumSkills.CHEMISTRY, this.craftingContainer.getCurrentRecipe());
                        break;
                    }
                    case COOKING: {
                        CraftingUtils.giveCraftingXPTo(serverPlayer, data, EnumSkills.COOKING, this.craftingContainer.getCurrentRecipe());
                    }
                }
            });
        }
        if (ItemNBT.usedLightOre(stack)) {
            ModCriteria.LIGHT_ORE.trigger(serverPlayer);
        }
        switch (this.craftingContainer.craftingType()) {
            case FORGE: {
                ModCriteria.FORGING.trigger(serverPlayer);
                break;
            }
            case ARMOR: {
                ModCriteria.CRAFTING.trigger(serverPlayer);
                break;
            }
            case CHEM: {
                ModCriteria.MEDICINE.trigger(serverPlayer);
                break;
            }
            case COOKING: {
                ModCriteria.COOKING.trigger(serverPlayer);
            }
        }
        boolean refreshRecipe = false;
        for (int i = 0; i < remaining.size(); ++i) {
            class_1799 itemstack = this.ingredientInv.method_5438(i);
            class_1799 remainingStack = (class_1799)remaining.get(i);
            if (!itemstack.method_7960()) {
                this.ingredientInv.method_5434(i, 1);
                itemstack = this.ingredientInv.method_5438(i);
                if (itemstack.method_7960()) {
                    refreshRecipe = true;
                }
            }
            if (remainingStack.method_7960()) continue;
            if (itemstack.method_7960()) {
                this.ingredientInv.method_5447(i, remainingStack);
                continue;
            }
            if (class_1799.method_7984((class_1799)itemstack, (class_1799)remainingStack) && class_1799.method_7975((class_1799)itemstack, (class_1799)remainingStack)) {
                remainingStack.method_7933(itemstack.method_7947());
                this.ingredientInv.method_5447(i, remainingStack);
                continue;
            }
            if (player.method_31548().method_7394(remainingStack)) continue;
            player.method_7328(remainingStack, false);
        }
        if (refreshRecipe) {
            this.craftingContainer.method_7609(this.ingredientInv);
        }
        super.method_7667(player, stack);
    }

    public boolean method_7680(class_1799 stack) {
        return false;
    }

    public class_1799 method_7671(int amount) {
        if (this.method_7681()) {
            this.amountCrafted += Math.min(amount, this.method_7677().method_7947());
        }
        return super.method_7671(amount);
    }

    public boolean method_7674(class_1657 player) {
        if (!GeneralConfig.useRp) {
            return true;
        }
        return player.method_7337() || Platform.INSTANCE.getPlayerData(player).map(data -> data.getMaxRunePoints() >= this.craftingContainer.rpCost()).orElse(false) != false;
    }
}

