/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.creative;

import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.items.creative.RuneCraftoryEggItem;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class NPCSpawnEgg
extends RuneCraftoryEggItem {
    public static final String NPC_ID = "NPCId";
    public static final String NPC_SHOP = "Shop";

    public NPCSpawnEgg(Supplier<? extends class_1299<? extends class_1308>> type, class_1792.class_1793 props) {
        super(type, 4532232, 8211477, props);
    }

    public boolean addToDefaultSpawneggs() {
        return false;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((class_2561)new class_2588("runecraftory.tooltip.item.npc").method_27692(class_124.field_1065));
        tooltipComponents.add((class_2561)new class_2588(NPCSpawnEgg.getJob(stack).getTranslationKey()).method_27692(class_124.field_1075));
    }

    @Override
    public boolean onEntitySpawned(class_1297 e, class_1799 stack, class_1657 player) {
        if (e instanceof EntityNPCBase) {
            NPCData data;
            EntityNPCBase npc = (EntityNPCBase)e;
            class_2960 id = NPCSpawnEgg.getNpcID(stack);
            if (id != null && (data = DataPackHandler.INSTANCE.npcDataManager().get(id)) != null) {
                npc.setNPCData(data, false);
                return super.onEntitySpawned(e, stack, player);
            }
            NPCJob job = NPCSpawnEgg.getJob(stack);
            if (job != ModNPCJobs.NONE.getSecond()) {
                npc.randomizeData(job, true);
            }
        }
        return super.onEntitySpawned(e, stack, player);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            class_1799 stack = player.method_5998(hand);
            if (!world.field_9236) {
                NPCSpawnEgg.next(stack);
            }
            return class_1271.method_22428((Object)stack);
        }
        return super.method_7836(world, player, hand);
    }

    public static NPCJob getJob(class_1799 stack) {
        NPCJob job = (NPCJob)ModNPCJobs.NONE.getSecond();
        if (stack.method_7985() && stack.method_7969().method_10545(NPC_SHOP)) {
            job = ModNPCJobs.getFromID(new class_2960(stack.method_7969().method_10558(NPC_SHOP)));
        }
        return job;
    }

    public static void setNpcID(class_1799 stack, class_2960 id) {
        class_2487 tag = stack.method_7948();
        if (id == null) {
            tag.method_10551(NPC_ID);
        } else {
            tag.method_10582(NPC_ID, id.toString());
        }
    }

    public static class_2960 getNpcID(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545(NPC_ID)) {
            return new class_2960(stack.method_7969().method_10558(NPC_ID));
        }
        return null;
    }

    public static void next(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        List<NPCJob> jobs = ModNPCJobs.allJobs();
        NPCJob current = NPCSpawnEgg.getJob(stack);
        tag.method_10582(NPC_SHOP, ModNPCJobs.getIDFrom(jobs.get((jobs.indexOf(current) + 1) % jobs.size())).toString());
    }
}

