/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.ToolUseData;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1814;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class ItemToolHammer
extends class_1810
implements IItemUsable {
    public final EnumToolTier tier;

    public ItemToolHammer(EnumToolTier tier, class_1792.class_1793 props) {
        super(ItemTiers.TIER, 0, 0.0f, props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(class_3222 player) {
    }

    public static void onHammering(class_3222 player, boolean level) {
        if (ItemToolHammer.getUseRPFlag(player.method_6047())) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                LevelCalc.useRP((class_1657)player, data, 5.0f, true, 0.0f, true, EnumSkills.MINING);
                if (level) {
                    LevelCalc.levelSkill(player, data, EnumSkills.MINING, 10.0f);
                }
            });
        }
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseDuration) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int duration = stack.method_7935() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.field_13987.method_14364((class_2596)new class_2767(class_3417.field_14776, player.method_5634(), player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f));
            }
        }
    }

    public class_1269 method_7884(class_1838 ctx) {
        if (this.tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx, false);
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (this.tier.getTierLevel() != 0) {
            player.method_6019(hand);
            return class_1271.method_22428((Object)itemstack);
        }
        return class_1271.method_22430((Object)itemstack);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public boolean method_7879(class_1799 stack, class_1937 level, class_2680 state, class_2338 pos, class_1309 miningEntity) {
        return super.method_7879(stack, level, state, pos, miningEntity);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 entity, int timeLeft) {
        if (this.tier.getTierLevel() != 0 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                int useTime = data.getWeaponHandler().canExecuteAction((AttackAction)((Object)((Object)ModAttackActions.TOOL_HAMMER_USE.get())), false) ? data.getWeaponHandler().get(DataKey.TOOL_DATA).charge() : (stack.method_7935() - timeLeft - 1) / ItemUtils.getChargeTime(entity, this.tier);
                int range = Math.min(useTime, this.tier.getTierLevel());
                class_3965 result = ItemToolHammer.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348);
                if (range == 0) {
                    if (result != null) {
                        this.useOnBlock(new class_1838((class_1657)entity, entity.method_6058(), result), false);
                    }
                } else {
                    data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.TOOL_HAMMER_USE.get())), stack);
                    data.getWeaponHandler().store(DataKey.TOOL_DATA, new ToolUseData((class_239)result, range));
                }
            });
        }
        super.method_7840(stack, world, entity, timeLeft);
    }

    public static void setDontUseRPFlagTemp(class_1799 stack, boolean flag) {
        if (flag) {
            stack.method_7948().method_10556("RFInUseFlag", true);
        } else {
            stack.method_7948().method_10551("RFInUseFlag");
            if (stack.method_7969().method_33133()) {
                stack.method_7980(null);
            }
        }
    }

    private static boolean getUseRPFlag(class_1799 stack) {
        if (stack.method_7985()) {
            return !stack.method_7948().method_10577("RFInUseFlag");
        }
        return true;
    }

    public class_1814 method_7862(class_1799 stack) {
        return this.tier == EnumToolTier.PLATINUM ? class_1814.field_8904 : class_1814.field_8906;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    private class_1269 useOnBlock(class_1838 ctx, boolean canHammer) {
        class_1657 class_16572 = ctx.method_8036();
        if (!(class_16572 instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)class_16572;
        class_1799 stack = ctx.method_8041();
        HammerState state = this.hammer((class_3218)ctx.method_8045(), ctx.method_8037(), stack, (class_1309)ctx.method_8036(), canHammer);
        if (state != HammerState.FAIL) {
            ItemToolHammer.setDontUseRPFlagTemp(stack, false);
            ItemToolHammer.onHammering(player, state == HammerState.BREAK);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HammerState hammer(class_3218 world, class_2338 pos, class_1799 stack, class_1309 entity, boolean canHammer) {
        if (entity instanceof class_1657 && !((class_1657)entity).method_7343(pos.method_10093(class_2350.field_11036), class_2350.field_11036, stack)) {
            return HammerState.FAIL;
        }
        class_2680 state = world.method_8320(pos);
        if (canHammer && state.method_26164(RunecraftoryTags.HAMMER_BREAKABLE)) {
            if (!(entity instanceof class_3222)) return world.method_30093(pos, true, (class_1297)entity, 3) ? HammerState.BREAK : HammerState.FAIL;
            class_3222 serverPlayer = (class_3222)entity;
            if (!((class_3222)entity).field_13974.method_14266(pos)) return HammerState.FAIL;
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
            serverPlayer.field_13987.method_14364((class_2596)new class_2626(pos, world.method_8320(pos)));
            return HammerState.BREAK;
        }
        if (!state.method_26164(RunecraftoryTags.HAMMER_FLATTENABLE) || world.method_8320(pos.method_10084()).method_26207() != class_3614.field_15959 || !world.method_8501(pos, class_2248.method_9582((class_2680)state, (class_2680)class_2246.field_10566.method_9564(), (class_1937)world, (class_2338)pos))) return HammerState.FAIL;
        world.method_8465(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15026, class_3419.field_15245, 1.0f, 1.0f);
        return HammerState.FLATTEN;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public static enum HammerState {
        FAIL,
        BREAK,
        FLATTEN;

    }
}

