/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class ItemToolSickle
extends class_1766
implements IItemUsable {
    public final EnumToolTier tier;

    public ItemToolSickle(EnumToolTier tier, class_1792.class_1793 props) {
        super(0.0f, 0.0f, ItemTiers.TIER, RunecraftoryTags.SICKLE_EFFECTIVE, props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(class_3222 player) {
        Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
            LevelCalc.useRP((class_1657)player, data, 2.0f, true, 0.0f, true, EnumSkills.FARMING, EnumSkills.WIND);
            LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 3.0f);
            LevelCalc.levelSkill(player, data, EnumSkills.WIND, 2.0f);
        });
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (state.method_26164(class_3481.field_15503) || state.method_26164(class_3481.field_21954)) {
            return this.field_7940;
        }
        return super.method_7865(stack, state);
    }

    public boolean method_7879(class_1799 stack, class_1937 level, class_2680 state, class_2338 pos, class_1309 entityLiving) {
        if (entityLiving instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entityLiving;
            if (this.method_7865(stack, state) == this.field_7940) {
                Platform.INSTANCE.getPlayerData((class_1657)serverPlayer).ifPresent(data -> {
                    LevelCalc.levelSkill(serverPlayer, data, EnumSkills.FARMING, 3.0f);
                    LevelCalc.levelSkill(serverPlayer, data, EnumSkills.WIND, 2.0f);
                });
            }
        }
        return super.method_7879(stack, level, state, pos, entityLiving);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseDuration) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int duration = stack.method_7935() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.field_13987.method_14364((class_2596)new class_2767(class_3417.field_14776, player.method_5634(), player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f));
            }
        }
    }

    public class_1269 method_7884(class_1838 ctx) {
        if (this.tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx);
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemstack = player.method_5998(usedHand);
        if (this.tier.getTierLevel() != 0) {
            player.method_6019(usedHand);
            return class_1271.method_22428((Object)itemstack);
        }
        return class_1271.method_22430((Object)itemstack);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeLeft) {
        if (this.tier.getTierLevel() != 0 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int useTime = (stack.method_7935() - timeLeft - 1) / ItemUtils.getChargeTime(entity, this.tier);
            int range = Math.min(useTime, this.tier.getTierLevel()) + 2;
            class_3965 result = ItemToolSickle.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348);
            if (range == 0) {
                if (result != null) {
                    this.useOnBlock(new class_1838((class_1657)player, entity.method_6058(), result));
                }
            } else {
                int amount;
                class_2338 pos = entity.method_24515();
                if (result != null && result.method_17783() != class_239.class_240.field_1333) {
                    pos = result.method_17777();
                }
                if ((amount = (int)class_2338.method_20437((class_2338)pos.method_10069(-range, 0, -range), (class_2338)pos.method_10069(range, 0, range)).filter(p -> this.sickleUse(player.method_14220(), p.method_10062(), stack, entity)).count()) > 0) {
                    Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                        LevelCalc.useRP((class_1657)player, data, range * 10, true, 0.0f, true, EnumSkills.FARMING);
                        LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 3.5f);
                        LevelCalc.levelSkill(player, data, EnumSkills.WIND, 2.5f);
                    });
                }
            }
        }
        super.method_7840(stack, level, entity, timeLeft);
    }

    public class_1814 method_7862(class_1799 stack) {
        return this.tier == EnumToolTier.PLATINUM ? class_1814.field_8904 : class_1814.field_8906;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    private class_1269 useOnBlock(class_1838 ctx) {
        class_1937 class_19372 = ctx.method_8045();
        if (!(class_19372 instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_1799 stack = ctx.method_8041();
        if (this.sickleUse(serverLevel, ctx.method_8037(), stack, (class_1309)ctx.method_8036())) {
            this.onBlockBreak((class_3222)ctx.method_8036());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean sickleUse(class_3218 level, class_2338 pos, class_1799 stack, class_1309 entity) {
        class_1657 player;
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_7343(pos.method_10093(class_2350.field_11036), class_2350.field_11036, stack)) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        if (state.method_26164(RunecraftoryTags.SICKLE_DESTROYABLE)) {
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                if (serverPlayer.field_13974.method_14266(pos)) {
                    level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                    serverPlayer.field_13987.method_14364((class_2596)new class_2626(pos, level.method_8320(pos)));
                    return true;
                }
            } else {
                return level.method_30093(pos, true, (class_1297)entity, 3);
            }
        }
        return false;
    }
}

