/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1831;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class ItemToolWateringCan
extends class_1831
implements IItemUsable {
    private final EnumToolTier tier;

    public ItemToolWateringCan(EnumToolTier tier, class_1792.class_1793 props) {
        super(ItemTiers.TIER, props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(class_3222 player) {
        Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
            LevelCalc.useRP((class_1657)player, data, 2.0f, true, 0.0f, true, EnumSkills.FARMING, EnumSkills.WATER);
            LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 4.0f);
            LevelCalc.levelSkill(player, data, EnumSkills.WATER, 1.0f);
        });
    }

    public int maxWater() {
        return switch (this.tier) {
            case EnumToolTier.IRON -> GeneralConfig.ironWateringCanWater;
            case EnumToolTier.SILVER -> GeneralConfig.silverWateringCanWater;
            case EnumToolTier.GOLD -> GeneralConfig.goldWateringCanWater;
            case EnumToolTier.PLATINUM -> GeneralConfig.platinumWateringCanWater;
            default -> GeneralConfig.scrapWateringCanWater;
        };
    }

    public int getWater(class_1799 stack) {
        return stack.method_7948().method_10550("Water");
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseDuration) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int duration = stack.method_7935() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.field_13987.method_14364((class_2596)new class_2767(class_3417.field_14776, player.method_5634(), player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f));
            }
        }
    }

    public class_1269 method_7884(class_1838 ctx) {
        if (this.tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx);
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_3965 ray = ItemToolWateringCan.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
        class_1799 itemstack = player.method_5998(hand);
        class_2680 state = world.method_8320(ray.method_17777());
        if (state.method_26227().method_15772() == class_3612.field_15910) {
            itemstack.method_7948().method_10569("Water", this.maxWater());
            world.method_8652(ray.method_17777(), state.method_26227().method_15759(), 3);
            player.method_5783(class_3417.field_15126, 1.0f, 1.0f);
            return class_1271.method_22427((Object)itemstack);
        }
        if (this.tier.getTierLevel() != 0) {
            player.method_6019(hand);
            return class_1271.method_22428((Object)itemstack);
        }
        return class_1271.method_22430((Object)itemstack);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return (int)((float)this.getWater(stack) / (float)this.maxWater() * 13.0f);
    }

    public int method_31571(class_1799 stack) {
        float f = Math.max(0.0f, (float)this.getWater(stack) / (float)this.maxWater());
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 entity, int timeLeft) {
        if (this.tier.getTierLevel() != 0 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int useTime = (stack.method_7935() - timeLeft - 1) / ItemUtils.getChargeTime(entity, this.tier);
            int range = Math.min(useTime, this.tier.getTierLevel());
            class_3965 result = ItemToolWateringCan.method_7872((class_1937)world, (class_1657)((class_1657)entity), (class_3959.class_242)class_3959.class_242.field_1348);
            if (range == 0) {
                if (result != null) {
                    this.useOnBlock(new class_1838((class_1657)entity, entity.method_6058(), result));
                }
            } else {
                int amount;
                class_2338 pos = entity.method_24515().method_10074();
                if (result != null && result.method_17783() != class_239.class_240.field_1333) {
                    pos = result.method_17777();
                }
                if ((amount = (int)class_2338.method_20437((class_2338)pos.method_10069(-range, -1, -range), (class_2338)pos.method_10069(range, 0, range)).filter(p -> this.moisten((class_3218)world, p.method_10062(), stack, entity)).count()) > 0) {
                    Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                        LevelCalc.useRP((class_1657)player, data, 0.0f, true, (float)range * 17.5f, true, EnumSkills.FARMING);
                        LevelCalc.levelSkill(player, data, EnumSkills.FARMING, range * 10);
                        LevelCalc.levelSkill(player, data, EnumSkills.WATER, range * 3);
                    });
                }
            }
        }
        super.method_7840(stack, world, entity, timeLeft);
    }

    public class_1814 method_7862(class_1799 stack) {
        return this.tier == EnumToolTier.PLATINUM ? class_1814.field_8904 : class_1814.field_8906;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    private class_1269 useOnBlock(class_1838 ctx) {
        if (ctx.method_8045().field_9236) {
            return class_1269.field_5811;
        }
        class_1799 stack = ctx.method_8041();
        class_1657 player = ctx.method_8036();
        class_2338 pos = ctx.method_8037();
        if (this.moisten((class_3218)ctx.method_8045(), pos, stack, (class_1309)player) || this.moisten((class_3218)ctx.method_8045(), pos.method_10074(), stack, (class_1309)player)) {
            this.onBlockBreak((class_3222)ctx.method_8036());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean moisten(class_3218 world, class_2338 pos, class_1799 stack, class_1309 entity) {
        if (entity instanceof class_1657 && !((class_1657)entity).method_7343(pos.method_10093(class_2350.field_11036), class_2350.field_11036, stack)) {
            return false;
        }
        boolean creative = !(entity instanceof class_1657) || ((class_1657)entity).method_7337();
        class_2680 state = world.method_8320(pos);
        int water = this.getWater(stack);
        if ((creative || water > 0) && state.method_26164(RunecraftoryTags.FARMLAND) && (Integer)state.method_11654((class_2769)class_2344.field_11009) != 7) {
            FarmlandHandler.waterLand(world, pos, state);
            if (!creative) {
                stack.method_7969().method_10569("Water", water - 1);
            }
            return true;
        }
        return false;
    }
}

