/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.items.BigWeapon;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5575;

public class ItemAxeBase
extends class_1743
implements IItemUsable,
IAOEWeapon,
BigWeapon {
    private static final class_243[] PARTICLE_DIRECTION = ItemAxeBase.generateParticleDir(2);

    public ItemAxeBase(class_1792.class_1793 props) {
        super(ItemTiers.TIER, 0.0f, 0.0f, props);
    }

    public boolean resetAttackStrength(class_1309 entity, class_1799 stack) {
        return false;
    }

    public boolean swingWeapon(class_1309 entity, class_1799 stack) {
        return false;
    }

    public boolean onServerSwing(class_1309 entity, class_1799 stack) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE.get())), stack));
            return false;
        }
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.HAXE;
    }

    @Override
    public void onBlockBreak(class_3222 player) {
        Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.LOGGING, 1.0f));
    }

    public float getRange(class_1309 entity, class_1799 stack) {
        return (float)entity.method_26825((class_1320)ModAttributes.ATTACK_RANGE.get());
    }

    public float getWidth(class_1309 entity, class_1799 stack) {
        return (float)entity.method_26825((class_1320)ModAttributes.ATTACK_WIDTH.get());
    }

    public boolean doSweepingAttack() {
        return false;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseDuration) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int duration = stack.method_7935() - remainingUseDuration;
            if (duration == ItemUtils.getChargeTime(entity)) {
                player.field_13987.method_14364((class_2596)new class_2767(class_3417.field_14776, player.method_5634(), player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f));
            }
        }
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        return !player.method_7337();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (hand == class_1268.field_5810) {
            return class_1271.method_22430((Object)itemstack);
        }
        boolean canCharge = Platform.INSTANCE.getPlayerData(player).map(data -> (data.getSkillLevel(EnumSkills.HAMMERAXE).getLevel() >= 5 || player.method_7337()) && data.getWeaponHandler().canExecuteAction((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE_USE.get())))).orElse(false);
        if (canCharge) {
            player.method_6019(hand);
            return class_1271.method_22428((Object)itemstack);
        }
        return class_1271.method_22430((Object)itemstack);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 entity, int timeLeft) {
        if (!world.field_9236 && stack.method_7935() - timeLeft - 1 >= ItemUtils.getChargeTime(entity)) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE_USE.get())), stack));
                return;
            }
            if (ItemAxeBase.performRightClickAction(stack, entity, this.getRange(entity, stack), 0.7f)) {
                entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14840, entity.method_5634(), 1.0f, 1.0f);
            }
        }
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public static void delayedRightClickAction(class_1309 entity, class_1799 stack) {
        double reach = CombatUtils.getRange(entity, 0.0);
        S2CScreenShake.sendAround((class_1297)entity, 16.0, 4, 3.0f);
        if (ItemAxeBase.performRightClickAction(stack, entity, reach, 0.7f) && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.HAMMERAXE, 5.0f));
        }
    }

    public static boolean performRightClickAction(class_1799 stack, class_1309 entity, double range, float knockback) {
        Collection<class_1309> list = ItemAxeBase.getEntitiesIn(entity, range, null);
        entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14803, entity.method_5634(), 1.0f, 0.4f);
        class_243 pos = entity.method_19538().method_1031(0.0, -1.0, 0.0);
        class_2338.class_2339 mut = new class_2338.class_2339();
        for (class_243 dir : PARTICLE_DIRECTION) {
            class_243 scaled = dir.method_1021(0.5);
            mut.method_10103(class_3532.method_15357((double)(pos.method_10216() + dir.method_10216())), class_3532.method_15357((double)pos.method_10214()), class_3532.method_15357((double)(pos.method_10215() + dir.method_10215())));
            class_2680 class_26802 = entity.field_6002.method_8320((class_2338)mut);
            if (class_26802.method_26217() == class_2464.field_11455) continue;
            ((class_3218)entity.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, class_26802), entity.method_23317() + dir.method_10216(), entity.method_23318() + 0.1, entity.method_23321() + dir.method_10215(), 0, (double)((float)scaled.method_10216()), 1.5, (double)((float)scaled.method_10215()), 1.0);
        }
        if (!list.isEmpty()) {
            Supplier<CustomDamage.Builder> base = () -> new CustomDamage.Builder((class_1297)entity).element(ItemNBT.getElement(stack)).knock(CustomDamage.KnockBackType.UP).knockAmount(knockback).hurtResistant(5);
            boolean success = false;
            double damagePhys = CombatUtils.getAttributeValue((class_1297)entity, class_5134.field_23721) * 1.1;
            for (class_1297 class_12972 : list) {
                if (!CombatUtils.damageWithFaintAndCrit((class_1297)entity, class_12972, base.get(), damagePhys, stack)) continue;
                success = true;
            }
            return success;
        }
        return false;
    }

    public static Collection<class_1309> getEntitiesIn(class_1309 entity, double reach, Predicate<class_1309> pred) {
        double incHalf = Math.asin(0.5 / reach) * 57.2957763671875;
        float minYRot = 0.0f;
        float maxYRot = 360.0f;
        class_238 aabb = new class_238(-0.5, -0.15, 0.0, 0.5, 1.15, reach);
        int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
        float inc = (maxYRot - minYRot) / (float)rotationSteps;
        HashSet<class_1309> entities = new HashSet<class_1309>();
        Predicate<class_1309> predicate = e -> entity.method_5854() != e && (pred == null || pred.test((class_1309)e));
        for (int steps = 0; steps <= rotationSteps; ++steps) {
            float yRot = minYRot + inc * (float)steps;
            OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, 0.0f, entity.method_19538());
            entities.addAll(RayTraceUtils.getEntitiesIn((class_1309)entity, (OrientedBoundingBox)obb, (boolean)true, (class_5575)class_5575.method_31795(class_1309.class), predicate));
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)entity);
        }
        return entities;
    }

    private static class_243[] generateParticleDir(int range) {
        class_243[] arr = new class_243[(2 * range + 1) * (2 * range + 1) - 1];
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (x == 0 && z == 0) continue;
                arr[i] = new class_243((double)x, 0.0, (double)z).method_1029().method_1021(1.2);
                ++i;
            }
        }
        return arr;
    }
}

