/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.items.BigWeapon;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5134;

public class ItemLongSwordBase
extends class_1829
implements IItemUsable,
IAOEWeapon,
BigWeapon {
    public ItemLongSwordBase(class_1792.class_1793 props) {
        super(ItemTiers.TIER, 0, 0.0f, props);
    }

    public boolean resetAttackStrength(class_1309 entity, class_1799 stack) {
        return false;
    }

    public boolean swingWeapon(class_1309 entity, class_1799 stack) {
        return false;
    }

    public boolean onServerSwing(class_1309 entity, class_1799 stack) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.LONG_SWORD.get())), stack));
            return false;
        }
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.LONGSWORD;
    }

    @Override
    public void onBlockBreak(class_3222 player) {
    }

    public float getRange(class_1309 entity, class_1799 stack) {
        return (float)entity.method_26825((class_1320)ModAttributes.ATTACK_RANGE.get());
    }

    public float getWidth(class_1309 entity, class_1799 stack) {
        return (float)entity.method_26825((class_1320)ModAttributes.ATTACK_WIDTH.get());
    }

    public boolean doSweepingAttack() {
        return false;
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseDuration) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int duration = stack.method_7935() - remainingUseDuration;
            if (duration == ItemUtils.getChargeTime(entity)) {
                player.field_13987.method_14364((class_2596)new class_2767(class_3417.field_14776, player.method_5634(), player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f));
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (hand == class_1268.field_5810) {
            return class_1271.method_22430((Object)itemstack);
        }
        boolean canCharge = Platform.INSTANCE.getPlayerData(player).map(data -> (data.getSkillLevel(EnumSkills.LONGSWORD).getLevel() >= 5 || player.method_7337()) && data.getWeaponHandler().canExecuteAction((AttackAction)((Object)((Object)ModAttackActions.LONGSWORD_USE.get())))).orElse(false);
        if (canCharge) {
            player.method_6019(hand);
            return class_1271.method_22428((Object)itemstack);
        }
        return class_1271.method_22430((Object)itemstack);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 entity, int timeLeft) {
        if (!world.field_9236 && stack.method_7935() - timeLeft - 1 >= ItemUtils.getChargeTime(entity)) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.LONGSWORD_USE.get())), stack));
                return;
            }
            if (ItemLongSwordBase.performRightClickAction(stack, entity, 0.0)) {
                entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14706, entity.method_5634(), 1.0f, 1.0f);
            }
        }
    }

    public static void delayedRightClickAction(class_1309 entity, class_1799 stack) {
        class_3222 player;
        entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14706, entity.method_5634(), 1.0f, 1.0f);
        if (entity instanceof class_3222) {
            player = (class_3222)entity;
            player.method_7263();
        }
        if (ItemLongSwordBase.performRightClickAction(stack, entity, 0.0) && entity instanceof class_3222) {
            player = (class_3222)entity;
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.LONGSWORD, 7.0f));
        }
    }

    public static boolean performRightClickAction(class_1799 stack, class_1309 entity, double range) {
        Collection<class_1309> list = CombatUtils.EntityAttack.circleTargets(entity.method_36454() - 60.0f, entity.method_36454() + 60.0f, (float)range).apply(entity, null);
        if (!list.isEmpty()) {
            Supplier<CustomDamage.Builder> base = () -> new CustomDamage.Builder((class_1297)entity).element(ItemNBT.getElement(stack)).knock(CustomDamage.KnockBackType.UP).knockAmount(1.0f).hurtResistant(10);
            boolean success = false;
            double damagePhys = CombatUtils.getAttributeValue((class_1297)entity, class_5134.field_23721) * 1.2;
            for (class_1309 e : list) {
                if (!CombatUtils.damageWithFaintAndCrit((class_1297)entity, (class_1297)e, base.get(), damagePhys, stack)) continue;
                success = true;
            }
            return success;
        }
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return ImmutableMultimap.of();
    }
}

