/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.StaffData;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.ExtendedItem;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IExtendedWeapon;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class ItemStaffBase
extends class_1792
implements IItemUsable,
ExtendedItem,
IExtendedWeapon {
    public final EnumElement startElement;
    public final int amount;

    public ItemStaffBase(EnumElement startElement, int amount, class_1792.class_1793 props) {
        super(props);
        this.startElement = startElement;
        this.amount = Math.max(1, amount);
    }

    public int getChargeTime(class_1799 stack) {
        return Platform.INSTANCE.getStaffData(stack).map(StaffData::getChargeTime).orElse((int)((class_1320)ModAttributes.CHARGE_TIME.get()).method_6169());
    }

    public int getStaffChargeTime(class_1309 entity, class_1799 stack) {
        int time = this.getChargeTime(stack);
        if (ArmorEffect.hasArmorEffect(entity, (ArmorEffect)((Object)ModArmorEffects.MAGIC_RING.get()))) {
            time = (int)((double)time * 0.75);
        }
        return time;
    }

    public int chargeAmount(class_1799 stack) {
        return Platform.INSTANCE.getStaffData(stack).map(cap -> cap.getTier3Spell(stack) != null && ItemNBT.itemLevel(stack) >= 3 ? 3 : (cap.getTier2Spell(stack) != null ? 2 : (cap.getTier1Spell(stack) != null ? 1 : 0))).orElse(0);
    }

    public boolean resetAttackStrength(class_1309 entity, class_1799 stack) {
        return false;
    }

    public boolean swingWeapon(class_1309 entity, class_1799 stack) {
        return false;
    }

    public boolean onServerSwing(class_1309 entity, class_1799 stack) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.STAFF.get())), stack));
            return false;
        }
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.STAFF;
    }

    @Override
    public void onBlockBreak(class_3222 player) {
    }

    public float getRange(class_1309 entity, class_1799 stack) {
        return (float)entity.method_26825((class_1320)ModAttributes.ATTACK_RANGE.get());
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
        if (livingEntity instanceof class_3222) {
            class_3222 player = (class_3222)livingEntity;
            int duration = stack.method_7935() - remainingUseDuration;
            if (duration > 0 && duration / this.getStaffChargeTime(livingEntity, stack) <= this.chargeAmount(stack) && duration % this.getStaffChargeTime(livingEntity, stack) == 0) {
                player.field_13987.method_14364((class_2596)new class_2767(class_3417.field_14776, player.method_5634(), player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f));
            }
        }
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        return !player.method_7337();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (hand == class_1268.field_5810) {
            return class_1271.method_22431((Object)stack);
        }
        if (this.chargeAmount(stack) > 0) {
            if (!world.field_9236) {
                if (this.getStaffChargeTime((class_1309)player, stack) <= 0) {
                    int level = Math.min(3, this.chargeAmount(stack));
                    Spell spell = this.getSpell(stack, level);
                    if (spell != null && player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        Platform.INSTANCE.getPlayerData((class_1657)serverPlayer).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.STAFF_USE.get())), stack, spell));
                    }
                } else {
                    player.method_6019(hand);
                }
            }
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 entity, int timeLeft) {
        int tier;
        int level;
        Spell spell;
        if (!world.field_9236 && (spell = this.getSpell(stack, level = Math.min(tier = (this.method_7881(stack) - timeLeft - 1) / this.getStaffChargeTime(entity, stack), this.chargeAmount(stack)))) != null) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.STAFF_USE.get())), stack, spell));
                return;
            }
            spell.use((class_3218)world, entity, stack);
        }
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public Spell getSpell(class_1799 stack, int level) {
        StaffData cap = Platform.INSTANCE.getStaffData(stack).orElseThrow(() -> new NullPointerException("Error getting capability for staff item"));
        return switch (level) {
            case 3 -> cap.getTier3Spell(stack);
            case 2 -> cap.getTier2Spell(stack);
            case 1 -> cap.getTier1Spell(stack);
            default -> null;
        };
    }

    @Override
    public boolean onEntitySwing(class_1799 stack, class_1309 entity) {
        return false;
    }
}

