/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;

public class ItemLevelLootFunction
extends class_120 {
    private final List<WeightedLevel> levels;

    private ItemLevelLootFunction(class_5341[] conditions, List<WeightedLevel> levels) {
        super(conditions);
        this.levels = levels;
    }

    public static class_120.class_121<Builder> getDef() {
        return new Builder().add(1, 30, 0).add(2, 28, 1).add(3, 26, 2).add(4, 20, 3).add(5, 17, 4).add(6, 15, 5).add(7, 11, 6).add(8, 7, 7).add(9, 4, 8).add(10, 2, 9);
    }

    public static int totalWeight(List<WeightedLevel> list, float modifier) {
        return list.stream().mapToInt(w -> w.getWeight(modifier)).sum();
    }

    public static int getRandomItem(List<WeightedLevel> list, Random rand, float modifier) {
        int total = ItemLevelLootFunction.totalWeight(list, modifier);
        if (total <= 0) {
            throw new IllegalArgumentException();
        }
        int randWeight = rand.nextInt(total);
        for (WeightedLevel w : list) {
            if ((randWeight -= w.getWeight(modifier)) >= 0) continue;
            return w.level;
        }
        return 1;
    }

    public static JsonArray serialize(List<WeightedLevel> list) {
        list.sort(Comparator.comparingInt(w -> w.level));
        JsonArray arr = new JsonArray();
        list.forEach(w -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("weight", (Number)w.weight);
            obj.addProperty("luck_bonus", (Number)w.bonus);
            obj.addProperty("level", (Number)w.level);
            arr.add((JsonElement)obj);
        });
        return arr;
    }

    public static List<WeightedLevel> deserialize(JsonElement element) {
        ArrayList<WeightedLevel> list = new ArrayList<WeightedLevel>();
        if (!element.isJsonArray()) {
            throw new JsonParseException("Expected a json array for " + String.valueOf(element));
        }
        element.getAsJsonArray().forEach(el -> {
            if (!el.isJsonObject()) {
                throw new JsonParseException("Expected a json object for " + String.valueOf(el));
            }
            JsonObject obj = (JsonObject)el;
            list.add(new WeightedLevel(class_3518.method_15282((JsonObject)obj, (String)"weight", (int)1), class_3518.method_15282((JsonObject)obj, (String)"luck_bonus", (int)0), class_3518.method_15282((JsonObject)obj, (String)"level", (int)1)));
        });
        return list;
    }

    public class_5339 method_29321() {
        return (class_5339)ModLootRegistries.ITEM_LEVEL.get();
    }

    protected class_1799 method_522(class_1799 stack, class_47 ctx) {
        int level = 0;
        if (ctx.method_300(LootCtxParameters.ITEM_LEVEL_CONTEXT)) {
            level = (Integer)ctx.method_35508(LootCtxParameters.ITEM_LEVEL_CONTEXT);
        } else if (ctx.method_300(class_181.field_1224) && ctx.method_300(class_181.field_24424)) {
            class_2338 blockPos = new class_2338((class_243)ctx.method_35508(class_181.field_24424));
            level = FarmlandHandler.get(ctx.method_299().method_8503()).getData(ctx.method_299(), blockPos).map(FarmlandData::getCropLevel).orElse(0);
        }
        if (level == 0) {
            level = this.getLevel(ctx);
        }
        return ItemNBT.getLeveledItem(stack, Math.abs(level));
    }

    public int getLevel(class_47 ctx) {
        return ItemLevelLootFunction.getRandomItem(this.levels, ctx.method_294(), ctx.method_302());
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final List<WeightedLevel> levels = new ArrayList<WeightedLevel>();

        protected Builder getThis() {
            return this;
        }

        public Builder add(int level, int weight, int bonus) {
            this.levels.add(new WeightedLevel(weight, bonus, level));
            return this;
        }

        public class_117 method_515() {
            return new ItemLevelLootFunction(this.method_526(), this.levels);
        }
    }

    public record WeightedLevel(int weight, int bonus, int level) {
        public int getWeight(float modifier) {
            return this.weight + (int)((float)this.bonus * modifier);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeightedLevel) {
                return ((WeightedLevel)obj).weight == this.weight;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.weight;
        }

        @Override
        public String toString() {
            return String.format("Level: %d; Weight: %d; Bonus: %d", this.level, this.weight, this.bonus);
        }
    }

    public static class Serializer
    extends class_120.class_123<ItemLevelLootFunction> {
        public void serialize(JsonObject obj, ItemLevelLootFunction func, JsonSerializationContext context) {
            super.method_529(obj, (class_120)func, context);
            obj.add("level_weight", (JsonElement)ItemLevelLootFunction.serialize(func.levels));
        }

        public ItemLevelLootFunction deserialize(JsonObject obj, JsonDeserializationContext ctx, class_5341[] conditions) {
            return new ItemLevelLootFunction(conditions, ItemLevelLootFunction.deserialize(obj.get("level_weight")));
        }
    }
}

