/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_3518;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5575;
import net.minecraft.class_5658;

public class LootingAndLuckLootFunction
extends class_120 {
    private final class_5658 baseChance;
    private final class_5658 lootingBonus;
    private final class_5658 luckBonus;
    private final int limit;

    private LootingAndLuckLootFunction(class_5341[] conditions, class_5658 baseChance, class_5658 luckBonus, class_5658 lootingBonus, int limit) {
        super(conditions);
        this.baseChance = baseChance;
        this.luckBonus = luckBonus;
        this.lootingBonus = lootingBonus;
        this.limit = limit;
    }

    public class_5339 method_29321() {
        return (class_5339)ModLootRegistries.LUCK_AND_LOOTING.get();
    }

    protected class_1799 method_522(class_1799 stack, class_47 ctx) {
        class_1297 entity = (class_1297)ctx.method_296(class_181.field_1230);
        float luck = ctx.method_302();
        int looting = 0;
        List<class_1309> contributing = LootingAndLuckLootFunction.getContributingEntities(ctx);
        if (entity instanceof class_1309) {
            looting = Platform.INSTANCE.getLootingFromCtx(ctx);
        }
        for (class_1309 other : contributing) {
            looting += Platform.INSTANCE.getLootingFromEntity((class_1297)ctx.method_296(class_181.field_1226), (class_1297)other, (class_1282)ctx.method_296(class_181.field_1231));
            if (!other.method_6127().method_27306(class_5134.field_23726)) continue;
            luck += (float)other.method_26825(class_5134.field_23726);
        }
        float chance = (this.baseChance.method_32454(ctx) + this.luckBonus.method_32454(ctx) * luck) * (1.0f + this.lootingBonus.method_32454(ctx) * (float)looting);
        if (chance >= 1.0f) {
            int uniform = (int)chance * 2;
            float left = chance - (float)uniform;
            int amount = ctx.method_294().nextInt(uniform + 1);
            if (ctx.method_294().nextFloat() < left) {
                ++amount;
            }
            if (this.limit > 0) {
                amount = Math.min(this.limit, amount);
            }
            stack.method_7939(amount);
            return stack;
        }
        if (ctx.method_294().nextFloat() < chance) {
            return stack;
        }
        return class_1799.field_8037;
    }

    public static List<class_1309> getContributingEntities(class_47 ctx) {
        EntityNPCBase npc;
        class_1297 entity = (class_1297)ctx.method_296(class_181.field_1230);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return Platform.INSTANCE.getPlayerData(player).map(d -> entity.field_6002.method_18023(class_5575.method_31795(class_1309.class), entity.method_5829().method_1014(64.0), d.party::isPartyMember)).orElse(List.of());
        }
        if (entity instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (monster.getOwner() != null && Platform.INSTANCE.getPlayerData(monster.getOwner()).map(d -> d.party.isPartyMember((class_1297)monster)).orElse(false).booleanValue()) {
                return List.of(monster);
            }
        } else if (entity instanceof EntityNPCBase && (npc = (EntityNPCBase)entity).followEntity() != null && Platform.INSTANCE.getPlayerData(npc.followEntity()).map(d -> d.party.isPartyMember((class_1297)npc)).orElse(false).booleanValue()) {
            return List.of(npc);
        }
        return List.of();
    }

    public static class Serializer
    extends class_120.class_123<LootingAndLuckLootFunction> {
        public void serialize(JsonObject obj, LootingAndLuckLootFunction func, JsonSerializationContext context) {
            super.method_529(obj, (class_120)func, context);
            obj.add("baseChance", context.serialize((Object)func.baseChance));
            obj.add("luckBonus", context.serialize((Object)func.luckBonus));
            obj.add("lootingBonus", context.serialize((Object)func.lootingBonus));
            obj.addProperty("limit", (Number)func.limit);
        }

        public LootingAndLuckLootFunction deserialize(JsonObject obj, JsonDeserializationContext ctx, class_5341[] conditions) {
            return new LootingAndLuckLootFunction(conditions, (class_5658)class_3518.method_15272((JsonObject)obj, (String)"baseChance", (JsonDeserializationContext)ctx, class_5658.class), (class_5658)class_3518.method_15272((JsonObject)obj, (String)"luckBonus", (JsonDeserializationContext)ctx, class_5658.class), (class_5658)class_3518.method_15272((JsonObject)obj, (String)"lootingBonus", (JsonDeserializationContext)ctx, class_5658.class), class_3518.method_15282((JsonObject)obj, (String)"limit", (int)0));
        }
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final class_5658 baseChance;
        private class_5658 lootingBonus = class_44.method_32448((float)0.0f);
        private class_5658 luckBonus = class_44.method_32448((float)0.0f);
        private int limit = 0;

        public Builder(class_5658 baseChance) {
            this.baseChance = baseChance;
        }

        protected Builder getThis() {
            return this;
        }

        public Builder withLuckBonus(class_5658 luckBonus) {
            this.luckBonus = luckBonus;
            return this;
        }

        public Builder withLootingBonus(class_5658 lootingBonus) {
            this.lootingBonus = lootingBonus;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public class_117 method_515() {
            return new LootingAndLuckLootFunction(this.method_526(), this.baseChance, this.luckBonus, this.lootingBonus, this.limit);
        }
    }
}

