/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class C2SNPCInteraction
implements Packet {
    public static final class_2960 ID = new class_2960("runecraftory", "c2s_npc_interaction");
    private final int id;
    private final Type type;
    private final String action;

    public C2SNPCInteraction(int entityID, Type type) {
        this(entityID, type, "");
    }

    public C2SNPCInteraction(int entityID, String action) {
        this(entityID, Type.ACTION, action);
    }

    public C2SNPCInteraction(int entityID, Type type, String action) {
        this.id = entityID;
        this.type = type;
        this.action = action == null ? "" : action;
    }

    public static C2SNPCInteraction read(class_2540 buf) {
        return new C2SNPCInteraction(buf.readInt(), (Type)buf.method_10818(Type.class), buf.method_19772());
    }

    public static void handle(C2SNPCInteraction pkt, class_3222 sender) {
        class_1297 entity;
        if (sender != null && (entity = sender.field_6002.method_8469(pkt.id)) instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)entity;
            switch (pkt.type) {
                case TALK: {
                    npc.talkTo(sender);
                    break;
                }
                case FOLLOW: {
                    if (Platform.INSTANCE.getPlayerData((class_1657)sender).map(d -> !d.party.isPartyMember(entity) && d.party.isPartyFull()).orElse(true).booleanValue()) {
                        sender.method_9203((class_2561)new class_2588("runecraftory.monster.interact.party.full"), class_156.field_25140);
                        return;
                    }
                    if (npc.getEntityToFollowUUID() != null) break;
                    npc.followEntity(sender);
                    break;
                }
                case FOLLOWDISTANCE: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.method_5667())) break;
                    npc.setBehaviour(EntityNPCBase.Behaviour.FOLLOW_DISTANCE);
                    break;
                }
                case STAY: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.method_5667())) break;
                    npc.setBehaviour(EntityNPCBase.Behaviour.STAY);
                    break;
                }
                case STOPFOLLOW: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.method_5667())) break;
                    npc.followEntity(null);
                    break;
                }
                case SHOP: {
                    npc.openShopForPlayer(sender);
                    break;
                }
                case QUEST: {
                    npc.respondToQuest(sender, new class_2960(pkt.action));
                    break;
                }
                case CLOSE: {
                    npc.closedDialogue(sender);
                    break;
                }
                case CLOSE_QUEST: {
                    npc.closedQuestDialogue(sender);
                    break;
                }
                case ACTION: {
                    if (npc.method_6109()) break;
                    npc.getShop().handleAction(npc, (class_1657)sender, pkt.action);
                }
            }
        }
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(this.id);
        buf.method_10817((Enum)this.type);
        buf.method_10814(this.action);
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    public static enum Type {
        TALK("runecraftory.gui.npc.talk", null),
        FOLLOW("runecraftory.gui.npc.follow", EntityNPCBase.Behaviour.FOLLOW),
        FOLLOWDISTANCE("runecraftory.gui.npc.distance", EntityNPCBase.Behaviour.FOLLOW_DISTANCE),
        STAY("runecraftory.gui.npc.stay", EntityNPCBase.Behaviour.STAY),
        STOPFOLLOW("runecraftory.gui.npc.stopFollow", EntityNPCBase.Behaviour.WANDER),
        SHOP("runecraftory.gui.npc.shop", null),
        CLOSE("runecraftory.gui.npc.close", null),
        CLOSE_QUEST("runecraftory.gui.npc.close.quest", null),
        QUEST("runecraftory.gui.quest.button", null),
        ACTION("", null);

        public final String translation;
        @Nullable
        public final EntityNPCBase.Behaviour behaviour;

        private Type(String translation, EntityNPCBase.Behaviour behaviour) {
            this.translation = translation;
            this.behaviour = behaviour;
        }
    }
}

