/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class C2SSetMonsterBehaviour
implements Packet {
    public static final class_2960 ID = new class_2960("runecraftory", "c2s_monster_behaviour");
    private final int id;
    private final Type type;

    public C2SSetMonsterBehaviour(int entityID, Type type) {
        this.id = entityID;
        this.type = type;
    }

    public static C2SSetMonsterBehaviour read(class_2540 buf) {
        return new C2SSetMonsterBehaviour(buf.readInt(), (Type)buf.method_10818(Type.class));
    }

    public static void handle(C2SSetMonsterBehaviour pkt, class_3222 sender) {
        class_1297 entity;
        if (sender != null && (entity = sender.field_6002.method_8469(pkt.id)) instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (sender.method_5667().equals(monster.method_6139())) {
                switch (pkt.type) {
                    case HOME: 
                    case FOLLOW: 
                    case FOLLOW_DISTANCE: 
                    case STAY: 
                    case WANDER: {
                        if (pkt.type == Type.FOLLOW && Platform.INSTANCE.getPlayerData((class_1657)sender).map(d -> !d.party.isPartyMember(entity) && d.party.isPartyFull()).orElse(true).booleanValue()) {
                            sender.method_9203((class_2561)new class_2588("runecraftory.monster.interact.party.full"), class_156.field_25140);
                            return;
                        }
                        monster.setBehaviour(pkt.type.behaviour);
                        sender.method_9203((class_2561)new class_2588(monster.behaviourState().interactKey, new Object[]{monster.method_5476()}), class_156.field_25140);
                        break;
                    }
                    case FARM: {
                        monster.setBehaviour(BaseMonster.Behaviour.FARM);
                        sender.method_9203((class_2561)new class_2588(monster.behaviourState().interactKey, new Object[]{monster.method_5476()}), class_156.field_25140);
                        ModCriteria.COMMAND_FARMING.trigger(sender);
                        break;
                    }
                    case CENTER: 
                    case CENTER_FARM: {
                        Platform.INSTANCE.getPlayerData((class_1657)sender).ifPresent(data -> {
                            data.entitySelector.selectedEntity = monster;
                            data.entitySelector.poi = monster.method_18412();
                            data.entitySelector.apply = (player, pos) -> {
                                monster.restrictToBasedOnBehaviour((class_2338)pos, false);
                                data.entitySelector.poi = monster.method_18412();
                            };
                        });
                        break;
                    }
                    case HARVESTINV: {
                        Platform.INSTANCE.getPlayerData((class_1657)sender).ifPresent(data -> {
                            data.entitySelector.selectedEntity = monster;
                            data.entitySelector.poi = monster.getCropInventory();
                            data.entitySelector.apply = (player, pos) -> {
                                if (monster.method_18407((class_2338)pos)) {
                                    monster.setCropInventory((class_2338)pos);
                                    data.entitySelector.poi = monster.getCropInventory();
                                    player.method_9203((class_2561)new class_2588("runecraftory.behaviour.inventory.harvest"), class_156.field_25140);
                                } else {
                                    player.method_9203((class_2561)new class_2588("runecraftory.behaviour.inventory.harvest.invalid"), class_156.field_25140);
                                }
                            };
                        });
                        break;
                    }
                    case SEEDINV: {
                        Platform.INSTANCE.getPlayerData((class_1657)sender).ifPresent(data -> {
                            data.entitySelector.selectedEntity = monster;
                            data.entitySelector.poi = monster.getSeedInventory();
                            data.entitySelector.apply = (player, pos) -> {
                                if (monster.method_18407((class_2338)pos)) {
                                    monster.setSeedInventory((class_2338)pos);
                                    data.entitySelector.poi = monster.getSeedInventory();
                                    player.method_9203((class_2561)new class_2588("runecraftory.behaviour.inventory.seed"), class_156.field_25140);
                                } else {
                                    player.method_9203((class_2561)new class_2588("runecraftory.behaviour.inventory.seed.invalid"), class_156.field_25140);
                                }
                            };
                        });
                        break;
                    }
                    case RIDE: {
                        if (monster.behaviourState() != BaseMonster.Behaviour.FOLLOW && monster.behaviourState() != BaseMonster.Behaviour.FOLLOW_DISTANCE && monster.behaviourState() != BaseMonster.Behaviour.STAY) break;
                        monster.doStartRide(sender);
                    }
                }
            }
        }
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(this.id);
        buf.method_10817((Enum)this.type);
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    public static enum Type {
        HOME("runecraftory.gui.companion.behaviour.home", BaseMonster.Behaviour.WANDER_HOME),
        FOLLOW("runecraftory.gui.companion.behaviour.follow", BaseMonster.Behaviour.FOLLOW),
        FOLLOW_DISTANCE("runecraftory.gui.companion.behaviour.follow_distance", BaseMonster.Behaviour.FOLLOW_DISTANCE),
        STAY("runecraftory.gui.companion.behaviour.stay", BaseMonster.Behaviour.STAY),
        WANDER("runecraftory.gui.companion.behaviour.wander", BaseMonster.Behaviour.WANDER),
        FARM("runecraftory.gui.companion.behaviour.farm", BaseMonster.Behaviour.FARM),
        HARVESTINV("runecraftory.gui.companion.behaviour.harvest", BaseMonster.Behaviour.FARM),
        SEEDINV("runecraftory.gui.companion.behaviour.seed", BaseMonster.Behaviour.FARM),
        RIDE("runecraftory.gui.companion.behaviour.ride", BaseMonster.Behaviour.FOLLOW),
        CENTER("runecraftory.gui.companion.behaviour.center", BaseMonster.Behaviour.WANDER),
        CENTER_FARM("runecraftory.gui.companion.behaviour.center", BaseMonster.Behaviour.FARM);

        public final String translation;
        public final BaseMonster.Behaviour behaviour;

        private Type(String translation, BaseMonster.Behaviour behaviour) {
            this.translation = translation;
            this.behaviour = behaviour;
        }
    }
}

