/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class S2CCapSync
implements Packet {
    public static final class_2960 ID = new class_2960("runecraftory", "s2c_player_data_sync");
    private final EnumMap<EnumSkills, LevelExpPair> skillMap = new EnumMap(EnumSkills.class);
    private int money;
    private int runePoints;
    private float runePointsMax;
    private float str;
    private float vit;
    private float intel;
    private LevelExpPair level = new LevelExpPair();
    private class_2487 spells;
    private class_2487 foodData;
    private Collection<class_2960> recipes;

    private S2CCapSync() {
    }

    public S2CCapSync(PlayerData data) {
        this.money = data.getMoney();
        this.runePoints = data.getRunePoints();
        this.runePointsMax = data.getMaxRunePointsRaw();
        this.str = data.getStr();
        this.intel = data.getIntel();
        this.vit = data.getVit();
        this.level = data.getPlayerLevel();
        for (EnumSkills skill : EnumSkills.values()) {
            this.skillMap.put(skill, data.getSkillLevel(skill));
        }
        this.spells = data.getInv().save();
        this.foodData = data.foodBuffNBT();
        this.recipes = data.getRecipeKeeper().unlockedRecipes();
    }

    public static S2CCapSync read(class_2540 buf) {
        S2CCapSync pkt = new S2CCapSync();
        pkt.money = buf.readInt();
        pkt.runePoints = buf.readInt();
        pkt.runePointsMax = buf.readFloat();
        pkt.str = buf.readFloat();
        pkt.intel = buf.readFloat();
        pkt.vit = buf.readFloat();
        pkt.level.fromPacket(buf);
        int l = buf.readInt();
        for (int i = 0; i < l; ++i) {
            EnumSkills skill = (EnumSkills)buf.method_10818(EnumSkills.class);
            pkt.skillMap.put(skill, new LevelExpPair(buf));
        }
        pkt.spells = buf.method_10798();
        pkt.foodData = buf.method_10798();
        pkt.recipes = new HashSet<class_2960>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            pkt.recipes.add(buf.method_10810());
        }
        return pkt;
    }

    public static void handle(S2CCapSync pkt) {
        class_1657 player = ClientHandlers.getPlayer();
        if (player == null) {
            return;
        }
        Platform.INSTANCE.getPlayerData(player).ifPresent(data -> {
            data.setMoney(player, pkt.money);
            data.setRunePoints(player, pkt.runePoints);
            data.setMaxRunePoints(player, pkt.runePointsMax);
            data.setStr(player, pkt.str);
            data.setVit(player, pkt.vit);
            data.setIntel(player, pkt.intel);
            data.getPlayerLevel().from(pkt.level);
            pkt.skillMap.forEach((skill, val) -> data.getSkillLevel((EnumSkills)((Object)((Object)skill))).from((LevelExpPair)val));
            data.getInv().load(pkt.spells);
            data.readFoodBuffFromNBT(pkt.foodData);
            data.getRecipeKeeper().clientUpdate(pkt.recipes);
        });
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(this.money);
        buf.writeInt(this.runePoints);
        buf.writeFloat(this.runePointsMax);
        buf.writeFloat(this.str);
        buf.writeFloat(this.intel);
        buf.writeFloat(this.vit);
        this.level.toPacket(buf);
        buf.writeInt(EnumSkills.values().length);
        for (EnumSkills skill : EnumSkills.values()) {
            buf.method_10817((Enum)skill);
            LevelExpPair xp = this.skillMap.getOrDefault((Object)skill, new LevelExpPair());
            xp.toPacket(buf);
        }
        buf.method_10794(this.spells);
        buf.method_10794(this.foodData);
        buf.writeInt(this.recipes.size());
        this.recipes.forEach(arg_0 -> ((class_2540)buf).method_10812(arg_0));
    }

    @Override
    public class_2960 getID() {
        return ID;
    }
}

