/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.world.family.SyncedFamilyData;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class S2COpenNPCGui
implements Packet {
    public static final class_2960 ID = new class_2960("runecraftory", "s2c_npc_gui");
    private final int entityID;
    private final ShopState isShopOpen;
    private final int followState;
    private final Map<String, List<class_2561>> actions;
    private final class_2960 quest;
    private final SyncedFamilyData family;

    private S2COpenNPCGui(int id, ShopState isShopOpen, int followState, Map<String, List<class_2561>> actions, class_2960 quest, SyncedFamilyData family) {
        this.entityID = id;
        this.isShopOpen = isShopOpen;
        this.followState = followState;
        this.actions = actions;
        this.quest = quest;
        this.family = family;
    }

    public S2COpenNPCGui(EntityNPCBase entity, class_3222 player) {
        this.entityID = entity.method_5628();
        this.isShopOpen = entity.canTrade();
        this.actions = entity.getShop().actions(entity, player);
        this.quest = QuestHandler.questForExists(player, entity);
        this.followState = entity.getEntityToFollowUUID() == null ? (Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> d.party.isPartyFull()).orElse(true) != false ? 2 : 0) : (entity.getEntityToFollowUUID().equals(player.method_5667()) ? 1 : 2);
        this.family = entity.getFamily().forSyncing(entity, player);
    }

    public static S2COpenNPCGui read(class_2540 buf) {
        return new S2COpenNPCGui(buf.readInt(), (ShopState)buf.method_10818(ShopState.class), buf.readInt(), buf.method_34069(LinkedHashMap::new, class_2540::method_19772, b -> b.method_34066(class_2540::method_10808)), !buf.readBoolean() ? null : buf.method_10810(), new SyncedFamilyData(buf));
    }

    public static void handle(S2COpenNPCGui pkt) {
        ClientHandlers.openNPCChat(pkt.entityID, pkt.isShopOpen, pkt.family, pkt.followState, pkt.actions, pkt.quest);
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(this.entityID);
        buf.method_10817((Enum)this.isShopOpen);
        buf.writeInt(this.followState);
        buf.method_34063(this.actions, class_2540::method_10814, (buf1, components) -> buf1.method_34062((Collection)components, class_2540::method_10805));
        buf.writeBoolean(this.quest != null);
        if (this.quest != null) {
            buf.method_10812(this.quest);
        }
        this.family.toPacket(buf);
    }

    @Override
    public class_2960 getID() {
        return ID;
    }
}

