/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityTreasureChest;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.simplequests_api.datapack.QuestsManager;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.QuestCategory;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.registry.QuestBaseRegistry;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2048;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_5250;
import net.minecraft.class_5575;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class NPCQuest
extends QuestBase {
    public static final class_2960 ID = new class_2960("runecraftory", "npc_quest");
    public static final Function<QuestBaseRegistry.CodecContext, Codec<NPCQuest>> CODEC = class_156.method_34866(ctx -> QuestBase.buildCodec((RecordCodecBuilder)NPCQuestData.CODEC.forGetter(q -> new NPCQuestData(q.npcDataIDs, q.quests, q.loot, q.global, q.dynamicData)), (QuestBaseRegistry.CodecContext)ctx, (id, task, data) -> {
        Builder builder = new Builder(id, task, data.npcIDs, data.loot);
        if (data.global) {
            builder.global();
        }
        builder.withQuests(data.quests);
        if (data.dynamic != null) {
            builder.withData(data.dynamic());
        }
        return builder;
    }));
    private EntityNPCBase npc;
    private DynamicQuestData dynamicData;
    public final List<class_2960> npcDataIDs;
    public final List<class_2960> quests;
    public final class_2960 loot;
    public final boolean global;

    private NPCQuest(class_2960 id, QuestCategory category, String questTaskString, List<String> questTaskDesc, List<class_2960> parents, boolean redoParent, int repeatDelay, int maxRepeat, int sortingId, class_2048 unlockCondition, List<class_2960> npcDataIDs, List<class_2960> quests, class_2960 loot, boolean global) {
        super(id, category, questTaskString, questTaskDesc, parents, redoParent, false, class_1799.field_8037, repeatDelay, 0, maxRepeat, sortingId, false, unlockCondition, QuestBase.Visibility.NEVER);
        this.npcDataIDs = npcDataIDs;
        this.quests = quests;
        this.loot = loot;
        this.global = global;
    }

    private static class_2960 withUuid(class_2960 original, UUID uuid) {
        if (uuid == null) {
            return original;
        }
        return new class_2960(original.method_12836(), original.method_12832() + "/" + String.valueOf(uuid));
    }

    private static class_238 aabbOf(class_243 pos) {
        return new class_238(pos.method_1031(-48.0, -48.0, -48.0), pos.method_1031(48.0, 48.0, 48.0));
    }

    public static List<NPCQuest> resolve(NPCQuest quest, class_3222 player, class_243 at) {
        return player.field_6002.method_18023(class_5575.method_31795(EntityNPCBase.class), NPCQuest.aabbOf(at), e -> {
            if (quest.npcDataIDs.contains(e.getDataID()) && e.canAcceptNPCQuest(player, quest)) {
                class_2960 id = QuestHandler.questForExists(player, e);
                return id == null || quest.getOriginID().equals((Object)id);
            }
            return false;
        }).stream().map(quest::forNPC).toList();
    }

    private NPCQuest forNPC(EntityNPCBase npc) {
        class_2960 newID = NPCQuest.withUuid(this.id, npc.method_5667());
        NPCQuest quest = new NPCQuest(newID, this.category, this.name, this.description, this.npcDataIDs, this.redoParent, this.repeatDelay, this.maxRepeat, this.sortingId, this.unlockCondition, this.npcDataIDs, this.quests, this.loot, this.global);
        quest.withNPC(npc, this.id);
        return quest;
    }

    private void withNPC(EntityNPCBase npc, class_2960 originID) {
        this.npc = npc;
        this.withNPC(npc.method_5667(), originID);
    }

    private void withNPC(UUID npc, class_2960 originID) {
        this.dynamicData = new DynamicQuestData(npc, originID);
    }

    public class_2960 getTypeId() {
        return ID;
    }

    public boolean isUnlocked(class_3222 player) {
        return super.isUnlocked(player) && (this.getNpc(player.field_6002) == null || this.getNpc(player.field_6002).canAcceptNPCQuest(player, this));
    }

    public class_5250 getName(class_3222 player, int idx) {
        return new class_2588(this.name);
    }

    public List<class_5250> getDescription(class_3222 player, int idx) {
        EntityNPCBase npc = this.getNpc(player.field_6002);
        if (npc != null) {
            return this.description.stream().map(s -> new class_2588(s, new Object[]{npc.method_5797(), npc.method_23317(), npc.method_23318(), npc.method_23321()})).collect(Collectors.toList());
        }
        return super.getDescription(player, idx);
    }

    public UUID getNpcUuid() {
        return this.dynamicData != null ? this.dynamicData.npcUuid() : null;
    }

    @Nullable
    public EntityNPCBase getNpc(class_1937 level) {
        if (this.dynamicData != null && this.npc == null) {
            this.npc = (EntityNPCBase)EntityUtil.findFromUUID(EntityNPCBase.class, (class_1937)level, (UUID)this.dynamicData.npcUuid());
        }
        return this.npc;
    }

    public class_2960 getOriginID() {
        return this.dynamicData != null ? this.dynamicData.origin() : this.id;
    }

    public String submissionTrigger(class_3222 player, int idx) {
        if (this.dynamicData == null) {
            return super.submissionTrigger(player, idx);
        }
        return this.dynamicData.npcUuid().toString();
    }

    public QuestBase resolveToQuest(class_3222 player, int idx) {
        if (idx < 0 || idx >= this.quests.size()) {
            return null;
        }
        class_2960 id = this.quests.get(idx);
        QuestBase quest = QuestsManager.instance().getQuest(id);
        if (quest == null) {
            return null;
        }
        return quest.resolveToQuest(player, 0);
    }

    public class_2960 getLoot() {
        return this.loot;
    }

    public void onComplete(class_3222 serverPlayer) {
        EntityTreasureChest chest = (EntityTreasureChest)((class_1299)ModEntities.TREASURE_CHEST.get()).method_5883((class_1937)serverPlayer.method_14220());
        if (chest != null && this.getLoot() != null && !this.getLoot().equals((Object)class_39.field_844)) {
            chest.method_5641(serverPlayer.method_23316(2.0), serverPlayer.method_23323(1.5), serverPlayer.method_23324(2.0), serverPlayer.method_6051().nextFloat() * 360.0f, 0.0f);
            for (int tries = 0; !serverPlayer.field_6002.method_17892((class_1297)chest) && tries < 10; ++tries) {
                chest.method_5641(serverPlayer.method_23316(2.0), serverPlayer.method_23323(1.5), serverPlayer.method_23324(2.0), serverPlayer.method_6051().nextFloat() * 360.0f, 0.0f);
            }
            chest.setChestLoot(this.loot);
            serverPlayer.method_14220().method_8649((class_1297)chest);
        }
        if (this.getNpc(serverPlayer.field_6002) != null) {
            this.getNpc(serverPlayer.field_6002).completeNPCQuest(serverPlayer, this);
        }
        this.onReset(serverPlayer);
    }

    public void onReset(class_3222 player) {
        if (this.dynamicData != null) {
            EntityNPCBase npc = this.getNpc(player.field_6002);
            if (npc != null) {
                npc.resetQuestProcess(player, this.dynamicData.origin());
            } else {
                WorldHandler.get((MinecraftServer)player.method_5682()).npcHandler.scheduleQuestTrackerReset(this.dynamicData.npcUuid(), player.method_5667(), this.dynamicData.origin());
            }
        }
    }

    public Map<String, ResolvedQuestTask> resolveTasks(PlayerQuestData data, QuestProgress progress, int idx) {
        QuestBase base = this.resolveToQuest(data.getPlayer(), idx);
        if (base == null) {
            return Map.of();
        }
        return base.resolveTasks(data, progress, 0);
    }

    public boolean isDynamic() {
        return this.dynamicData != null;
    }

    private record DynamicQuestData(UUID npcUuid, class_2960 origin) {
        static final Codec<DynamicQuestData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("npcUuid").forGetter(d -> d.npcUuid), (App)class_2960.field_25139.fieldOf("origin_id").forGetter(d -> d.origin)).apply((Applicative)inst, DynamicQuestData::new));
    }

    private record NPCQuestData(List<class_2960> npcIDs, List<class_2960> quests, class_2960 loot, boolean global, DynamicQuestData dynamic) {
        static final MapCodec<NPCQuestData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("global").forGetter(d -> d.global ? Optional.of(true) : Optional.empty()), (App)DynamicQuestData.CODEC.optionalFieldOf("dynamic_data").forGetter(d -> Optional.ofNullable(d.dynamic)), (App)class_2960.field_25139.listOf().fieldOf("target_npc_ids").forGetter(d -> d.npcIDs), (App)class_2960.field_25139.listOf().fieldOf("quests").forGetter(d -> d.quests), (App)class_2960.field_25139.fieldOf("loot_table").forGetter(d -> d.loot)).apply((Applicative)inst, (global, dynamic, target, quests, loot) -> new NPCQuestData((List<class_2960>)target, (List<class_2960>)quests, (class_2960)loot, global.orElse(false), dynamic.orElse(null))));
    }

    public static class Builder
    extends QuestBase.BuilderBase<NPCQuest, Builder> {
        private final List<class_2960> npcDataID;
        private final List<class_2960> quests = new ArrayList<class_2960>();
        private final class_2960 loot;
        private boolean global;
        private DynamicQuestData dynamic;

        public Builder(class_2960 id, String task, class_2960 npcDataID, class_2960 loot) {
            this(id, task, List.of(npcDataID), loot);
        }

        public Builder(class_2960 id, String task, List<class_2960> npcDataID, class_2960 loot) {
            super(id, task);
            this.npcDataID = npcDataID;
            this.loot = loot;
        }

        public Builder withQuests(class_2960 ... quest) {
            this.quests.addAll(List.of(quest));
            return this;
        }

        public Builder withQuests(Collection<class_2960> quest) {
            this.quests.addAll(quest);
            return this;
        }

        public Builder global() {
            this.global = true;
            return this;
        }

        private Builder withData(DynamicQuestData dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public class_2960 getID() {
            return this.id;
        }

        protected Builder asThis() {
            return this;
        }

        public NPCQuest build() {
            if (this.quests.isEmpty()) {
                throw new IllegalStateException("Quests not defined");
            }
            NPCQuest quest = new NPCQuest(this.id, this.category, this.name, this.description, this.neededParentQuests, this.redoParent, this.repeatDelay, this.maxRepeat, this.sortingId, this.unlockCondition, this.npcDataID, this.quests, this.loot, this.global);
            if (this.dynamic != null) {
                quest.withNPC(this.dynamic.npcUuid(), this.dynamic.origin());
            }
            return quest;
        }
    }
}

