/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import net.minecraft.class_1657;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5658;
import net.minecraft.class_5699;

public class LevelTask
implements QuestTask<LevelTaskResolved> {
    public static final QuestEntryKey<LevelTask> ID = new QuestEntryKey(new class_2960("runecraftory", "level"));
    public static final Codec<LevelTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("level").forGetter(d -> d.range)).apply((Applicative)instance, LevelTask::new));
    private final String description;
    private final class_5658 range;

    public LevelTask(String description, class_5658 range) {
        this.description = description;
        this.range = range;
        if (this.description.isEmpty() && !(this.range instanceof class_44)) {
            throw new IllegalStateException("Description is required");
        }
    }

    public class_5250 translation(class_3222 player) {
        if (this.description.isEmpty() && this.range instanceof class_44) {
            return new class_2588(this.getId().toString(), new Object[]{this.range.method_366(null)});
        }
        return new class_2588(this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public LevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        class_47 ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (class_2960)base.id);
        return new LevelTaskResolved(this.range.method_366(ctx));
    }

    public record LevelTaskResolved(int level) implements ResolvedQuestTask
    {
        public static final Codec<LevelTaskResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33442.fieldOf("level").forGetter(d -> d.level)).apply((Applicative)instance, LevelTaskResolved::new));

        public boolean submit(class_3222 player) {
            return Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> d.getPlayerLevel().getLevel() >= this.level).orElse(false);
        }

        public QuestEntryKey<LevelTask> getId() {
            return ID;
        }

        public class_5250 translation(class_3222 player) {
            return new class_2588(this.getId().toString(), new Object[]{this.level});
        }
    }
}

