/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.quests.NPCQuest;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.util.JsonCodecs;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2048;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class NPCTalkTask
implements QuestTask<NPCTalkResolved> {
    public static final QuestEntryKey<NPCTalkTask> ID = new QuestEntryKey(new class_2960("runecraftory", "npc_talk"));
    public static final Codec<NPCTalkTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("target_npc_id").forGetter(d -> Optional.ofNullable(d.targetNPCId)), (App)JsonCodecs.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> d.predicate == class_2048.field_9599 ? Optional.empty() : Optional.of(d.predicate))).apply((Applicative)instance, (npcId, predicate) -> new NPCTalkTask(npcId.orElse(null), predicate.orElse(null))));
    private final class_2960 targetNPCId;
    private final class_2048 predicate;

    public NPCTalkTask(class_2960 generic) {
        this(generic, class_2048.field_9599);
    }

    protected NPCTalkTask(class_2960 generic, class_2048 predicate) {
        this.targetNPCId = generic;
        this.predicate = predicate;
    }

    public QuestEntryKey<NPCTalkTask> getId() {
        return ID;
    }

    public class_5250 translation(class_3222 player) {
        return new class_2588(this.getId().toString() + ".not_resolved");
    }

    public NPCTalkResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase quest) {
        QuestBase questBase = progress.getQuest();
        if (questBase instanceof NPCQuest) {
            NPCQuest npcQuest = (NPCQuest)questBase;
            return new NPCTalkResolved(npcQuest.getNpcUuid(), this.predicate);
        }
        return null;
    }

    public static class NPCTalkResolved
    implements ResolvedQuestTask {
        public static final Codec<NPCTalkResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("target_npc").xmap(UUID::fromString, UUID::toString).forGetter(d -> d.targetNPC), (App)JsonCodecs.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> Optional.ofNullable(d.predicate))).apply((Applicative)instance, (target, predicate) -> new NPCTalkResolved((UUID)target, predicate.orElse(null))));
        private final UUID targetNPC;
        private final class_2048 predicate;
        private EntityNPCBase npc;

        public NPCTalkResolved(UUID targetNPC, class_2048 predicate) {
            this.targetNPC = targetNPC;
            this.predicate = predicate;
        }

        public boolean submit(class_3222 player) {
            return false;
        }

        public QuestEntryKey<NPCTalkTask> getId() {
            return ID;
        }

        public class_5250 translation(class_3222 player) {
            class_2561 name;
            if (this.npc == null || !this.npc.method_5805()) {
                this.npc = this.targetNPC == null ? null : (EntityNPCBase)EntityUtil.findFromUUID(EntityNPCBase.class, (class_1937)player.method_14220(), (UUID)this.targetNPC);
            }
            if ((name = this.npc == null ? (this.targetNPC != null ? WorldHandler.get((MinecraftServer)player.method_5682()).npcHandler.getName(this.targetNPC) : null) : this.npc.method_5477()) != null) {
                return new class_2588(this.getId().toString(), new Object[]{name});
            }
            return new class_2588(this.getId().toString() + ".generic");
        }

        public boolean trySubmit(class_3222 player, EntityNPCBase npc) {
            return npc.method_5667().equals(this.targetNPC) && (this.predicate == null || this.predicate.method_8914(player, (class_1297)npc));
        }
    }
}

