/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.util.DescriptiveValue;
import io.github.flemmli97.simplequests_api.util.JsonCodecs;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2073;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5658;
import net.minecraft.class_5699;

public class ShippingTask
implements QuestTask<SkillLevelTaskResolved> {
    public static final QuestEntryKey<ShippingTask> ID = new QuestEntryKey(new class_2960("runecraftory", "shipping"));
    public static final Codec<ShippingTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)CodecHelper.nonEmptyList(DescriptiveValue.withTranslation(CodecHelper.ITEM_PREDICATE_CODEC), "Item predicates can't be empty").fieldOf("item_predicates").forGetter(d -> d.itemPredicates), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, ShippingTask::new));
    private final String description;
    private final List<DescriptiveValue<class_2073>> itemPredicates;
    private final class_5658 amount;

    public ShippingTask(String description, List<DescriptiveValue<class_2073>> itemPredicates, class_5658 amount) {
        this.description = description;
        this.itemPredicates = itemPredicates;
        this.amount = amount;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.itemPredicates.size() == 1 && this.amount instanceof class_44;
    }

    public class_5250 translation(class_3222 player) {
        if (this.description.isEmpty() && this.simple()) {
            return this.itemPredicates.get(0).getTranslation(this.getId().toString(), new Object[]{this.amount.method_366(null)});
        }
        return new class_2588(this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public SkillLevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        class_47 ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (class_2960)base.id);
        DescriptiveValue<class_2073> val = this.itemPredicates.get(ctx.method_294().nextInt(this.itemPredicates.size()));
        return new SkillLevelTaskResolved(val, this.amount.method_366(ctx));
    }

    public record SkillLevelTaskResolved(DescriptiveValue<class_2073> item, int amount) implements ResolvedQuestTask
    {
        public static final Codec<SkillLevelTaskResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DescriptiveValue.withTranslation((Codec)JsonCodecs.ITEM_PREDICATE_CODEC).fieldOf("item").forGetter(d -> d.item), (App)class_5699.field_33442.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, SkillLevelTaskResolved::new));

        public boolean submit(class_3222 player) {
            return Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> d.getPlayerLevel().getLevel() >= this.amount).orElse(false);
        }

        public QuestEntryKey<ShippingTask> getId() {
            return ID;
        }

        public class_5250 translation(class_3222 player) {
            return this.item.getTranslation(this.getId().toString(), new Object[]{this.amount});
        }
    }
}

