/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5658;
import net.minecraft.class_5699;

public class SkillLevelTask
implements QuestTask<SkillLevelTaskResolved> {
    public static final QuestEntryKey<SkillLevelTask> ID = new QuestEntryKey(new class_2960("runecraftory", "skill_level"));
    public static final Codec<SkillLevelTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)CodecHelper.nonEmptyList(CodecUtils.stringEnumCodec(EnumSkills.class, null), "Skill list can't be empty").fieldOf("skill").forGetter(d -> d.skills), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("level").forGetter(d -> d.range)).apply((Applicative)instance, SkillLevelTask::new));
    private final String description;
    private final List<EnumSkills> skills;
    private final class_5658 range;

    public SkillLevelTask(String description, List<EnumSkills> skills, class_5658 range) {
        this.description = description;
        this.skills = skills;
        this.range = range;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.skills.size() == 1 && this.range instanceof class_44;
    }

    public class_5250 translation(class_3222 player) {
        if (this.description.isEmpty() && this.simple()) {
            EnumSkills skill = this.skills.get(0);
            return new class_2588(this.getId().toString(), new Object[]{skill, this.range.method_366(null)});
        }
        return new class_2588(this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public SkillLevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        class_47 ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (class_2960)base.id);
        EnumSkills skills = this.skills.get(ctx.method_294().nextInt(this.skills.size()));
        return new SkillLevelTaskResolved(skills, this.range.method_366(ctx));
    }

    public record SkillLevelTaskResolved(EnumSkills skill, int level) implements ResolvedQuestTask
    {
        public static final Codec<SkillLevelTaskResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.stringEnumCodec(EnumSkills.class, null).fieldOf("skill").forGetter(d -> d.skill), (App)class_5699.field_33442.fieldOf("level").forGetter(d -> d.level)).apply((Applicative)instance, SkillLevelTaskResolved::new));

        public boolean submit(class_3222 player) {
            return Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> d.getPlayerLevel().getLevel() >= this.level).orElse(false);
        }

        public QuestEntryKey<SkillLevelTask> getId() {
            return ID;
        }

        public class_5250 translation(class_3222 player) {
            return new class_2588(this.getId().toString(), new Object[]{this.skill, this.level});
        }
    }
}

