/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.util.DescriptiveValue;
import io.github.flemmli97.simplequests_api.util.JsonCodecs;
import java.util.List;
import net.minecraft.class_2048;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5658;
import net.minecraft.class_5699;

public class TamingTask
implements QuestTask<TamingTaskResolved> {
    public static final QuestEntryKey<TamingTask> ID = new QuestEntryKey(new class_2960("runecraftory", "taming"));
    public static final Codec<TamingTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)JsonCodecs.nonEmptyList((Codec)DescriptiveValue.withTranslation((Codec)JsonCodecs.ENTITY_PREDICATE_CODEC), (String)"predicates can't be empty").fieldOf("predicates").forGetter(d -> d.predicates), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, TamingTask::new));
    private final String description;
    private final List<DescriptiveValue<class_2048>> predicates;
    private final class_5658 amount;

    public TamingTask(String description, List<DescriptiveValue<class_2048>> predicates, class_5658 amount) {
        this.description = description;
        this.predicates = predicates;
        this.amount = amount;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.predicates.size() == 1 && this.amount instanceof class_44;
    }

    public class_5250 translation(class_3222 player) {
        if (this.description.isEmpty() && this.simple()) {
            return this.predicates.get(0).getTranslation(this.getId().toString(), new Object[]{this.amount.method_366(null)});
        }
        return new class_2588(this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public TamingTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        class_47 ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (class_2960)base.id);
        DescriptiveValue<class_2048> val = this.predicates.get(ctx.method_294().nextInt(this.predicates.size()));
        return new TamingTaskResolved(val, this.amount.method_366(ctx));
    }

    public record TamingTaskResolved(DescriptiveValue<class_2048> predicate, int amount) implements ResolvedQuestTask
    {
        public static final Codec<TamingTaskResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DescriptiveValue.withTranslation((Codec)JsonCodecs.ENTITY_PREDICATE_CODEC).fieldOf("predicate").forGetter(d -> d.predicate), (App)class_5699.field_33442.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, TamingTaskResolved::new));

        public boolean submit(class_3222 player) {
            return false;
        }

        public QuestEntryKey<TamingTask> getId() {
            return ID;
        }

        public class_5250 translation(class_3222 player) {
            return this.predicate.getTranslation(this.getId().toString(), new Object[]{this.amount});
        }
    }
}

