/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.flemmli97.runecraftory.common.entities.npc.job.BathhouseAttendant;
import io.github.flemmli97.runecraftory.common.entities.npc.job.Cook;
import io.github.flemmli97.runecraftory.common.entities.npc.job.Doctor;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.entities.npc.job.Smith;
import io.github.flemmli97.runecraftory.common.registry.ModPoiTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4158;

public class ModNPCJobs {
    public static final Codec<NPCJob> CODEC = class_2960.field_25139.flatXmap(res -> ModNPCJobs.getOptional(res).map(DataResult::success).orElse(DataResult.error((String)("Unknown job: " + String.valueOf(res)))), val -> ModNPCJobs.getOptionalIDFrom(val).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Job not registered:" + String.valueOf(val)))));
    public static final List<class_2960> DEFAULT_JOB_ID = new ArrayList<class_2960>();
    private static int I = 0;
    private static final BiMap<class_2960, NPCJob> JOBREGISTRY = HashBiMap.create();
    private static final BiMap<Integer, NPCJob> JOBREGISTRY_ID = HashBiMap.create();
    private static final class_2960 DEFAULT_KEY = new class_2960("runecraftory", "jobless");
    public static final Pair<class_2960, NPCJob> NONE = ModNPCJobs.register(DEFAULT_KEY, new NPCJob(new NPCJob.Builder(null).noShop().noWorkSchedule()));
    public static final Pair<class_2960, NPCJob> GENERAL = ModNPCJobs.register("general_store", new NPCJob(new NPCJob.Builder(() -> class_4158.field_18507)));
    public static final Pair<class_2960, NPCJob> FLOWER = ModNPCJobs.register("florist", new NPCJob(new NPCJob.Builder(() -> class_4158.field_18507)));
    public static final Pair<class_2960, NPCJob> SMITH = ModNPCJobs.register("smith", (NPCJob)new Smith(new NPCJob.Builder(() -> class_4158.field_18515)));
    public static final Pair<class_2960, NPCJob> DOCTOR = ModNPCJobs.register("doctor", (NPCJob)new Doctor(new NPCJob.Builder(() -> class_4158.field_18506)));
    public static final Pair<class_2960, NPCJob> COOK = ModNPCJobs.register("cook", (NPCJob)new Cook(new NPCJob.Builder(() -> class_4158.field_18504)));
    public static final Pair<class_2960, NPCJob> MAGIC = ModNPCJobs.register("magicskill_merchant", new NPCJob(new NPCJob.Builder((Supplier<class_4158>)ModPoiTypes.CASH_REGISTER)));
    public static final Pair<class_2960, NPCJob> RUNE_SKILLS = ModNPCJobs.register("runeskill_merchant", new NPCJob(new NPCJob.Builder((Supplier<class_4158>)ModPoiTypes.CASH_REGISTER)));
    public static final Pair<class_2960, NPCJob> BATHHOUSE = ModNPCJobs.register("bathhouse_attendant", (NPCJob)new BathhouseAttendant(new NPCJob.Builder((Supplier<class_4158>)ModPoiTypes.CASH_REGISTER).noShop()));
    public static final Pair<class_2960, NPCJob> RANDOM = ModNPCJobs.register("travelling_merchant", new NPCJob(new NPCJob.Builder(null).noSchedule()));
    private static List<NPCJob> ALLJOBS;

    private static Pair<class_2960, NPCJob> register(String name, NPCJob job) {
        class_2960 res = new class_2960("runecraftory", name);
        Pair<class_2960, NPCJob> pair = ModNPCJobs.register(res, job);
        DEFAULT_JOB_ID.add(res);
        return pair;
    }

    public static Pair<class_2960, NPCJob> register(class_2960 res, NPCJob job) {
        if (JOBREGISTRY.containsKey((Object)res)) {
            throw new IllegalStateException("An entry with key " + String.valueOf(res) + " is already registered");
        }
        JOBREGISTRY.put((Object)res, (Object)job);
        JOBREGISTRY_ID.put((Object)I++, (Object)job);
        return Pair.of((Object)res, (Object)job);
    }

    public static NPCJob getFromID(class_2960 res) {
        return (NPCJob)JOBREGISTRY.getOrDefault((Object)res, (Object)((NPCJob)NONE.getSecond()));
    }

    public static Optional<NPCJob> getOptional(class_2960 res) {
        return Optional.ofNullable((NPCJob)JOBREGISTRY.get((Object)res));
    }

    public static class_2960 getIDFrom(NPCJob job) {
        class_2960 res = (class_2960)JOBREGISTRY.inverse().get((Object)job);
        return res == null ? (class_2960)JOBREGISTRY.inverse().get((Object)job) : res;
    }

    public static Optional<class_2960> getOptionalIDFrom(NPCJob job) {
        return Optional.ofNullable((class_2960)JOBREGISTRY.inverse().get((Object)job));
    }

    public static List<NPCJob> allJobs() {
        if (ALLJOBS == null) {
            ALLJOBS = JOBREGISTRY_ID.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).toList();
        }
        return ALLJOBS;
    }

    public static List<NPCJob> jobsWithShops() {
        return ModNPCJobs.allJobs().stream().filter(j -> j.hasShop).toList();
    }

    public static NPCJob getRandomJob(Random random) {
        return ModNPCJobs.allJobs().get(random.nextInt(ModNPCJobs.allJobs().size()));
    }

    public static NPCJob getFromSyncID(int id) {
        return (NPCJob)JOBREGISTRY_ID.getOrDefault((Object)id, (Object)((NPCJob)NONE.getSecond()));
    }

    public static int getSyncIDFrom(NPCJob job) {
        return (Integer)JOBREGISTRY_ID.inverse().getOrDefault((Object)job, (Object)-1);
    }

    public static class_2960 legacyOfTag(class_2520 tag) {
        if (tag == null) {
            return DEFAULT_KEY;
        }
        if (tag.method_10711() == 8) {
            return new class_2960(tag.method_10714());
        }
        if (tag.method_10711() == 99) {
            int id = ((class_2514)tag).method_10701();
            return switch (id) {
                case 0 -> (class_2960)NONE.getFirst();
                case 1 -> (class_2960)GENERAL.getFirst();
                case 2 -> (class_2960)FLOWER.getFirst();
                case 3 -> (class_2960)SMITH.getFirst();
                case 4 -> (class_2960)DOCTOR.getFirst();
                case 5 -> (class_2960)COOK.getFirst();
                case 6 -> (class_2960)MAGIC.getFirst();
                case 7 -> (class_2960)RUNE_SKILLS.getFirst();
                case 8 -> (class_2960)RANDOM.getFirst();
                default -> DEFAULT_KEY;
            };
        }
        return DEFAULT_KEY;
    }
}

