/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityAppleProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;

public class AppleRain
extends Spell {
    private final Type type;

    public AppleRain(Type type) {
        this.type = type;
    }

    @Override
    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        int apples = switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.NORMAL -> 64;
            case Type.BIG -> 50;
            case Type.LOTS -> 96;
        };
        int range = switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.NORMAL -> 9;
            case Type.BIG -> 10;
            case Type.LOTS -> 12;
        };
        for (int i = 0; i < apples; ++i) {
            EntityAppleProjectile apple = new EntityAppleProjectile((class_1937)level, entity);
            if (this.type == Type.BIG) {
                apple.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.2f));
                apple.withSizeInc(1.0f);
            } else {
                apple.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.1f));
            }
            double x = entity.method_23317() + (entity.method_6051().nextDouble() - 0.5) * (double)range;
            double y = entity.method_23318() + (double)entity.method_17682() + 2.0 + entity.method_6051().nextDouble() * 4.0;
            double z = entity.method_23321() + (entity.method_6051().nextDouble() - 0.5) * (double)range;
            apple.method_5814(x, y, z);
            level.method_8649((class_1297)apple);
        }
        AppleRain.playSound(entity, (class_3414)ModSounds.SPELL_APPLE_RAIN.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.2f);
        return true;
    }

    public static enum Type {
        NORMAL,
        BIG,
        LOTS;

    }
}

