/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityBigRaccoonLeaf;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;

public class BigLeafSpell
extends Spell {
    private final boolean doubleShot;

    public BigLeafSpell(boolean doubleShot) {
        this.doubleShot = doubleShot;
    }

    @Override
    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        int leafs = this.doubleShot ? 2 : 1;
        for (int i = 0; i < leafs; ++i) {
            EntityBigRaccoonLeaf leaf = new EntityBigRaccoonLeaf((class_1937)level, entity);
            leaf.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.1f));
            float vel = i % 2 == 0 ? 1.0f : 0.7f;
            ProjectileUtil.shoot(entity, leaf, vel, 0.0f);
            leaf.setDiameter(i % 2 == 0 ? 4.0 : 7.0);
            leaf.withRightSpin(i % 2 == 0);
            level.method_8649((class_1297)leaf);
        }
        BigLeafSpell.playSound(entity, (class_3414)ModSounds.ENTITY_FLOWER_LILY_STEP.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.2f);
        return true;
    }
}

