/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityWaterLaser;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.UUID;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;

public class DoubleWaterLaserSpell
extends Spell {
    private final float range;

    public DoubleWaterLaserSpell(float range) {
        this.range = range;
    }

    @Override
    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        class_243 dir = entity.method_5720();
        class_243 pos = entity.method_19538().method_1031(0.0, (double)entity.method_5751() - 0.1, 0.0);
        class_243 targetPos = ProjectileUtil.getAimTarget(entity);
        if (targetPos != null) {
            dir = targetPos.method_1020(pos);
        }
        UUID other = null;
        for (int i = 0; i < 2; ++i) {
            float posYawOff = (i == 0 ? -1 : 1) * 30;
            class_1160 vec = RayTraceUtils.rotatedAround((class_243)dir.method_1029(), (class_1160)class_1160.field_20705, (float)posYawOff);
            EntityWaterLaser laser = new EntityWaterLaser((class_1937)level, entity);
            if (i == 0) {
                other = laser.method_5667();
            } else {
                laser.setTwinId(other);
            }
            laser.setRange(this.range);
            laser.method_5814(laser.method_23317() + (double)vec.method_4943(), laser.method_23318() + (double)vec.method_4945(), laser.method_23321() + (double)vec.method_4947());
            laser.setMaxTicks(entity instanceof class_1657 ? class_3532.method_15386((float)PlayerModelAnimations.WATER_LASER_TWO.getLength()) : 15);
            laser.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.1f));
            class_243 target = laser.method_19538().method_1019(dir);
            laser.setRotationTo(target.method_10216(), target.method_10214(), target.method_10215(), 0.0f);
            laser.setPositionYawOffset(posYawOff);
            level.method_8649((class_1297)laser);
        }
        DoubleWaterLaserSpell.playSound(entity, (class_3414)ModSounds.SPELL_GENERIC_WATER.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    @Override
    public AttackAction useAction() {
        return (AttackAction)((Object)ModAttackActions.DOUBLE_WATER_LASER_USE.get());
    }
}

