/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityFireball;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;

public class FireballSpell
extends Spell {
    public final boolean big;

    public FireballSpell(boolean big) {
        this.big = big;
    }

    @Override
    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        EntityFireball ball = new EntityFireball((class_1937)level, entity, this.big);
        ProjectileUtil.shoot(entity, ball, 1.0f, 0.0f);
        ball.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this.big ? 1.0f : 0.8f));
        level.method_8649((class_1297)ball);
        FireballSpell.playSound(entity, (class_3414)ModSounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return Platform.INSTANCE.getPlayerData(player).map(cap -> cap.getWeaponHandler().canExecuteAction(this.useAction())).orElse(false) == false;
        }
        return true;
    }

    @Override
    public AttackAction useAction() {
        return this.big ? (AttackAction)((Object)ModAttackActions.FIREBALL_BIG_USE.get()) : (AttackAction)((Object)ModAttackActions.FIREBALL_USE.get());
    }
}

