/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.enums.EnumDay;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Arrays;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class CalendarImpl {
    private int date = 1;
    private EnumDay day = EnumDay.MONDAY;
    private EnumSeason season = EnumSeason.SPRING;
    private EnumWeather[] todaysForecast = new EnumWeather[]{EnumWeather.CLEAR};
    private EnumWeather currentWeather = EnumWeather.CLEAR;
    private EnumWeather[] nextForecast = new EnumWeather[]{EnumWeather.CLEAR};

    public int date() {
        return this.date;
    }

    public EnumDay currentDay() {
        return this.day;
    }

    public EnumSeason currentSeason() {
        return this.season;
    }

    public void setDateDayAndSeason(int date, EnumDay day, EnumSeason season) {
        this.date = date;
        this.day = day;
        this.season = season;
    }

    public EnumWeather currentWeather() {
        return this.currentWeather;
    }

    public EnumWeather getCurrentWeatherFor(class_3218 level) {
        int i = WorldUtils.dayTime((class_1937)level) / 3000;
        if (i >= 0 && i < this.todaysForecast.length) {
            return this.todaysForecast[i];
        }
        return EnumWeather.CLEAR;
    }

    public EnumWeather[] todaysForecast() {
        return this.todaysForecast;
    }

    public EnumWeather[] tomorrowsForecast() {
        return this.nextForecast;
    }

    public void setWeather(MinecraftServer server, EnumWeather weather) {
        this.currentWeather = weather;
        Platform.INSTANCE.sendToAll(new S2CCalendar(this), server);
    }

    public void updateWeathers(EnumWeather[] nextDays) {
        this.todaysForecast = this.nextForecast;
        this.nextForecast = nextDays;
    }

    public void toPacket(class_2540 buffer) {
        buffer.writeInt(this.date);
        buffer.method_10817((Enum)this.day);
        buffer.method_10817((Enum)this.season);
        buffer.method_10817((Enum)this.currentWeather);
    }

    public void fromPacket(class_2540 buffer) {
        this.date = buffer.readInt();
        this.day = (EnumDay)buffer.method_10818(EnumDay.class);
        this.season = (EnumSeason)buffer.method_10818(EnumSeason.class);
        this.currentWeather = (EnumWeather)buffer.method_10818(EnumWeather.class);
    }

    public void read(class_2487 nbt) {
        this.date = nbt.method_10550("Date");
        this.day = EnumDay.valueOf(nbt.method_10558("Day"));
        this.season = EnumSeason.valueOf(nbt.method_10558("Season"));
        this.currentWeather = EnumWeather.valueOf(nbt.method_10558("Weather"));
        class_2499 list = nbt.method_10554("Forecast", 8);
        this.todaysForecast = (EnumWeather[])list.stream().map(t -> EnumWeather.valueOf(t.method_10714())).limit(8L).toArray(EnumWeather[]::new);
        class_2499 next = nbt.method_10554("NextForecast", 8);
        this.nextForecast = (EnumWeather[])next.stream().map(t -> EnumWeather.valueOf(t.method_10714())).limit(8L).toArray(EnumWeather[]::new);
    }

    public class_2487 write(class_2487 nbt) {
        nbt.method_10569("Date", this.date);
        nbt.method_10582("Day", this.day.toString());
        nbt.method_10582("Season", this.season.toString());
        nbt.method_10582("Weather", this.currentWeather.toString());
        class_2499 list = new class_2499();
        Arrays.stream(this.todaysForecast).forEach(w -> list.add((Object)class_2519.method_23256((String)w.toString())));
        nbt.method_10566("Forecast", (class_2520)list);
        class_2499 next = new class_2499();
        Arrays.stream(this.nextForecast).forEach(w -> next.add((Object)class_2519.method_23256((String)w.toString())));
        nbt.method_10566("NextForecast", (class_2520)next);
        return nbt;
    }
}

