/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.entities.utils.ElementalAttackMob;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class CombatUtils {
    private static final UUID TEMP_ATTRIBUTE_MOD = UUID.fromString("5c8e5c2d-1eb0-434a-858f-8ab81f51832c");
    private static final UUID TEMP_ATTRIBUTE_MOD_MULT = UUID.fromString("e2465d35-6c65-4ec8-a13c-a305a9d34c66");

    public static double getAttributeValue(class_1297 entity, class_1320 att) {
        if (!(entity instanceof class_1309)) {
            return 0.0;
        }
        class_1309 attacker = (class_1309)entity;
        double increase = 0.0;
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            increase += Platform.INSTANCE.getPlayerData(player).map(cap -> cap.getAttributeValue((class_1657)attacker, att)).orElse(0.0).doubleValue();
        } else if (attacker.method_5996(att) != null) {
            increase += attacker.method_26825(att);
        }
        int inc = (int)increase;
        double restRound = (double)Math.round((increase - (double)inc) * 2.0) / 2.0;
        return (double)inc + restRound;
    }

    public static class_1320 opposing(class_1320 att) {
        if (att == ModAttributes.PARA.get()) {
            return (class_1320)ModAttributes.RES_PARA.get();
        }
        if (att == ModAttributes.POISON.get()) {
            return (class_1320)ModAttributes.RES_POISON.get();
        }
        if (att == ModAttributes.SEAL.get()) {
            return (class_1320)ModAttributes.RES_SEAL.get();
        }
        if (att == ModAttributes.SLEEP.get()) {
            return (class_1320)ModAttributes.RES_SLEEP.get();
        }
        if (att == ModAttributes.FATIGUE.get()) {
            return (class_1320)ModAttributes.RES_FAT.get();
        }
        if (att == ModAttributes.COLD.get()) {
            return (class_1320)ModAttributes.RES_COLD.get();
        }
        if (att == ModAttributes.DIZZY.get()) {
            return (class_1320)ModAttributes.RES_DIZZY.get();
        }
        if (att == ModAttributes.CRIT.get()) {
            return (class_1320)ModAttributes.RES_CRIT.get();
        }
        if (att == ModAttributes.STUN.get()) {
            return (class_1320)ModAttributes.RES_STUN.get();
        }
        if (att == ModAttributes.FAINT.get()) {
            return (class_1320)ModAttributes.RES_FAINT.get();
        }
        if (att == ModAttributes.DRAIN.get()) {
            return (class_1320)ModAttributes.RES_DRAIN.get();
        }
        return null;
    }

    public static EnumSkills matchingSkill(class_1320 att) {
        if (att == ModAttributes.PARA.get()) {
            return EnumSkills.RES_PARA;
        }
        if (att == ModAttributes.POISON.get()) {
            return EnumSkills.RES_POISON;
        }
        if (att == ModAttributes.SEAL.get()) {
            return EnumSkills.RES_SEAL;
        }
        if (att == ModAttributes.SLEEP.get()) {
            return EnumSkills.RES_SLEEP;
        }
        if (att == ModAttributes.FATIGUE.get()) {
            return EnumSkills.RES_FATIGUE;
        }
        if (att == ModAttributes.COLD.get()) {
            return EnumSkills.RES_COLD;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static double statusEffectValue(class_1309 entity, class_1320 att, class_1297 target) {
        value = CombatUtils.getAttributeValue((class_1297)entity, att) * 0.01;
        opposing = CombatUtils.opposing(att);
        if (!(target instanceof class_1309)) ** GOTO lbl-1000
        livingTarget = (class_1309)target;
        if (opposing != null) {
            v0 = CombatUtils.getAttributeValue((class_1297)livingTarget, opposing);
        } else lbl-1000:
        // 2 sources

        {
            v0 = res = 0.0;
        }
        if (target instanceof class_1657) {
            player = (class_1657)target;
            matchingSkill = CombatUtils.matchingSkill(att);
            if (matchingSkill != null) {
                res += Platform.INSTANCE.getPlayerData(player).map((Function<PlayerData, Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$statusEffectValue$1(io.github.flemmli97.runecraftory.api.enums.EnumSkills io.github.flemmli97.runecraftory.common.attachment.player.PlayerData ), (Lio/github/flemmli97/runecraftory/common/attachment/player/PlayerData;)Ljava/lang/Double;)((EnumSkills)matchingSkill)).orElse(0.0).doubleValue();
            }
        }
        return value * (1.0 - (res *= 0.01));
    }

    public static float reduceDamageFromStats(class_1309 entity, class_1282 source, float amount) {
        boolean ignoreDefence;
        if (ArmorEffect.hasArmorEffect(entity, (ArmorEffect)((Object)ModArmorEffects.SHIELD_RING.get())) && (double)entity.method_6051().nextFloat() < 0.1) {
            return 1.0f;
        }
        float reduce = 0.0f;
        switch (GeneralConfig.defenceSystem) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NO_DEFENCE: {
                boolean bl = true;
                break;
            }
            case VANILLA_IGNORE: {
                boolean bl;
                if (!(source instanceof CustomDamage)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_MOBS: {
                boolean bl;
                if (!(source instanceof CustomDamage) && source.method_5529() instanceof class_1308) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER_ATT: {
                boolean bl;
                if (!(source instanceof CustomDamage) && source.method_5529() instanceof class_1657) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER_HURT: {
                boolean bl;
                if (!(source instanceof CustomDamage) && entity instanceof class_1657) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER: {
                boolean bl = ignoreDefence = !(source instanceof CustomDamage) && (entity instanceof class_1657 || source.method_5529() instanceof class_1657);
            }
        }
        if (!ignoreDefence) {
            if (source.method_5527()) {
                if (!source.method_5504()) {
                    reduce = (float)CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.MAGIC_DEFENCE.get());
                }
            } else if (!source.method_5537()) {
                reduce = (float)CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.DEFENCE.get());
            }
        }
        float dmg = amount - reduce;
        if ((double)reduce > (double)amount * 0.8) {
            dmg = (float)Math.max(0.05 * (double)amount, (double)amount * 0.2 * Math.pow(0.997, (double)reduce - (double)amount * 0.8));
        }
        if (source instanceof CustomDamage) {
            CustomDamage custom = (CustomDamage)source;
            if (GeneralConfig.randomDamage && !custom.fixedDamage()) {
                dmg = (float)((double)dmg + entity.field_6002.field_9229.nextGaussian() * (double)dmg / 10.0);
            }
        }
        return CombatUtils.elementalReduction(entity, source, dmg);
    }

    public static float elementalReduction(class_1309 entity, class_1282 source, float amount) {
        if (source instanceof CustomDamage && ((CustomDamage)source).getElement() != EnumElement.NONE) {
            EnumElement element = ((CustomDamage)source).getElement();
            double percent = 0.0;
            switch (element) {
                case DARK: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.RES_DARK.get());
                    break;
                }
                case EARTH: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.RES_EARTH.get());
                    break;
                }
                case FIRE: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.RES_FIRE.get());
                    break;
                }
                case LIGHT: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.RES_LIGHT.get());
                    break;
                }
                case LOVE: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.RES_LOVE.get());
                    break;
                }
                case WATER: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.RES_WATER.get());
                    break;
                }
                case WIND: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.RES_WIND.get());
                    break;
                }
            }
            amount = percent < 0.0 ? (float)((double)amount * (1.0 + Math.abs(percent) / 100.0)) : (percent > 100.0 ? (float)((double)amount * -((percent - 100.0) / 100.0)) : (float)((double)amount * (1.0 - percent / 100.0)));
        }
        return amount;
    }

    public static void knockBackEntity(class_1309 attacker, class_1309 entity, float strength) {
        class_243 distVec = entity.method_19538().method_1020(attacker.method_19538()).method_1029();
        CombatUtils.knockbackEntityIgnoreResistance(entity, strength, -distVec.field_1352, -distVec.field_1350);
    }

    public static void knockbackEntityIgnoreResistance(class_1309 entity, double strength, double x, double z) {
        if (!entity.method_5864().method_20210(RunecraftoryTags.BOSSES)) {
            CombatUtils.applyTempAttribute(entity, class_5134.field_23718, -entity.method_26825(class_5134.field_23718));
        }
        entity.method_6005(strength, x, z);
        if (!entity.method_5864().method_20210(RunecraftoryTags.BOSSES)) {
            CombatUtils.removeTempAttribute(entity, class_5134.field_23718);
        }
    }

    public static void knockBack(class_1309 entity, CustomDamage source) {
        if (source.getKnockBackType() == CustomDamage.KnockBackType.NONE) {
            return;
        }
        class_1297 attacker = source.method_5529();
        float strength = source.knockAmount();
        if ((strength = (float)((double)strength * (1.0 - entity.method_26825(class_5134.field_23718)))) == 0.0f) {
            return;
        }
        double xRatio = 0.0;
        double zRatio = 0.0;
        double yRatio = strength;
        if (attacker != null) {
            switch (source.getKnockBackType()) {
                case BACK: {
                    class_243 distVec = entity.method_19538().method_1020(attacker.method_19538()).method_1029();
                    xRatio = distVec.field_1352;
                    zRatio = distVec.field_1350;
                    break;
                }
                case VANILLA: {
                    xRatio = class_3532.method_15374((float)(attacker.method_36454() * ((float)Math.PI / 180)));
                    zRatio = -class_3532.method_15362((float)(attacker.method_36454() * ((float)Math.PI / 180)));
                    break;
                }
            }
        }
        if (source.getKnockBackType() == CustomDamage.KnockBackType.VANILLA) {
            entity.method_6005((double)strength, xRatio, zRatio);
        } else {
            class_243 mot = entity.method_18798();
            double y = mot.field_1351;
            entity.field_6007 = true;
            if (xRatio != 0.0 || zRatio != 0.0) {
                float f = (float)Math.sqrt(xRatio * xRatio + zRatio * zRatio);
                mot = mot.method_1021(0.5).method_1031(xRatio / (double)f * (double)strength, 0.0, zRatio / (double)f * (double)strength);
            }
            if (source.getKnockBackType() != CustomDamage.KnockBackType.UP) {
                if (entity.method_24828()) {
                    y /= 2.0;
                    if ((y += (double)strength) > (double)0.4f) {
                        y = 0.4f;
                    }
                }
            } else if (yRatio != 0.0) {
                y = yRatio;
            }
            entity.method_18799(new class_243(mot.field_1352, y, mot.field_1350));
        }
    }

    public static boolean playerAttackWithItem(class_1657 player, class_1297 target, boolean resetCooldown, boolean levelSkill) {
        return CombatUtils.playerAttackWithItem(player, target, player.method_6047(), 1.0f, resetCooldown, levelSkill);
    }

    public static boolean playerAttackWithItem(class_1657 player, class_1297 target, class_1799 stack, float damageModifier, boolean resetCooldown, boolean levelSkill) {
        double damagePhys;
        if (target.method_5732() && !target.method_5698((class_1297)player) && player.method_7357().method_7905(stack.method_7909(), 0.0f) <= 0.0f && (damagePhys = CombatUtils.getAttributeValue((class_1297)player, class_5134.field_23721) * (double)damageModifier) > 0.0) {
            IItemUsable usable;
            class_1792 class_17922;
            boolean playSound = false;
            if (resetCooldown && (class_17922 = stack.method_7909()) instanceof IItemUsable && (usable = (IItemUsable)class_17922).hasCooldown()) {
                player.method_7357().method_7906(stack.method_7909(), class_3532.method_15384((double)(20.0 * ItemNBT.attackSpeedModifier((class_1309)player))));
                playSound = true;
            }
            boolean faintChance = player.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue((class_1309)player, (class_1320)ModAttributes.FAINT.get(), target);
            boolean critChance = player.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue((class_1309)player, (class_1320)ModAttributes.CRIT.get(), target);
            CustomDamage.DamageType damageType = CustomDamage.DamageType.NORMAL;
            if (faintChance) {
                damageType = CustomDamage.DamageType.FAINT;
            } else if (critChance) {
                damageType = CustomDamage.DamageType.IGNOREDEF;
            }
            double knockbackAtt = CombatUtils.statusEffectValue((class_1309)player, (class_1320)ModAttributes.KNOCK.get(), target);
            int i = player.method_5624() ? 1 : 0;
            float knockback = (float)((double)((float)(i += class_1890.method_8205((class_1309)player)) * 0.5f) + knockbackAtt * 3.0);
            if (ItemNBT.doesFixedOneDamage(stack)) {
                damageType = CustomDamage.DamageType.FIXED;
                damagePhys = 1.0;
            }
            CustomDamage.Builder source = new CustomDamage.Builder((class_1297)player).element(ItemNBT.getElement(stack)).damageType(damageType).knock(CustomDamage.KnockBackType.VANILLA).knockAmount(knockback).hurtResistant(0);
            class_243 targetMot = target.method_18798();
            if (CombatUtils.damageWithFaintAndCrit((class_1297)player, target, source, damagePhys, stack)) {
                class_3222 serverPlayer;
                if (levelSkill && player instanceof class_3222) {
                    serverPlayer = (class_3222)player;
                    CombatUtils.hitEntityWithItemPlayer(serverPlayer, stack);
                }
                if (i > 0) {
                    player.method_18799(player.method_18798().method_18805(0.6, 1.0, 0.6));
                    player.method_5728(false);
                }
                if (target instanceof class_3222) {
                    serverPlayer = (class_3222)target;
                    if (target.field_6037) {
                        serverPlayer.field_13987.method_14364((class_2596)new class_2743(target));
                        target.field_6037 = false;
                        target.method_18799(targetMot);
                    }
                }
                if (critChance) {
                    if (playSound) {
                        player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15016, player.method_5634(), 1.0f, 1.0f);
                    }
                    player.method_7277(target);
                    player.method_7304(target);
                } else {
                    IAOEWeapon aoe;
                    class_1792 class_17923 = stack.method_7909();
                    if (class_17923 instanceof IAOEWeapon && (aoe = (IAOEWeapon)class_17923).getWidth((class_1309)player, stack) == 0.0f && playSound) {
                        player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14840, player.method_5634(), 1.0f, 1.0f);
                    } else if (playSound) {
                        player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14706, player.method_5634(), 1.0f, 1.0f);
                    }
                }
            } else if (playSound) {
                player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14914, player.method_5634(), 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public static boolean mobAttack(class_1309 attacker, class_1297 target) {
        class_1799 stack = attacker.method_6047();
        CustomDamage.Builder source = new CustomDamage.Builder((class_1297)attacker).hurtResistant(5).element(ItemNBT.getElement(stack));
        return CombatUtils.mobAttack(attacker, target, source);
    }

    public static boolean mobAttack(class_1309 attacker, class_1297 target, CustomDamage.Builder source) {
        class_1799 stack = attacker.method_6047();
        double damagePhys = CombatUtils.getAttributeValue((class_1297)attacker, class_5134.field_23721);
        class_1937 class_19372 = attacker.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ((Spell)((Object)ModSpells.STAFF_CAST.get())).use(serverLevel, attacker, stack);
        }
        if (ItemNBT.doesFixedOneDamage(stack)) {
            source.damageType(CustomDamage.DamageType.FIXED);
            damagePhys = 1.0;
        }
        return CombatUtils.mobAttack(attacker, target, source, damagePhys);
    }

    public static boolean mobAttack(class_1309 attacker, class_1297 target, CustomDamage.Builder source, double dmg) {
        if (target.field_6002.method_8407() == class_1267.field_5801 && target instanceof class_1657) {
            return false;
        }
        if (dmg > 0.0) {
            ElementalAttackMob mob;
            EnumElement element;
            if (attacker instanceof ElementalAttackMob && (element = (mob = (ElementalAttackMob)attacker).getAttackElement()) != null) {
                source.element(element);
            }
            return CombatUtils.damageWithFaintAndCrit((class_1297)attacker, target, source, dmg, null);
        }
        return false;
    }

    public static boolean damageWithFaintAndCrit(@Nullable class_1297 attacker, class_1297 target, CustomDamage.Builder builder, double damage, @Nullable class_1799 stack) {
        return CombatUtils.damage(attacker, target, builder, damage, stack, true, true);
    }

    public static boolean damage(@Nullable class_1297 attacker, class_1297 target, CustomDamage.Builder builder, double damage, @Nullable class_1799 stack, boolean allowCrit, boolean allowFaint) {
        if (attacker instanceof class_1309) {
            class_1309 livingAttacker = (class_1309)attacker;
            builder.getAttributesChanges().forEach((att, val) -> CombatUtils.applyTempAttribute(livingAttacker, att, val));
            if (allowFaint && livingAttacker.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(livingAttacker, (class_1320)ModAttributes.FAINT.get(), target)) {
                builder.damageType(CustomDamage.DamageType.FAINT);
            } else if (allowCrit && livingAttacker.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(livingAttacker, (class_1320)ModAttributes.CRIT.get(), target)) {
                switch (builder.getDamageType()) {
                    case MAGIC: {
                        builder.damageType(CustomDamage.DamageType.IGNOREMAGICDEF);
                        break;
                    }
                    case NORMAL: {
                        builder.damageType(CustomDamage.DamageType.IGNOREDEF);
                    }
                }
            }
            if (builder.calculateKnockback()) {
                double knockbackAtt = CombatUtils.statusEffectValue(livingAttacker, (class_1320)ModAttributes.KNOCK.get(), target);
                int i = livingAttacker.method_5624() ? 1 : 0;
                float knockback = (float)((double)((float)(i += class_1890.method_8205((class_1309)livingAttacker)) * 0.5f) + knockbackAtt * 3.0);
                builder.knockAmount(knockback);
            }
        }
        CustomDamage source = builder.get();
        float dmg = (float)damage;
        if (source.criticalDamage()) {
            dmg = Float.MAX_VALUE;
        } else if (!source.fixedDamage()) {
            dmg = CombatUtils.modifyDmgElement(source.getElement(), target, dmg);
        }
        boolean success = source.hurtEntity(target, dmg);
        if (success) {
            CombatUtils.spawnElementalParticle(target, source.getElement());
            if (attacker instanceof class_1309) {
                class_1309 livingAttacker = (class_1309)attacker;
                livingAttacker.method_6114(target);
            }
            if (target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                CombatUtils.knockBack(livingTarget, source);
                if (attacker instanceof class_1309) {
                    class_1309 livingAttacker = (class_1309)attacker;
                    CombatUtils.applyStatusEffects(livingAttacker, livingTarget);
                    class_1890.method_8210((class_1309)livingTarget, (class_1297)livingAttacker);
                    if (stack != null && livingAttacker instanceof class_1657) {
                        class_1657 player = (class_1657)livingAttacker;
                        class_1799 beforeHitCopy = stack.method_7972();
                        stack.method_7979(livingTarget, player);
                        if (stack.method_7960()) {
                            Platform.INSTANCE.destroyItem(player, beforeHitCopy, class_1268.field_5808);
                            livingAttacker.method_6122(class_1268.field_5808, class_1799.field_8037);
                        }
                    }
                }
            }
            CombatUtils.elementalEffects(attacker, source.getElement(), target);
        }
        if (attacker instanceof class_1309) {
            class_1309 livingAttacker = (class_1309)attacker;
            source.getAttributesChange().forEach((att, val) -> CombatUtils.removeTempAttribute(livingAttacker, att));
        }
        return success;
    }

    public static float modifyDmgElement(EnumElement element, class_1297 target, float dmg) {
        class_1309 living;
        if (!(target instanceof IBaseMob) && !(target instanceof class_1657) && element == EnumElement.WATER && target instanceof class_1309 && ((living = (class_1309)target).method_5753() || living.method_29503())) {
            dmg = (float)((double)dmg * 1.1);
        }
        return dmg;
    }

    public static void elementalEffects(class_1297 attacker, EnumElement element, class_1297 target) {
        if (!(target instanceof IBaseMob) && !(target instanceof class_1657)) {
            switch (element) {
                case FIRE: {
                    target.method_5639(3);
                    break;
                }
                case DARK: {
                    if (!(target instanceof class_1309)) break;
                    class_1309 living = (class_1309)target;
                    living.method_6092(new class_1293(class_1294.field_5920, 200));
                    break;
                }
                case WIND: {
                    if (!(target instanceof class_1309)) break;
                    class_1309 living = (class_1309)target;
                    if (attacker == null) break;
                    living.method_6005(1.5, (double)class_3532.method_15374((float)(attacker.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(attacker.method_36454() * ((float)Math.PI / 180)))));
                    break;
                }
                case WATER: {
                    if (!(target instanceof class_1309)) break;
                    class_1309 living = (class_1309)target;
                    living.method_6092(new class_1293(class_1294.field_5909, 200));
                }
            }
        }
    }

    public static void applyStatusEffects(class_1309 attackingEntity, class_1309 target) {
        class_3222 player;
        boolean poisonChance = attackingEntity.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (class_1320)ModAttributes.POISON.get(), (class_1297)target);
        boolean sleepChance = attackingEntity.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (class_1320)ModAttributes.SLEEP.get(), (class_1297)target);
        boolean fatigueChance = attackingEntity.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (class_1320)ModAttributes.FATIGUE.get(), (class_1297)target);
        boolean coldChance = attackingEntity.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (class_1320)ModAttributes.COLD.get(), (class_1297)target);
        boolean paraChance = attackingEntity.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (class_1320)ModAttributes.PARA.get(), (class_1297)target);
        boolean sealChance = attackingEntity.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (class_1320)ModAttributes.SEAL.get(), (class_1297)target);
        boolean dizzyChance = attackingEntity.field_6002.field_9229.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (class_1320)ModAttributes.DIZZY.get(), (class_1297)target);
        double stunAmount = CombatUtils.statusEffectValue(attackingEntity, (class_1320)ModAttributes.STUN.get(), (class_1297)target);
        if (poisonChance) {
            EntityUtils.applyPermanentEffect(target, (class_1291)ModEffects.POISON.get(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_POISON, 5.0f));
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_POISON, 15.0f));
            }
        }
        if (fatigueChance) {
            EntityUtils.applyPermanentEffect(target, (class_1291)ModEffects.FATIGUE.get(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_FATIGUE, 5.0f));
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_FATIGUE, 15.0f));
            }
        }
        if (coldChance) {
            EntityUtils.applyPermanentEffect(target, (class_1291)ModEffects.COLD.get(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_COLD, 5.0f));
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_COLD, 15.0f));
            }
        }
        if (paraChance) {
            EntityUtils.applyPermanentEffect(target, (class_1291)ModEffects.PARALYSIS.get(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_PARA, 5.0f));
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_PARA, 15.0f));
            }
        }
        if (sealChance) {
            EntityUtils.applyPermanentEffect(target, (class_1291)ModEffects.SEAL.get(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_SEAL, 5.0f));
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_SEAL, 15.0f));
            }
        }
        if (dizzyChance) {
            target.method_6092(new class_1293(class_1294.field_5916, 80, 1, true, false));
        }
        if (stunAmount > 0.1 && attackingEntity.field_6002.field_9229.nextDouble() < stunAmount) {
            target.method_6092(new class_1293((class_1291)ModEffects.STUNNED.get(), class_3532.method_15357((double)(Math.min(1.0, stunAmount) * 50.0)), 0, true, false));
        }
        if (sleepChance) {
            target.method_6092(new class_1293((class_1291)ModEffects.SLEEP.get(), 80, 0, true, false));
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_SLEEP, 5.0f));
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_SLEEP, 15.0f));
            }
        }
    }

    public static void spawnElementalParticle(class_1297 target, EnumElement element) {
        class_1937 class_19372 = target.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            int color = 0xFFFFFF;
            switch (element) {
                case DARK: {
                    color = 1774399;
                    break;
                }
                case EARTH: {
                    color = 9201679;
                    break;
                }
                case FIRE: {
                    color = 12846855;
                    break;
                }
                case LIGHT: {
                    color = 0xFFFF47;
                    break;
                }
                case LOVE: {
                    color = 16221146;
                    break;
                }
                case WATER: {
                    color = 2781149;
                    break;
                }
                case WIND: {
                    color = 2204954;
                    break;
                }
            }
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            Random rand = new Random();
            for (int i = 0; i < 7; ++i) {
                serverLevel.method_14199((class_2394)class_2398.field_11226, target.method_23317() + (rand.nextDouble() - 0.5) * (double)target.method_17681(), target.method_23318() + 0.3 + rand.nextDouble() * (double)target.method_17682(), target.method_23321() + (rand.nextDouble() - 0.5) * (double)target.method_17681(), 0, r, g, b, 1.0);
            }
        }
    }

    public static void applyTempAttribute(class_1309 entity, class_1320 att, double val) {
        class_1324 inst = entity.method_5996(att);
        if (inst != null && inst.method_6199(TEMP_ATTRIBUTE_MOD) == null) {
            inst.method_26835(new class_1322(TEMP_ATTRIBUTE_MOD, "temp_mod", val, class_1322.class_1323.field_6328));
        }
    }

    public static void applyTempAttributeMult(class_1309 entity, class_1320 att, double val) {
        class_1324 inst = entity.method_5996(att);
        if (inst != null && inst.method_6199(TEMP_ATTRIBUTE_MOD_MULT) == null) {
            inst.method_26835(new class_1322(TEMP_ATTRIBUTE_MOD_MULT, "temp_mod_mult", val - 1.0, class_1322.class_1323.field_6331));
        }
    }

    public static void removeTempAttribute(class_1309 entity, class_1320 att) {
        class_1324 inst = entity.method_5996(att);
        if (inst != null) {
            inst.method_6200(TEMP_ATTRIBUTE_MOD);
            inst.method_6200(TEMP_ATTRIBUTE_MOD_MULT);
        }
    }

    public static void hitEntityWithItemPlayer(class_3222 player, class_1799 stack) {
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player).orElse(null);
        if (data == null) {
            return;
        }
        if (stack.method_7909() instanceof ItemStaffBase) {
            switch (ItemNBT.getElement(stack)) {
                case WATER: {
                    LevelCalc.levelSkill(player, data, EnumSkills.WATER, 3.0f);
                    break;
                }
                case EARTH: {
                    LevelCalc.levelSkill(player, data, EnumSkills.EARTH, 3.0f);
                    break;
                }
                case WIND: {
                    LevelCalc.levelSkill(player, data, EnumSkills.WIND, 3.0f);
                    break;
                }
                case FIRE: {
                    LevelCalc.levelSkill(player, data, EnumSkills.FIRE, 3.0f);
                    break;
                }
                case LIGHT: {
                    LevelCalc.levelSkill(player, data, EnumSkills.LIGHT, 3.0f);
                    break;
                }
                case DARK: {
                    LevelCalc.levelSkill(player, data, EnumSkills.DARK, 3.0f);
                    break;
                }
                case LOVE: {
                    LevelCalc.levelSkill(player, data, EnumSkills.LOVE, 3.0f);
                }
            }
            return;
        }
        if (stack.method_31573(RunecraftoryTags.SHORTSWORDS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.SHORTSWORD, 2.0f);
        }
        if (stack.method_31573(RunecraftoryTags.LONGSWORDS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.LONGSWORD, 4.0f);
        }
        if (stack.method_31573(RunecraftoryTags.SPEARS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.SPEAR, 3.0f);
        }
        if (stack.method_31573(RunecraftoryTags.AXES) || stack.method_31573(RunecraftoryTags.HAMMERS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.HAMMERAXE, 5.0f);
        }
        if (stack.method_31573(RunecraftoryTags.DUALBLADES)) {
            LevelCalc.levelSkill(player, data, EnumSkills.DUAL, 2.0f);
        }
        if (stack.method_31573(RunecraftoryTags.FISTS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.FIST, 2.0f);
        }
        if (stack.method_31573(RunecraftoryTags.AXE_TOOLS) || stack.method_31573(RunecraftoryTags.HAMMER_TOOLS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.HAMMERAXE, 1.0f);
        }
        if (stack.method_31573(RunecraftoryTags.HOES) || stack.method_31573(RunecraftoryTags.WATERINGCANS) || stack.method_31573(RunecraftoryTags.SICKLES)) {
            LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 1.0f);
        }
    }

    public static double getRange(class_1309 entity, double bonus) {
        return EntityUtils.tryGetAttribute(entity, (class_1320)ModAttributes.ATTACK_RANGE.get()) + bonus;
    }

    public static double getWidth(class_1309 entity, double bonus) {
        return EntityUtils.tryGetAttribute(entity, (class_1320)ModAttributes.ATTACK_WIDTH.get()) + bonus;
    }

    public static int getSpellLevelFromStack(class_1799 stack) {
        if (stack.method_7909() instanceof ItemSpell) {
            return ItemNBT.itemLevel(stack);
        }
        return 1;
    }

    public static double getAbilityDamageBonus(class_1799 stack) {
        return CombatUtils.getAbilityDamageBonus(CombatUtils.getSpellLevelFromStack(stack), 1.0f);
    }

    public static double getAbilityDamageBonus(class_1799 stack, float origin) {
        return CombatUtils.getAbilityDamageBonus(CombatUtils.getSpellLevelFromStack(stack), origin);
    }

    public static float getAbilityDamageBonus(int level, float origin) {
        return origin * (1.0f + (float)(level - 1) * 0.025f);
    }

    public static class_243 fromRelativeVector(class_1297 entity, class_243 relative) {
        return CombatUtils.fromRelativeVector(entity.method_36454(), relative);
    }

    public static class_243 fromRelativeVector(float yRot, class_243 relative) {
        class_243 vec3 = relative.method_1029();
        float f = class_3532.method_15374((float)(yRot * ((float)Math.PI / 180)));
        float g = class_3532.method_15362((float)(yRot * ((float)Math.PI / 180)));
        return new class_243(vec3.field_1352 * (double)g - vec3.field_1350 * (double)f, vec3.field_1351, vec3.field_1350 * (double)g + vec3.field_1352 * (double)f);
    }

    public static boolean canPerform(class_1309 entity, EnumSkills skill, int requiredLvl) {
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)entity;
        return player.method_7337() || Platform.INSTANCE.getPlayerData(player).map(d -> d.getSkillLevel(skill).getLevel() >= requiredLvl).orElse(false) != false;
    }

    private static /* synthetic */ Double lambda$statusEffectValue$1(EnumSkills matchingSkill, PlayerData d) {
        return (double)d.getSkillLevel(matchingSkill).getLevel() * 0.005;
    }

    public static interface FloatMap {
        public float get(float var1);
    }

    public static class EntityAttack {
        private final class_1309 attacker;
        private Predicate<class_1309> targetPred;
        private final Map<class_1320, Double> bonusAttributes = new HashMap<class_1320, Double>();
        private final Map<class_1320, Double> bonusAttributesMultiplier = new HashMap<class_1320, Double>();
        private Consumer<class_1309> onSuccess;
        private class_3414 soundToPlay;
        private final BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> targets;

        protected EntityAttack(class_1309 attacker, BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> targets) {
            this.attacker = attacker;
            this.targets = targets;
        }

        public static EntityAttack create(class_1309 attacker, BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> targets) {
            return new EntityAttack(attacker, targets);
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> circleTargets(float startRot, float endRot, float rangeBonus) {
            return EntityAttack.circleTargets(startRot, endRot, null, rangeBonus);
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> circleTargets(float startRot, float endRot, FloatMap xRot, float rangeBonus) {
            return (attacker, predicate) -> {
                double reach = CombatUtils.getRange(attacker, rangeBonus);
                double incHalf = Math.asin(0.5 / reach) * 57.2957763671875;
                float minYRot = Math.min(startRot, endRot);
                float maxYRot = Math.max(startRot, endRot);
                class_238 aabb = new class_238(-0.5, -0.02, 0.0, 0.5, (double)attacker.method_17682() + 0.02, reach);
                int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
                float inc = (maxYRot - minYRot) / (float)rotationSteps;
                HashSet entities = new HashSet();
                for (int steps = 0; steps <= rotationSteps; ++steps) {
                    float yRot = minYRot + inc * (float)steps;
                    OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, xRot == null ? 0.0f : xRot.get((float)steps / (float)rotationSteps), attacker.method_19538());
                    entities.addAll(RayTraceUtils.getEntitiesIn((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)false, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate));
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                }
                return entities;
            };
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> circleTargetsFixedRange(float startRot, float endRot, float reach) {
            return (attacker, predicate) -> {
                double incHalf = Math.asin(0.5 / (double)reach) * 57.2957763671875;
                float minYRot = Math.min(startRot, endRot);
                float maxYRot = Math.max(startRot, endRot);
                class_238 aabb = new class_238(-0.5, -0.02, 0.0, 0.5, (double)attacker.method_17682() + 0.02, (double)reach);
                int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
                float inc = (maxYRot - minYRot) / (float)rotationSteps;
                HashSet entities = new HashSet();
                for (int steps = 0; steps <= rotationSteps; ++steps) {
                    float yRot = minYRot + inc * (float)steps;
                    OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, 0.0f, attacker.method_19538());
                    entities.addAll(RayTraceUtils.getEntitiesIn((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)false, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate));
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                }
                return entities;
            };
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> aabbTargets(class_238 aabb) {
            return EntityAttack.aabbTargets(aabb, true);
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> aabbTargets(class_238 aabb, boolean relative) {
            return (attacker, predicate) -> {
                OrientedBoundingBox obb = new OrientedBoundingBox(relative ? aabb.method_997(attacker.method_19538().method_1021(-1.0)) : aabb, attacker.method_36454(), 0.0f, attacker.method_19538());
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                return RayTraceUtils.getEntitiesIn((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)true, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate);
            };
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> obbTargets(float yRot, float xRot, double width, double range, boolean fixed) {
            return (attacker, predicate) -> {
                double reach = fixed ? range : CombatUtils.getRange(attacker, range);
                class_238 aabb = new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)attacker.method_17682(), reach);
                OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, -xRot, attacker.method_19538());
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                return RayTraceUtils.getEntitiesIn((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)false, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate);
            };
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> obbTargets(OrientedBoundingBox obb) {
            return (attacker, predicate) -> {
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                return RayTraceUtils.getEntitiesIn((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)false, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate);
            };
        }

        public EntityAttack withTargetPredicate(Predicate<class_1309> targetPred) {
            this.targetPred = targetPred;
            return this;
        }

        public EntityAttack withBonusAttributes(class_1320 att, double val) {
            this.bonusAttributes.put(att, val);
            return this;
        }

        public EntityAttack withBonusAttributesMultiplier(class_1320 att, double val) {
            this.bonusAttributesMultiplier.put(att, val);
            return this;
        }

        public EntityAttack doOnSuccess(Consumer<class_1309> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public EntityAttack withAttackSound(class_3414 sound) {
            this.soundToPlay = sound;
            return this;
        }

        public Collection<class_1309> executeAttack() {
            class_1309 class_13092;
            if (this.attacker.field_6002.field_9236) {
                return List.of();
            }
            class_1309 class_13093 = this.attacker;
            if (class_13093 instanceof TargetableOpponent) {
                TargetableOpponent pred = (TargetableOpponent)class_13093;
                this.targetPred = this.targetPred == null ? pred.validTargetPredicate() : pred.validTargetPredicate().and(this.targetPred);
            }
            Collection<class_1309> list = this.targets.apply(this.attacker, this.targetPred);
            this.bonusAttributes.forEach((att, val) -> CombatUtils.applyTempAttribute(this.attacker, att, val));
            this.bonusAttributesMultiplier.forEach((att, val) -> CombatUtils.applyTempAttributeMult(this.attacker, att, val));
            class_1309 class_13094 = this.attacker;
            if (class_13094 instanceof class_1308) {
                class_1308 mob = (class_1308)class_13094;
                class_13092 = mob.method_5968();
            } else {
                class_13092 = null;
            }
            class_1309 target = class_13092;
            for (class_1309 livingEntity : list) {
                boolean flag = false;
                if (target != livingEntity && this.attacker.method_5854() == livingEntity) continue;
                class_1309 class_13095 = this.attacker;
                if (class_13095 instanceof class_1657) {
                    class_1657 player = (class_1657)class_13095;
                    flag = CombatUtils.playerAttackWithItem(player, (class_1297)livingEntity, false, false);
                } else {
                    class_13095 = this.attacker;
                    if (class_13095 instanceof class_1308) {
                        class_1308 mob = (class_1308)class_13095;
                        flag = mob.method_6121((class_1297)livingEntity);
                    }
                }
                if (!flag) continue;
                if (this.onSuccess != null) {
                    this.onSuccess.accept(livingEntity);
                }
                if (this.soundToPlay == null) continue;
                this.attacker.field_6002.method_8465(null, this.attacker.method_23317(), this.attacker.method_23318(), this.attacker.method_23321(), this.soundToPlay, this.attacker.method_5634(), 1.0f, 1.0f);
            }
            this.bonusAttributes.forEach((att, val) -> CombatUtils.removeTempAttribute(this.attacker, att));
            this.bonusAttributesMultiplier.forEach((att, val) -> CombatUtils.removeTempAttribute(this.attacker, att));
            return list;
        }
    }
}

