/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class CustomDamage
extends class_1285 {
    public static final class_1282 EXHAUST = Platform.INSTANCE.createDamageSource("runecraftory.exhaust", true, true, true);
    public static final class_1282 POISON = Platform.INSTANCE.createDamageSource("runecraftory.poison", true, true, false);
    public static final String ENTITY_DAMAGE_SOURCE = "runecraftory.attack";
    private final EnumElement element;
    private final KnockBackType knock;
    private final class_1297 trueSourceEntity;
    private final float knockAmount;
    private final int hurtProtection;
    private final boolean faintEntity;
    private final boolean fixedDamage;
    private final ImmutableMap<class_1320, Double> attributesChange;

    public CustomDamage(class_1297 attacker, @Nullable class_1297 cause, EnumElement element, KnockBackType knock, float knockBackAmount, int hurtTimeProtection, boolean faintEntity, boolean fixedDamage, Map<class_1320, Double> attributesChange) {
        super(ENTITY_DAMAGE_SOURCE, attacker);
        this.element = element;
        this.knock = knock;
        this.trueSourceEntity = cause;
        this.knockAmount = knockBackAmount;
        this.hurtProtection = hurtTimeProtection;
        this.faintEntity = faintEntity;
        this.fixedDamage = fixedDamage;
        this.attributesChange = ImmutableMap.copyOf(attributesChange);
    }

    public EnumElement getElement() {
        return this.element;
    }

    public KnockBackType getKnockBackType() {
        return this.knock;
    }

    public float knockAmount() {
        return this.knockAmount;
    }

    public int hurtProtection() {
        return this.hurtProtection;
    }

    public boolean criticalDamage() {
        return this.faintEntity;
    }

    public boolean fixedDamage() {
        return this.fixedDamage;
    }

    public ImmutableMap<class_1320, Double> getAttributesChange() {
        return this.attributesChange;
    }

    @Nullable
    public class_1297 method_5529() {
        return this.trueSourceEntity != null ? this.trueSourceEntity : this.method_5526();
    }

    public class_2561 method_5506(class_1309 entityLivingBaseIn) {
        class_1297 source = this.method_5529() != null ? this.method_5529() : this.method_5526();
        class_1799 itemstack = source instanceof class_1309 ? ((class_1309)source).method_6047() : class_1799.field_8037;
        String s = "death.attack." + this.field_5841;
        String s1 = s + ".item";
        return !itemstack.method_7960() && itemstack.method_7938() && class_1074.method_4663((String)s1) ? new class_2588(s1, new Object[]{entityLivingBaseIn.method_5476(), source.method_5476(), itemstack.method_7954()}) : new class_2588(s, new Object[]{entityLivingBaseIn.method_5476(), source.method_5476()});
    }

    public class_1297 method_5526() {
        return this.field_5879;
    }

    public boolean hurtEntity(class_1297 target, float dmg) {
        boolean success;
        int invul = target.field_6008;
        boolean modified = false;
        if (target.field_6008 + this.hurtProtection() <= 20) {
            target.field_6008 = Math.min(target.field_6008, 10);
            modified = true;
        }
        if (!(success = target.method_5643((class_1282)this, dmg)) && modified) {
            target.field_6008 = invul;
        }
        return success;
    }

    public static enum KnockBackType {
        BACK,
        UP,
        VANILLA,
        NONE;

    }

    public static class Builder {
        private final class_1297 cause;
        private EnumElement element = EnumElement.NONE;
        private KnockBackType knock = KnockBackType.VANILLA;
        private class_1297 trueSource;
        private float knockAmount;
        private int protection = 10;
        private DamageType dmg = DamageType.NORMAL;
        private final Map<class_1320, Double> attributesChange = new HashMap<class_1320, Double>();
        private boolean isProjectile;

        public Builder(class_1297 attacker) {
            this.cause = attacker;
        }

        public Builder(class_1297 attacker, class_1297 source) {
            this.cause = attacker;
            this.trueSource = source;
        }

        public Builder element(EnumElement el) {
            this.element = el;
            return this;
        }

        public Builder knock(KnockBackType k) {
            this.knock = k;
            return this;
        }

        public Builder knockAmount(float amount) {
            this.knockAmount = amount;
            return this;
        }

        public Builder noKnockback() {
            this.knock = KnockBackType.NONE;
            return this;
        }

        public boolean calculateKnockback() {
            return this.knock == KnockBackType.VANILLA && this.knockAmount == 0.0f;
        }

        public Builder hurtResistant(int time) {
            this.protection = time;
            return this;
        }

        public Builder magic() {
            this.dmg = DamageType.MAGIC;
            return this;
        }

        public Builder damageType(DamageType type) {
            if (this.dmg != DamageType.FAINT) {
                this.dmg = type;
            }
            return this;
        }

        public DamageType getDamageType() {
            return this.dmg;
        }

        public Builder withChangedAttribute(class_1320 att, double change) {
            this.attributesChange.put(att, change);
            return this;
        }

        public Builder projectile() {
            this.isProjectile = true;
            return this;
        }

        public Map<class_1320, Double> getAttributesChanges() {
            return this.attributesChange;
        }

        public CustomDamage get() {
            CustomDamage source = new CustomDamage(this.cause, this.trueSource, this.element, this.knock, this.knockAmount, this.protection, this.dmg == DamageType.FAINT, this.dmg == DamageType.FIXED, this.attributesChange);
            switch (this.dmg) {
                case NORMAL: {
                    break;
                }
                case MAGIC: {
                    source.method_5515();
                    break;
                }
                case FAINT: 
                case FIXED: 
                case IGNOREDEF: {
                    source.method_5508();
                    break;
                }
                case IGNOREMAGICDEF: {
                    source.method_5515();
                    source.method_5509();
                }
            }
            if (this.isProjectile) {
                source.method_5517();
            }
            return source;
        }
    }

    public static enum DamageType {
        NORMAL,
        MAGIC,
        IGNOREDEF,
        IGNOREMAGICDEF,
        FAINT,
        FIXED;

    }
}

