/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class ItemNBT {
    private static final List<class_2960> WEAPON_ONLY = List.of(ModAttributes.PARA.getID(), ModAttributes.POISON.getID(), ModAttributes.SEAL.getID(), ModAttributes.SLEEP.getID(), ModAttributes.FATIGUE.getID(), ModAttributes.COLD.getID(), ModAttributes.FAINT.getID(), ModAttributes.DRAIN.getID());
    private static final List<class_2960> ARMOR_ONLY = List.of(ModAttributes.RES_WATER.getID(), ModAttributes.RES_EARTH.getID(), ModAttributes.RES_WIND.getID(), ModAttributes.RES_FIRE.getID(), ModAttributes.RES_DARK.getID(), ModAttributes.RES_LIGHT.getID(), ModAttributes.RES_LOVE.getID(), ModAttributes.RES_PARA.getID(), ModAttributes.RES_POISON.getID(), ModAttributes.RES_SEAL.getID(), ModAttributes.RES_SLEEP.getID(), ModAttributes.RES_FAT.getID(), ModAttributes.RES_COLD.getID(), ModAttributes.RES_DIZZY.getID(), ModAttributes.RES_CRIT.getID(), ModAttributes.RES_STUN.getID(), ModAttributes.RES_FAINT.getID(), ModAttributes.RES_DRAIN.getID());
    private static final List<class_2960> NON_INHERITABLE = List.of(ModAttributes.ATTACK_SPEED.getID(), ModAttributes.ATTACK_RANGE.getID(), ModAttributes.ATTACK_WIDTH.getID(), ModAttributes.CHARGE_TIME.getID());

    public static int itemLevel(class_1799 stack) {
        class_2487 tag = ItemNBT.getItemNBT(stack);
        return tag != null ? Math.max(1, tag.method_10550("ItemLevel")) : 1;
    }

    public static boolean addItemLevel(class_1799 stack) {
        class_2487 tag;
        int level = ItemNBT.itemLevel(stack);
        if (level < 10 && (tag = ItemNBT.getItemNBT(stack)) != null) {
            tag.method_10569("ItemLevel", level + 1);
            return true;
        }
        return false;
    }

    public static class_1799 getLeveledItem(class_1799 stack, int level) {
        if (ItemNBT.shouldHaveLevel(stack)) {
            class_2487 compound = ItemNBT.getItemNBT(stack);
            if (compound == null) {
                compound = new class_2487();
            }
            compound.method_10569("ItemLevel", class_3532.method_15340((int)level, (int)1, (int)10));
            stack.method_7948().method_10566("runecraftory", (class_2520)compound);
        }
        return stack;
    }

    public static Map<class_1320, Double> statIncrease(class_1799 stack) {
        class_2487 compound = ItemNBT.getItemNBT(stack);
        if (compound == null || !compound.method_10545("BaseStats")) {
            return DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(ItemStat::itemStats).orElse(new TreeMap(ModAttributes.SORTED));
        }
        TreeMap<class_1320, Double> map = new TreeMap<class_1320, Double>(ModAttributes.SORTED);
        class_2487 base = compound.method_10562("BaseStats");
        for (String attName : base.method_10541()) {
            class_1320 att = (class_1320)class_2378.field_23781.method_10223(new class_2960(attName));
            if (!class_2378.field_23781.method_10221((Object)att).toString().equals(attName)) continue;
            map.put(att, base.method_10574(attName));
        }
        class_2487 tag = compound.method_10562("ItemStats");
        for (String attName : tag.method_10541()) {
            class_1320 att = (class_1320)class_2378.field_23781.method_10223(new class_2960(attName));
            if (!class_2378.field_23781.method_10221((Object)att).toString().equals(attName)) continue;
            map.compute(att, (key, old) -> old == null ? tag.method_10574(attName) : old + tag.method_10574(attName));
        }
        return map;
    }

    public static Multimap<class_1320, class_1322> getStatsAttributeMap(class_1799 stack, Multimap<class_1320, class_1322> map, class_1304 slot) {
        if (ItemNBT.shouldHaveStats(stack) && ItemUtils.slotOf(stack) == slot) {
            SetMultimap multimap = MultimapBuilder.treeKeys(ModAttributes.SORTED).hashSetValues().build();
            ItemNBT.statIncrease(stack).forEach((arg_0, arg_1) -> ItemNBT.lambda$getStatsAttributeMap$1((Multimap)multimap, slot, arg_0, arg_1));
            return multimap;
        }
        return map;
    }

    public static Pair<Map<class_1320, Double>, Map<class_1320, Double>> foodStats(class_1799 stack) {
        Map<class_1320, Double> mapMulti;
        class_1320 att;
        Map<class_1320, Double> map;
        class_2487 tag;
        FoodProperties props = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909());
        if (props == null) {
            return Pair.of(new TreeMap(ModAttributes.SORTED), new TreeMap(ModAttributes.SORTED));
        }
        class_2487 compound = ItemNBT.getItemNBT(stack);
        if (compound == null) {
            return Pair.of(props.effects(), props.effectsMultiplier());
        }
        if (compound.method_10545("FoodStats")) {
            tag = compound.method_10562("FoodStats");
            map = new TreeMap<class_1320, Double>(ModAttributes.SORTED);
            for (String attName : tag.method_10541()) {
                att = (class_1320)class_2378.field_23781.method_10223(new class_2960(attName));
                if (!class_2378.field_23781.method_10221((Object)att).toString().equals(attName)) continue;
                map.put(att, tag.method_10574(attName));
            }
        } else {
            map = props.effects();
        }
        if (compound.method_10545("FoodStatsMultiplier")) {
            tag = compound.method_10562("FoodStatsMultiplier");
            mapMulti = new TreeMap<class_1320, Double>(ModAttributes.SORTED);
            for (String attName : tag.method_10541()) {
                att = (class_1320)class_2378.field_23781.method_10223(new class_2960(attName));
                if (!class_2378.field_23781.method_10221((Object)att).toString().equals(attName)) continue;
                mapMulti.put(att, tag.method_10574(attName));
            }
        } else {
            mapMulti = props.effectsMultiplier();
        }
        return Pair.of(map, mapMulti);
    }

    public static void setElement(EnumElement element, class_1799 stack) {
        class_2487 tag = ItemNBT.getItemNBT(stack);
        if (tag != null) {
            if (EnumElement.valueOf(tag.method_10558("Element")) == EnumElement.NONE) {
                tag.method_10582("Element", element.toString());
            } else {
                tag.method_10582("Element", EnumElement.NONE.toString());
            }
        }
    }

    public static EnumElement getElement(class_1799 stack) {
        class_2487 tag = ItemNBT.getItemNBT(stack);
        if (tag != null) {
            try {
                return EnumElement.valueOf(tag.method_10558("Element"));
            }
            catch (IllegalArgumentException e) {
                return EnumElement.NONE;
            }
        }
        return ItemNBT.isWeapon(stack) ? DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(ItemStat::element).orElse(EnumElement.NONE) : EnumElement.NONE;
    }

    public static class_1799 addUpgradeItem(class_1799 stack, class_1799 stackToAdd, boolean crafting, EnumCrafting type) {
        int level = ItemNBT.itemLevel(stack);
        if (stackToAdd.method_7960() || !ItemNBT.shouldHaveStats(stack) || level >= 10) {
            return stack;
        }
        class_2487 tag = ItemNBT.getItemNBT(stack);
        if (tag == null) {
            tag = new class_2487();
        }
        ItemStat stat = DataPackHandler.INSTANCE.itemStatManager().get(stackToAdd.method_7909()).orElse(null);
        if (ItemNBT.shouldHaveStats(stackToAdd)) {
            Object armor2;
            Object armor1;
            class_1792 class_17922;
            if (!crafting || tag.method_10545("OriginItem")) {
                return stack;
            }
            boolean lightOreApplied = tag.method_10577("LightOre");
            if (stack.method_31573(RunecraftoryTags.EQUIPMENT)) {
                if (!stackToAdd.method_31573(RunecraftoryTags.EQUIPMENT)) {
                    return stack;
                }
                if (lightOreApplied) {
                    return ItemNBT.changeBaseItemTo(stack, stackToAdd, type);
                }
                class_17922 = stack.method_7909();
                if (class_17922 instanceof class_1738) {
                    armor1 = (class_1738)class_17922;
                    class_17922 = stackToAdd.method_7909();
                    if (class_17922 instanceof class_1738) {
                        armor2 = (class_1738)class_17922;
                        if (armor1.method_7685() == armor2.method_7685()) {
                            return ItemNBT.changeBaseItemTo(stack, stackToAdd, type);
                        }
                    }
                }
            }
            if (stack.method_31573(RunecraftoryTags.UPGRADABLE_HELD)) {
                if (!stackToAdd.method_31573(RunecraftoryTags.UPGRADABLE_HELD)) {
                    return stack;
                }
                if (lightOreApplied) {
                    return ItemNBT.changeBaseItemTo(stack, stackToAdd, type);
                }
                class_17922 = stack.method_7909();
                if (class_17922 instanceof IItemUsable) {
                    armor1 = (IItemUsable)class_17922;
                    class_17922 = stackToAdd.method_7909();
                    if (class_17922 instanceof IItemUsable) {
                        armor2 = (IItemUsable)class_17922;
                        if (armor1.getWeaponType() == armor2.getWeaponType()) {
                            return ItemNBT.changeBaseItemTo(stack, stackToAdd, type);
                        }
                    }
                }
            }
            if (stat.getArmorEffect() != null && stat.getArmorEffect().canBeAppliedTo(stack)) {
                Platform.INSTANCE.getArmorEffects(stack).ifPresent(data -> data.addArmorEffects(stat.getArmorEffect()));
            }
            return stack;
        }
        tag.method_10569("ItemLevel", !crafting ? level + 1 : level);
        float efficiency = 1.0f;
        if (!crafting) {
            int similar = 0;
            class_2499 upgrades = tag.method_10554("Upgrades", 10);
            for (class_2520 item : upgrades) {
                class_2487 nbt = (class_2487)item;
                if (!class_2378.field_11142.method_10221((Object)stackToAdd.method_7909()).toString().equals(nbt.method_10558("Id"))) continue;
                ++similar;
            }
            efficiency = similar > 0 ? (float)(1.0 - Math.pow(0.5, similar)) : 1.0f;
            class_2487 upgradeItem = new class_2487();
            upgradeItem.method_10582("Id", class_2378.field_11142.method_10221((Object)stackToAdd.method_7909()).toString());
            upgradeItem.method_10569("Level", ItemNBT.itemLevel(stackToAdd));
            upgrades.add((Object)upgradeItem);
            tag.method_10566("Upgrades", (class_2520)upgrades);
        } else {
            class_2499 bonus = tag.method_10554("CraftingBonus", 10);
            class_2487 bonusItem = new class_2487();
            bonusItem.method_10582("Id", class_2378.field_11142.method_10221((Object)stackToAdd.method_7909()).toString());
            bonusItem.method_10569("Level", ItemNBT.itemLevel(stackToAdd));
            bonus.add((Object)bonusItem);
            tag.method_10566("CraftingBonus", (class_2520)bonus);
        }
        if (stackToAdd.method_7909() == ModItems.GLASS.get() && stack.method_7909() instanceof IItemUsable) {
            tag.method_10556("MagnifyingGlass", true);
        }
        if (stackToAdd.method_7909() == ModItems.SCRAP_PLUS.get() && stack.method_7909() instanceof IItemUsable) {
            tag.method_10556("ScrapMetalPlus", true);
        }
        boolean hasObjectX = tag.method_10577("ObjectX");
        if (stackToAdd.method_7909() == ModItems.OBJECT_X.get()) {
            tag.method_10556("ObjectX", !hasObjectX);
        }
        if (type == EnumCrafting.FORGE && stackToAdd.method_7909() == ModItems.INVIS_STONE.get()) {
            tag.method_10556("Invis", true);
        }
        if (type == EnumCrafting.FORGE && stackToAdd.method_31573(RunecraftoryTags.SCALES)) {
            tag.method_10556("DragonScale", true);
        }
        if (crafting && stackToAdd.method_7909() == ModItems.LIGHT_ORE.get() && !tag.method_10545("OriginItem")) {
            tag.method_10556("LightOre", true);
        }
        if (stackToAdd.method_7909() == ModItems.GLITTA_AUGITE.get()) {
            tag.method_10556("GlittaAugite", true);
        }
        if (stackToAdd.method_7909() == ModItems.RACCOON_LEAF.get()) {
            tag.method_10556("RaccoonLeaf", true);
        }
        boolean applyDoubleSteel = tag.method_10577("DoubleSteel");
        if (!tag.method_10545("DoubleSteel")) {
            if (stackToAdd.method_7909() == ModItems.STEEL_DOUBLE.get()) {
                tag.method_10556("DoubleSteel", true);
            }
        } else if (applyDoubleSteel) {
            tag.method_10556("DoubleSteel", false);
        }
        boolean applyTenSteel = tag.method_10577("TenfoldSteel");
        if (!tag.method_10545("TenfoldSteel")) {
            if (stackToAdd.method_7909() == ModItems.STEEL_TEN.get()) {
                tag.method_10556("TenfoldSteel", true);
            }
        } else if (applyTenSteel) {
            tag.method_10556("TenfoldSteel", false);
        }
        if (stat != null) {
            ItemStat base;
            if (!tag.method_10545("BaseStats") && !stat.itemStats().isEmpty() && (base = (ItemStat)DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).orElse(null)) != null) {
                class_2487 statsTag = new class_2487();
                for (Map.Entry<class_1320, Double> entry : base.itemStats().entrySet()) {
                    if (entry.getKey() == ModAttributes.ATTACK_RANGE.get() && (stackToAdd.method_7909() == ModItems.RACCOON_LEAF.get() && tag.method_10577("RaccoonLeaf") || stackToAdd.method_7909() == ModItems.GLITTA_AUGITE.get() && tag.method_10577("GlittaAugite"))) continue;
                    statsTag.method_10549(class_2378.field_23781.method_10221((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
                }
                tag.method_10566("BaseStats", (class_2520)statsTag);
            }
            List<Object> blacklist = List.of();
            if (type == EnumCrafting.FORGE) {
                blacklist = ARMOR_ONLY;
            }
            if (type == EnumCrafting.ARMOR) {
                blacklist = WEAPON_ONLY;
            }
            class_2487 statCompound = tag.method_10562("ItemStats");
            for (Map.Entry<class_1320, Double> entry : stat.itemStats().entrySet()) {
                if (blacklist.contains(class_2378.field_23781.method_10221((Object)entry.getKey()))) continue;
                double amount = entry.getValue() * (double)efficiency;
                if (hasObjectX) {
                    amount *= -1.0;
                }
                if (applyDoubleSteel) {
                    amount *= 2.0;
                }
                if (applyTenSteel) {
                    amount *= 8.0;
                }
                ItemNBT.updateStatIncrease(entry.getKey(), amount, statCompound);
            }
            tag.method_10566("ItemStats", (class_2520)statCompound);
            if (!tag.method_10545("Element")) {
                tag.method_10582("Element", ItemNBT.getElement(stack).toString());
            }
            if (ItemNBT.isWeapon(stack)) {
                EnumElement current = ItemNBT.getElement(stack);
                if (stat.element() != EnumElement.NONE) {
                    if (current == EnumElement.NONE) {
                        tag.method_10582("Element", stat.element().toString());
                    } else {
                        tag.method_10582("Element", EnumElement.NONE.toString());
                    }
                }
            }
            if (stack.method_7909() instanceof ItemStaffBase) {
                Platform.INSTANCE.getStaffData(stack).ifPresent(data -> {
                    if (stat.getTier1Spell() != null) {
                        data.setTier1Spell(stat.getTier1Spell());
                    }
                    if (stat.getTier2Spell() != null) {
                        data.setTier2Spell(stat.getTier2Spell());
                    }
                    if (stat.getTier3Spell() != null) {
                        data.setTier3Spell(stat.getTier3Spell());
                    }
                });
            }
            if (stat.getArmorEffect() != null && stat.getArmorEffect().canBeAppliedTo(stack)) {
                Platform.INSTANCE.getArmorEffects(stack).ifPresent(data -> data.addArmorEffects(stat.getArmorEffect()));
            }
        }
        class_2487 stackTag = stack.method_7948();
        stackTag.method_10566("runecraftory", (class_2520)tag);
        return stack;
    }

    private static class_1799 changeBaseItemTo(class_1799 stack, class_1799 toApply, EnumCrafting crafting) {
        ItemStat stat = DataPackHandler.INSTANCE.itemStatManager().get(toApply.method_7909()).orElse(null);
        class_2487 tag = new class_2487();
        if (stat != null) {
            ItemStat base;
            if (!stat.itemStats().isEmpty() && (base = (ItemStat)DataPackHandler.INSTANCE.itemStatManager().get(toApply.method_7909()).orElse(null)) != null) {
                class_2487 statsTag = new class_2487();
                Map origin = DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(ItemStat::itemStats).orElse(Map.of());
                for (Map.Entry<class_1320, Double> entry : base.itemStats().entrySet()) {
                    if (NON_INHERITABLE.contains(class_2378.field_23781.method_10221((Object)entry.getKey()))) {
                        statsTag.method_10549(class_2378.field_23781.method_10221((Object)entry.getKey()).toString(), origin.getOrDefault(entry.getKey(), 5.0).doubleValue());
                        continue;
                    }
                    statsTag.method_10549(class_2378.field_23781.method_10221((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
                }
                tag.method_10566("BaseStats", (class_2520)statsTag);
            }
            tag.method_10582("Element", stat.element().toString());
            if (stack.method_7909() instanceof ItemStaffBase) {
                Platform.INSTANCE.getStaffData(stack).ifPresent(data -> {
                    if (stat.getTier1Spell() != null) {
                        data.setTier1Spell(stat.getTier1Spell());
                    }
                    if (stat.getTier2Spell() != null) {
                        data.setTier2Spell(stat.getTier2Spell());
                    }
                    if (stat.getTier3Spell() != null) {
                        data.setTier3Spell(stat.getTier3Spell());
                    }
                });
            }
            if (stat.getArmorEffect() != null && stat.getArmorEffect().canBeAppliedTo(stack)) {
                Platform.INSTANCE.getArmorEffects(stack).ifPresent(data -> data.addArmorEffects(stat.getArmorEffect()));
            }
        }
        tag.method_10582("OriginItem", class_2378.field_11142.method_10221((Object)toApply.method_7909()).toString());
        class_2487 stackTag = stack.method_7948();
        stackTag.method_10566("runecraftory", (class_2520)tag);
        class_2487 other = ItemNBT.getItemNBT(toApply);
        if (other != null) {
            class_2499 bonus = other.method_10554("CraftingBonus", 10);
            bonus.forEach(t -> {
                class_2487 nbt = (class_2487)t;
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(nbt.method_10558("Id")));
                if (item != class_1802.field_8162) {
                    ItemNBT.addUpgradeItem(stack, new class_1799((class_1935)item), true, crafting);
                }
            });
        }
        return stack;
    }

    public static class_1799 addFoodBonusItem(class_1799 stack, class_1799 stackToAdd) {
        if (stackToAdd.method_7960()) {
            return stack;
        }
        class_2487 tag = ItemNBT.getItemNBT(stack);
        if (tag == null) {
            tag = new class_2487();
        }
        class_2499 bonus = tag.method_10554("CraftingBonus", 10);
        class_2487 bonusItem = new class_2487();
        bonusItem.method_10582("Id", class_2378.field_11142.method_10221((Object)stackToAdd.method_7909()).toString());
        bonusItem.method_10569("Level", ItemNBT.itemLevel(stackToAdd));
        bonus.add((Object)bonusItem);
        tag.method_10566("CraftingBonus", (class_2520)bonus);
        FoodProperties props = DataPackHandler.INSTANCE.foodManager().get(stackToAdd.method_7909());
        if (props != null) {
            FoodProperties base;
            if (!tag.method_10545("FoodStats") && (base = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909())) != null) {
                class_2487 statsTag = new class_2487();
                for (Map.Entry<class_1320, Double> entry : base.effects().entrySet()) {
                    statsTag.method_10549(class_2378.field_23781.method_10221((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
                }
                tag.method_10566("FoodStats", (class_2520)statsTag);
                statsTag = new class_2487();
                for (Map.Entry<class_1320, Double> entry : base.effectsMultiplier().entrySet()) {
                    statsTag.method_10549(class_2378.field_23781.method_10221((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
                }
                tag.method_10566("FoodStatsMultiplier", (class_2520)statsTag);
            }
            boolean hasObjectX = tag.method_10577("ObjectX");
            if (stackToAdd.method_7909() == ModItems.OBJECT_X.get()) {
                tag.method_10556("ObjectX", !hasObjectX);
            }
            for (Map.Entry<class_1320, Double> entry : props.cookingBonus().entrySet()) {
                double amount = entry.getValue();
                if (hasObjectX) {
                    amount *= -1.0;
                }
                ItemNBT.updateStatIncrease(entry.getKey(), amount, tag.method_10562("FoodStats"));
            }
            for (Map.Entry<class_1320, Double> entry : props.cookingBonusPercent().entrySet()) {
                double amount = entry.getValue();
                if (hasObjectX) {
                    amount *= -1.0;
                }
                ItemNBT.updateStatIncrease(entry.getKey(), amount, tag.method_10562("FoodStatsMultiplier"));
            }
        }
        class_2487 stackTag = stack.method_7948();
        stackTag.method_10566("runecraftory", (class_2520)tag);
        return stack;
    }

    public static void updateStatIncrease(class_1320 attribute, double amount, class_2487 stats) {
        String att = class_2378.field_23781.method_10221((Object)attribute).toString();
        double oldValue = stats.method_10574(att);
        stats.method_10549(att, oldValue + Math.floor(amount));
    }

    public static class_2487 getItemNBT(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545("runecraftory")) {
            return stack.method_7969().method_10562("runecraftory");
        }
        return null;
    }

    public static boolean shouldHaveStats(class_1799 stack) {
        return stack.method_31573(RunecraftoryTags.UPGRADABLE_HELD) || stack.method_31573(RunecraftoryTags.EQUIPMENT);
    }

    public static boolean shouldHaveLevel(class_1799 stack) {
        return ItemNBT.shouldHaveStats(stack) || stack.method_31573(RunecraftoryTags.SPELLS);
    }

    public static boolean isWeapon(class_1799 stack) {
        return stack.method_31573(RunecraftoryTags.UPGRADABLE_HELD);
    }

    public static boolean canBeUsedAsMagnifyingGlass(class_1799 stack) {
        if (stack.method_7909() == ModItems.GLASS.get()) {
            return true;
        }
        if (stack.method_7985()) {
            class_2487 tag = stack.method_7969().method_10562("runecraftory");
            return tag.method_10577("MagnifyingGlass");
        }
        return false;
    }

    public static boolean doesFixedOneDamage(class_1799 stack) {
        if (stack.method_7985()) {
            class_2487 tag = stack.method_7969().method_10562("runecraftory");
            return tag.method_10577("ScrapMetalPlus");
        }
        return false;
    }

    public static boolean reverseStats(class_1799 stack) {
        if (stack.method_7985()) {
            class_2487 tag = stack.method_7969().method_10562("runecraftory");
            return tag.method_10577("ObjectX");
        }
        return false;
    }

    public static boolean isInvis(class_1799 stack) {
        if (stack.method_7985()) {
            class_2487 tag = stack.method_7969().method_10562("runecraftory");
            return tag.method_10577("Invis");
        }
        return false;
    }

    public static boolean hasDragonScaleUpgrade(class_1799 stack) {
        if (stack.method_7985()) {
            class_2487 tag = stack.method_7969().method_10562("runecraftory");
            return tag.method_10577("DragonScale");
        }
        return false;
    }

    public static class_1799 getOriginItem(class_1799 stack) {
        if (ItemNBT.shouldHaveStats(stack) && stack.method_7985()) {
            class_2487 tag = stack.method_7969().method_10562("runecraftory");
            String s = tag.method_10558("OriginItem");
            if (s.isEmpty()) {
                return class_1799.field_8037;
            }
            return new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(s)));
        }
        return class_1799.field_8037;
    }

    public static boolean usedLightOre(class_1799 stack) {
        if (ItemNBT.shouldHaveStats(stack) && stack.method_7985()) {
            class_2487 tag = stack.method_7969().method_10562("runecraftory");
            String s = tag.method_10558("OriginItem");
            if (s.isEmpty()) {
                return false;
            }
            class_1799 changed = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(s)));
            return changed.method_7960() && tag.method_10577("LightOre");
        }
        return false;
    }

    public static double attackSpeedModifier(class_1309 entity) {
        return entity.method_26825((class_1320)ModAttributes.ATTACK_SPEED.get());
    }

    private static /* synthetic */ void lambda$getStatsAttributeMap$1(Multimap multimap, class_1304 slot, class_1320 att, Double d) {
        multimap.put((Object)att, (Object)new class_1322(LibConstants.EQUIPMENT_MODIFIERS[slot.ordinal()], "rf.stat_increase", d.doubleValue(), class_1322.class_1323.field_6328));
    }
}

