/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.EnumShopResult;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static void starterItems(class_1657 player) {
        class_1799 broadSword = new class_1799((class_1935)ModItems.BROAD_SWORD.get());
        class_1799 hammer = new class_1799((class_1935)ModItems.HAMMER_SCRAP.get());
        ItemUtils.spawnItemAtEntity((class_1309)player, broadSword);
        ItemUtils.spawnItemAtEntity((class_1309)player, hammer);
    }

    public static int getChargeTime(class_1309 entity) {
        return class_3532.method_15384((double)EntityUtils.tryGetAttribute(entity, (class_1320)ModAttributes.CHARGE_TIME.get()));
    }

    public static int getChargeTime(class_1309 entity, EnumToolTier toolTier) {
        int time = class_3532.method_15384((double)EntityUtils.tryGetAttribute(entity, (class_1320)ModAttributes.CHARGE_TIME.get()));
        if (toolTier == EnumToolTier.PLATINUM) {
            time = (int)((float)time * GeneralConfig.platinumChargeTime);
        }
        return time;
    }

    public static void spawnItemAtEntity(class_1309 entity, class_1799 stack) {
        ItemUtils.spawnItemAt(entity.field_6002, entity.method_24515(), stack, entity);
    }

    public static void spawnItemAt(class_1937 level, class_2338 pos, class_1799 stack, @Nullable class_1309 entity) {
        if (!level.field_9236) {
            class_1542 item = new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
            item.method_6982(0);
            if (entity != null) {
                item.method_6984(entity.method_5667());
            }
            level.method_8649((class_1297)item);
        }
    }

    public static void spawnLeveledItem(class_1309 entity, class_1799 stack, int level) {
        if (!entity.field_6002.field_9236) {
            class_1542 item = new class_1542(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), ItemNBT.getLeveledItem(stack, level));
            item.method_6982(0);
            entity.field_6002.method_8649((class_1297)item);
        }
    }

    public static int getSellPrice(class_1799 stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(stat -> ItemUtils.getSellPrice(stack, stat)).orElse(0);
    }

    public static int getSellPrice(class_1799 stack, ItemStat stat) {
        return stat.getSell() * ItemNBT.itemLevel(stack);
    }

    public static int getBuyPrice(class_1799 stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(stat -> ItemUtils.getBuyPrice(stack, stat)).orElse(0);
    }

    public static EnumShopResult buyItem(class_1657 player, EntityNPCBase npc, class_1799 stack) {
        if (ItemUtils.sizeInv(player.method_31548(), stack) < stack.method_7947()) {
            player.method_5783(class_3417.field_15008, 1.0f, 1.0f);
            return EnumShopResult.NOSPACE;
        }
        int price = ItemUtils.getBuyPrice(stack) * stack.method_7947();
        if (Platform.INSTANCE.getPlayerData(player).map(d -> d.useMoney(player, price)).orElse(false).booleanValue()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ModCriteria.SHOP_TRIGGER.trigger(serverPlayer, npc, stack);
            }
            player.method_5783(class_3417.field_14815, 1.0f, 1.0f);
            while (stack.method_7947() > 0) {
                class_1799 copy = stack.method_7972();
                int count = Math.min(stack.method_7947(), stack.method_7914());
                copy.method_7939(count);
                ItemUtils.spawnItemAtEntity((class_1309)player, copy);
                stack.method_7939(stack.method_7947() - count);
            }
            return EnumShopResult.SUCCESS;
        }
        player.method_5783(class_3417.field_15008, 1.0f, 1.0f);
        return EnumShopResult.NOMONEY;
    }

    private static int sizeInv(class_1661 playerInv, class_1799 stack) {
        int amount = 0;
        for (class_1799 iStack : playerInv.field_7547) {
            if (iStack.method_7960()) {
                amount += stack.method_7914();
                continue;
            }
            if (!class_1799.method_31577((class_1799)stack, (class_1799)iStack)) continue;
            amount += stack.method_7914() - iStack.method_7947();
        }
        return amount;
    }

    public static int getBuyPrice(class_1799 stack, ItemStat stat) {
        return stat.getBuy();
    }

    public static float getShieldEfficiency(class_1309 entity) {
        return ItemUtils.getShieldEfficiency(entity.method_6047());
    }

    public static float getShieldEfficiency(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IItemUsable) {
            IItemUsable usable = (IItemUsable)class_17922;
            float eff = usable.getWeaponType().shieldEfficiency;
            if (ItemNBT.hasDragonScaleUpgrade(stack)) {
                eff = Math.min(0.5f, eff + 0.5f);
            }
            return eff;
        }
        return 1.0f;
    }

    public static class_1304 slotOf(class_1799 stack) {
        if (stack.method_7909() instanceof class_1819) {
            return class_1304.field_6171;
        }
        return class_1309.method_32326((class_1799)stack);
    }
}

