/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7;

public class TeleportUtils {
    public static boolean safeDimensionTeleport(class_1308 entity, class_3218 newLevel, class_2338 target) {
        class_2338 safe = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.method_6051(), -3, 3);
            class_2338 pos = TeleportUtils.isSafePos(entity, (class_1937)newLevel, target.method_10069(x, y = TeleportUtils.randomIntInclusive(entity.method_6051(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.method_6051(), -3, 3)), s -> true);
            if (pos == null) continue;
            safe = pos;
            break;
        }
        if (safe == null) {
            return false;
        }
        float yaw = entity.method_36454();
        float pitch = entity.method_36455();
        entity.method_18375();
        class_1308 old = entity;
        entity = (class_1308)old.method_5864().method_5883((class_1937)newLevel);
        if (entity == null) {
            return false;
        }
        entity.method_5878((class_1297)old);
        entity.method_5808((double)safe.method_10263(), (double)safe.method_10264(), (double)safe.method_10260(), yaw, pitch);
        old.method_31745(class_1297.class_5529.field_27002);
        newLevel.method_18769((class_1297)entity);
        newLevel.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14879, class_3419.field_15250, 1.0f, 1.0f);
        for (int i = 0; i < 32; ++i) {
            newLevel.method_14199((class_2394)class_2398.field_11214, entity.method_23317(), entity.method_23318() + newLevel.field_9229.nextDouble() * 2.0, entity.method_23321(), 0, newLevel.field_9229.nextGaussian(), 0.0, newLevel.field_9229.nextGaussian(), 1.0);
        }
        return true;
    }

    public static boolean tryTeleportAround(class_1308 entity, class_1297 target) {
        class_2338 blockPos = target.method_24515();
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.method_6051(), -3, 3);
            class_2338 pos = blockPos.method_10069(x, y = TeleportUtils.randomIntInclusive(entity.method_6051(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.method_6051(), -3, 3));
            if (!TeleportUtils.validTeleportPlace(entity, pos, s -> true)) continue;
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, entity.method_36454(), entity.method_36455());
            entity.method_5942().method_6340();
            return true;
        }
        return false;
    }

    public static boolean tryTeleportAround(class_1308 entity, class_2338 target) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.method_6051(), -3, 3);
            class_2338 pos = target.method_10069(x, y = TeleportUtils.randomIntInclusive(entity.method_6051(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.method_6051(), -3, 3));
            if (!TeleportUtils.validTeleportPlace(entity, pos, s -> true)) continue;
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, entity.method_36454(), entity.method_36455());
            entity.method_5942().method_6340();
            return true;
        }
        return false;
    }

    public static boolean validTeleportPlace(class_1308 entity, class_2338 pos, Predicate<class_2680> validPos) {
        return TeleportUtils.isSafePos(entity, pos, validPos) != null;
    }

    public static class_2338 isSafePos(class_1308 entity, class_2338 pos, Predicate<class_2680> validPos) {
        return TeleportUtils.isSafePos(entity, entity.field_6002, pos, validPos);
    }

    public static class_2338 isSafePos(class_1308 entity, class_1937 level, class_2338 pos, Predicate<class_2680> validPos) {
        class_7 blockPathTypes = entity.method_5942().method_6342().method_17((class_1922)level, pos.method_10263(), pos.method_10264(), pos.method_10260());
        if (blockPathTypes == class_7.field_7 ? !entity.method_5740() : blockPathTypes != class_7.field_12) {
            return null;
        }
        class_2680 blockState = level.method_8320(pos.method_10074());
        if (!validPos.test(blockState)) {
            return null;
        }
        for (class_265 voxelShape : level.method_20812((class_1297)entity, entity.method_5829().method_989((double)pos.method_10263() + 0.5 - entity.method_23317(), (double)pos.method_10264() - entity.method_23318(), (double)pos.method_10260() + 0.5 - entity.method_23321()))) {
            if (voxelShape.method_1110()) continue;
            return null;
        }
        return pos;
    }

    private static int randomIntInclusive(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }
}

