/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.mixin.BiomeAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_4538;
import net.minecraft.class_5569;

public class WorldUtils {
    public static final class_3230<class_1923> ENTITY_LOADER = class_3230.method_20628((String)"runecraftory_entity_loader", Comparator.comparingLong(class_1923::method_8324), (int)100);
    public static final Codec<Pair<EnumSeason, Integer>> DATE = RecordCodecBuilder.create(inst -> inst.group((App)CodecUtils.stringEnumCodec(EnumSeason.class, null).fieldOf("season").forGetter(Pair::getFirst), (App)WorldUtils.dayRange().fieldOf("day").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));

    private static Codec<Integer> dayRange() {
        Function<Integer, DataResult> function = i -> {
            if (i >= 1 && i <= 30) {
                return DataResult.success((Object)i);
            }
            return DataResult.error((String)("Date must be between 1 - 30 but is " + i));
        };
        return Codec.INT.flatXmap(function, function);
    }

    public static boolean canUpdateDaily(class_1937 level, int lastUpdate) {
        return ((class_1928.class_4310)level.method_8450().method_20746(class_1928.field_19396)).method_20753() && WorldUtils.day(level) != lastUpdate;
    }

    public static int dayTime(class_1937 level) {
        return (int)(level.method_8532() % 24000L);
    }

    public static int dayTimeTotal(class_1937 level) {
        return (int)level.method_8532();
    }

    public static long totalTime(class_1937 level) {
        return level.method_8510();
    }

    public static int day(class_1937 level) {
        return WorldUtils.day(level, 0);
    }

    public static int day(class_1937 world, int tickOffset) {
        return (int)((world.method_8532() + (long)tickOffset) / 24000L % Integer.MAX_VALUE);
    }

    public static boolean canPlaceSnowAt(class_1937 level, class_2338 pos) {
        return pos.method_10264() >= level.method_31607() && pos.method_10264() < level.method_31600() && level.method_8314(class_1944.field_9282, pos) < 10 && level.method_8320(pos).method_26215() && class_2246.field_10477.method_9564().method_26184((class_4538)level, pos);
    }

    public static boolean coldEnoughForSnow(class_1937 level, class_2338 pos, class_1959 biome) {
        if (biome.method_33599(pos)) {
            return false;
        }
        return (double)WorldUtils.seasonBasedTemp(level, pos, biome) < 0.15;
    }

    public static float seasonBasedTemp(class_1937 level, class_2338 pos, class_1959 biome) {
        EnumSeason season;
        float temp = ((BiomeAccessor)biome).biomeTemp(pos);
        if (!GeneralConfig.seasonedSnow) {
            return temp;
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            season = WorldHandler.get(serverLevel.method_8503()).currentSeason();
        } else {
            season = ClientHandlers.CLIENT_CALENDAR.currentSeason();
        }
        switch (season) {
            case SUMMER: {
                temp += 0.1f;
                break;
            }
            case FALL: {
                temp -= 0.25f;
                break;
            }
            case WINTER: {
                temp -= 0.8f;
            }
        }
        return temp;
    }

    public static <T extends class_1308> class_5569 wrappedCallbackFor(final T member, final Supplier<class_1657> partyOwner, final class_5569 callback) {
        return new class_5569(){

            public void method_31749() {
                callback.method_31749();
            }

            public void method_31750(class_1297.class_5529 reason) {
                class_1937 class_19372 = member.field_6002;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    if (reason == class_1297.class_5529.field_27000) {
                        WorldHandler.get(serverLevel.method_8503()).safeUnloadedPartyMembers((class_1309)member);
                    } else if (reason == class_1297.class_5529.field_26999 || reason == class_1297.class_5529.field_26998) {
                        class_1657 owner = (class_1657)partyOwner.get();
                        if (owner instanceof class_3222) {
                            class_3222 player = (class_3222)owner;
                            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(d -> d.party.removePartyMember((class_1297)member));
                        } else {
                            WorldHandler.get(serverLevel.method_8503()).toRemovePartyMember((class_1309)member);
                        }
                    }
                }
                callback.method_31750(reason);
            }
        };
    }
}

