/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class NPCHandler {
    private final Map<UUID, class_2561> npcs = new HashMap<UUID, class_2561>();
    private final Map<class_2960, Set<UUID>> uniqueNPCS = new HashMap<class_2960, Set<UUID>>();
    private final Map<UUID, Set<Pair<UUID, class_2960>>> resetQuestNPCS = new HashMap<UUID, Set<Pair<UUID, class_2960>>>();

    public boolean doesNPCExist(UUID uuid) {
        return this.npcs.containsKey(uuid);
    }

    public void addNPC(EntityNPCBase npc) {
        this.npcs.put(npc.method_5667(), npc.method_5477());
    }

    public class_2561 getName(UUID uuid) {
        return this.npcs.get(uuid);
    }

    public void removeNPC(EntityNPCBase npc, class_1297.class_5529 reason) {
        if (reason.method_31486()) {
            npc.method_5682().method_3760().method_14571().forEach(p -> QuestHandler.removeQuestFor(p, npc));
            npc.getFamily().markAsDead();
            this.npcs.remove(npc.method_5667());
        } else {
            this.npcs.put(npc.method_5667(), npc.method_5477());
        }
    }

    public boolean canAssignNPC(NPCData data) {
        if (data.unique() == 0) {
            return true;
        }
        class_2960 res = DataPackHandler.INSTANCE.npcDataManager().getId(data);
        Set<UUID> uuids = this.uniqueNPCS.get(res);
        return uuids == null || uuids.size() < data.unique();
    }

    public boolean addUniqueNPC(UUID uuid, NPCData data) {
        if (data.unique() == 0) {
            return false;
        }
        class_2960 res = DataPackHandler.INSTANCE.npcDataManager().getId(data);
        return this.uniqueNPCS.computeIfAbsent(res, key -> new HashSet()).add(uuid);
    }

    public boolean removeUniqueNPC(UUID uuid, NPCData data) {
        if (data.unique() == 0) {
            return false;
        }
        class_2960 res = DataPackHandler.INSTANCE.npcDataManager().getId(data);
        return this.uniqueNPCS.computeIfAbsent(res, key -> new HashSet()).remove(uuid);
    }

    public void scheduleQuestTrackerReset(UUID npc, UUID player, class_2960 quest) {
        this.resetQuestNPCS.computeIfAbsent(npc, key -> new HashSet()).add(Pair.of((Object)player, (Object)quest));
    }

    public Set<Pair<UUID, class_2960>> playersToReset(UUID npc) {
        return this.resetQuestNPCS.getOrDefault(npc, new HashSet());
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        class_2487 npcs = new class_2487();
        this.npcs.forEach((uuid, comp) -> npcs.method_10566(uuid.toString(), (class_2520)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)comp))));
        tag.method_10566("NPCs", (class_2520)npcs);
        class_2487 uniques = new class_2487();
        this.uniqueNPCS.forEach((res, ids) -> {
            class_2499 idTag = new class_2499();
            ids.forEach(uuid -> idTag.add((Object)class_2519.method_23256((String)uuid.toString())));
            uniques.method_10566(res.toString(), (class_2520)idTag);
        });
        tag.method_10566("UniqueNPCs", (class_2520)uniques);
        class_2487 resetQuestTracker = new class_2487();
        this.resetQuestNPCS.forEach((uuid, ids) -> {
            class_2487 pairs = new class_2487();
            ids.forEach(pair -> pairs.method_10582(((UUID)pair.getFirst()).toString(), ((class_2960)pair.getSecond()).toString()));
            resetQuestTracker.method_10566(uuid.toString(), (class_2520)pairs);
        });
        tag.method_10566("ResetQuestNPCs", (class_2520)resetQuestTracker);
        return tag;
    }

    public void load(class_2487 tag) {
        class_2487 npcs = tag.method_10562("NPCs");
        npcs.method_10541().forEach(key -> this.npcs.put(UUID.fromString(key), (class_2561)class_2561.class_2562.method_10877((String)npcs.method_10558(key))));
        class_2487 uniques = tag.method_10562("UniqueNPCs");
        uniques.method_10541().forEach(key -> {
            class_2499 idTag = uniques.method_10554(key, 8);
            this.uniqueNPCS.put(new class_2960(key), idTag.stream().map(t -> UUID.fromString(t.method_10714())).collect(Collectors.toSet()));
        });
        class_2487 resetQuestTracker = tag.method_10562("ResetQuestNPCs");
        resetQuestTracker.method_10541().forEach(key -> {
            class_2487 pairs = resetQuestTracker.method_10562(key);
            this.resetQuestNPCS.put(UUID.fromString(key), pairs.method_10541().stream().map(t -> Pair.of((Object)UUID.fromString(t), (Object)new class_2960(pairs.method_10558(t)))).collect(Collectors.toSet()));
        });
    }
}

