/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.IDailyUpdate;
import io.github.flemmli97.runecraftory.api.enums.EnumDay;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.utils.CalendarImpl;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.BarnData;
import io.github.flemmli97.runecraftory.common.world.NPCHandler;
import io.github.flemmli97.runecraftory.common.world.NPCSpawner;
import io.github.flemmli97.runecraftory.platform.Platform;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class WorldHandler
extends class_18 {
    private static final String ID_OLD = "RCCalendar";
    private static final String ID = "RunecraftorySaveData";
    private final CalendarImpl calendar = new CalendarImpl();
    private final Set<IDailyUpdate> updateTracker = Sets.newConcurrentHashSet();
    private final Map<UUID, Set<BarnData>> playerBarns = new HashMap<UUID, Set<BarnData>>();
    private final Map<class_5321<class_1937>, Long2ObjectMap<BarnData>> positionBarnMap = new HashMap<class_5321<class_1937>, Long2ObjectMap<BarnData>>();
    private final Map<UUID, Set<UnloadedPartyMember>> unloadedPartyMembers = new HashMap<UUID, Set<UnloadedPartyMember>>();
    private final Map<UUID, Set<UUID>> toRemovePartyMembers = new HashMap<UUID, Set<UUID>>();
    public final NPCHandler npcHandler = new NPCHandler();
    private final NPCSpawner npcSpawner = new NPCSpawner();
    private int updateDelay;
    private int lastUpdateDay;

    public WorldHandler() {
    }

    private WorldHandler(class_2487 tag) {
        this.load(tag);
    }

    public static WorldHandler get(MinecraftServer server) {
        class_26 storage = server.method_30002().method_17983();
        WorldHandler newData = (WorldHandler)storage.method_20786(WorldHandler::new, ID);
        if (newData != null) {
            return newData;
        }
        WorldHandler legacy = (WorldHandler)storage.method_20786(WorldHandler::new, ID_OLD);
        if (legacy != null) {
            storage.method_123(ID_OLD, null);
            storage.method_123(ID, (class_18)legacy);
            return legacy;
        }
        return (WorldHandler)storage.method_17924(WorldHandler::new, WorldHandler::new, ID);
    }

    public static boolean canUpdateWeather(class_1937 level) {
        return GeneralConfig.modifyWeather && level.method_8450().method_8355(class_1928.field_19396);
    }

    public static boolean shouldUpdateWeather(class_1937 level, EnumWeather currentWeather) {
        if (currentWeather == EnumWeather.RUNEY || currentWeather == EnumWeather.STORM) {
            return WorldUtils.dayTime(level) == 1;
        }
        long time = WorldUtils.dayTime(level);
        return time % 3000L == 1L;
    }

    public CalendarImpl getCalendar() {
        return this.calendar;
    }

    public void setDateDayAndSeason(MinecraftServer server, int date, EnumDay day, EnumSeason season) {
        this.calendar.setDateDayAndSeason(date, day, season);
        Platform.INSTANCE.sendToAll(new S2CCalendar(this.calendar), server);
        this.method_80();
    }

    public void increaseDay(class_3218 level) {
        int date = WorldUtils.day((class_1937)level);
        EnumDay day = EnumDay.values()[Math.floorMod(date, EnumDay.values().length)];
        EnumSeason season = EnumSeason.values()[Math.floorMod(date / 30, EnumSeason.values().length)];
        this.calendar.setDateDayAndSeason(date % 30 + 1, day, season);
        Platform.INSTANCE.sendToAll(new S2CCalendar(this.calendar), level.method_8503());
        this.method_80();
    }

    public EnumSeason currentSeason() {
        return this.calendar.currentSeason();
    }

    public int date() {
        return this.calendar.date();
    }

    public EnumDay currentDay() {
        return this.calendar.currentDay();
    }

    public EnumWeather currentWeather() {
        return this.calendar.currentWeather();
    }

    public EnumWeather[] tomorrowsWeather() {
        return this.calendar.tomorrowsForecast();
    }

    public void update(class_3218 level) {
        boolean doWeather = WorldHandler.canUpdateWeather((class_1937)level);
        if (WorldUtils.canUpdateDaily((class_1937)level, this.lastUpdateDay)) {
            this.increaseDay(level);
            this.updateTracker.removeIf(IDailyUpdate::inValid);
            this.updateTracker.forEach(update -> update.update(level));
            this.createDailyWeather(level);
            if (doWeather) {
                this.updateWeatherTo(level, this.calendar.getCurrentWeatherFor(level));
            }
            this.lastUpdateDay = WorldUtils.day((class_1937)level);
            return;
        }
        if (doWeather && WorldHandler.shouldUpdateWeather((class_1937)level, this.currentWeather())) {
            this.updateWeatherTo(level, this.calendar.getCurrentWeatherFor(level));
        }
        this.npcSpawner.method_6445(level, true, true);
    }

    public void updateWeatherTo(class_3218 level, EnumWeather weather) {
        this.calendar.setWeather(level.method_8503(), weather);
        this.setMCWeather(level);
        this.updateDelay = 100;
        this.method_80();
    }

    private void createDailyWeather(class_3218 level) {
        EnumWeather[] nextWeather = new EnumWeather[8];
        EnumSeason season = this.currentSeason();
        int rainCount = 0;
        for (int i = 0; i < nextWeather.length; ++i) {
            float rainAdd;
            float chance = level.field_9229.nextFloat();
            if (i != 0) {
                if (nextWeather[0].wholeDay) {
                    nextWeather[i] = nextWeather[0];
                    return;
                }
            } else {
                float stormAdd;
                float f = stormAdd = season == EnumSeason.SUMMER || season == EnumSeason.WINTER ? 0.04f : 0.0f;
                if (chance < 0.03f) {
                    nextWeather[i] = EnumWeather.RUNEY;
                } else if (chance < 0.015f + stormAdd) {
                    nextWeather[i] = EnumWeather.STORM;
                }
                if (nextWeather[i] != null) {
                    return;
                }
            }
            float f = rainAdd = rainCount > 0 ? 0.5f - (float)(rainCount - 1) * 0.2f : 0.0f;
            if (i < 3) {
                rainAdd = (float)((double)rainAdd + (season == EnumSeason.SUMMER ? 0.1 : 0.05));
            }
            if (chance < 0.1f + rainAdd) {
                nextWeather[i] = EnumWeather.RAIN;
                ++rainCount;
                continue;
            }
            nextWeather[i] = EnumWeather.CLEAR;
        }
        this.calendar.updateWeathers(nextWeather);
    }

    private void setMCWeather(class_3218 level) {
        this.currentWeather().setWeather.accept(level);
    }

    private boolean isCorrectWeather(class_3218 level) {
        return switch (this.currentWeather()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumWeather.RAIN -> level.method_8419();
            case EnumWeather.CLEAR, EnumWeather.RUNEY, EnumWeather.CLOUDY -> {
                if (!level.method_8419() && !level.method_8546()) {
                    yield true;
                }
                yield false;
            }
            case EnumWeather.STORM -> level.method_8419() && level.method_8546();
        };
    }

    public void addToTracker(IDailyUpdate update) {
        this.updateTracker.add(update);
    }

    public boolean removeFromTracker(IDailyUpdate update) {
        return this.updateTracker.remove(update);
    }

    public BarnData getOrCreateFor(UUID player, class_1937 level, class_2338 pos) {
        BarnData data = (BarnData)this.positionBarnMap.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> new Long2ObjectOpenHashMap()).computeIfAbsent(pos.method_10063(), l -> new BarnData(class_4208.method_19443((class_5321)level.method_27983(), (class_2338)pos)));
        this.playerBarns.computeIfAbsent(player, uuid -> new HashSet()).add(data);
        this.method_80();
        return data;
    }

    public Set<BarnData> barnsOf(UUID player) {
        return ImmutableSet.copyOf((Collection)this.playerBarns.getOrDefault(player, Set.of()));
    }

    @Nullable
    public BarnData barnAt(class_4208 pos) {
        Long2ObjectMap<BarnData> map = this.positionBarnMap.get(pos.method_19442());
        if (map != null) {
            return (BarnData)map.get(pos.method_19446().method_10063());
        }
        return null;
    }

    @Nullable
    public BarnData findFittingBarn(BaseMonster monster, UUID owner) {
        return this.barnsOf(owner).stream().filter(b -> b.hasCapacityFor(monster)).findFirst().orElse(null);
    }

    @Nullable
    public BarnData findNearestFittingBarn(BaseMonster monster, int radius) {
        if (monster.method_6139() == null) {
            return null;
        }
        return this.barnsOf(monster.method_6139()).stream().filter(b -> b.pos.method_19442() == monster.field_6002.method_27983() && new class_238(monster.method_24515()).method_1014((double)radius).method_1006(class_243.method_24953((class_2382)b.pos.method_19446())) && b.hasCapacityFor(monster)).findFirst().orElse(null);
    }

    @Nullable
    public BarnData findFittingBarn(BaseMonster monster) {
        if (monster.method_6139() == null) {
            return null;
        }
        return this.findFittingBarn(monster, monster.method_6139());
    }

    public void removeMonsterFromPlayer(UUID player, BaseMonster monster) {
        this.playerBarns.getOrDefault(player, Set.of()).forEach(b -> b.removeMonster(monster));
    }

    public void removeBarn(UUID player, class_4208 pos) {
        Long2ObjectMap<BarnData> map = this.positionBarnMap.get(pos.method_19442());
        if (map != null) {
            BarnData old = (BarnData)map.remove(pos.method_19446().method_10063());
            this.playerBarns.computeIfAbsent(player, uuid -> new HashSet()).remove(old);
            old.remove();
            this.method_80();
        }
    }

    public void safeUnloadedPartyMembers(class_1309 entity) {
        EntityNPCBase npc;
        BaseMonster monster;
        if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).method_6139() != null) {
            this.unloadedPartyMembers.computeIfAbsent(monster.method_6139(), o -> new HashSet()).add(new UnloadedPartyMember(entity.method_5667(), class_4208.method_19443((class_5321)entity.field_6002.method_27983(), (class_2338)entity.method_24515())));
        } else if (entity instanceof EntityNPCBase && (npc = (EntityNPCBase)entity).getEntityToFollowUUID() != null) {
            this.unloadedPartyMembers.computeIfAbsent(npc.getEntityToFollowUUID(), o -> new HashSet()).add(new UnloadedPartyMember(entity.method_5667(), class_4208.method_19443((class_5321)entity.field_6002.method_27983(), (class_2338)entity.method_24515())));
        }
    }

    public Set<UnloadedPartyMember> getUnloadedPartyMembersFor(class_1657 player) {
        return this.unloadedPartyMembers.computeIfAbsent(player.method_5667(), o -> new HashSet());
    }

    public void toRemovePartyMember(class_1309 entity) {
        EntityNPCBase npc;
        BaseMonster monster;
        if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).method_6139() != null) {
            this.toRemovePartyMembers.computeIfAbsent(monster.method_6139(), o -> new HashSet()).add(entity.method_5667());
        } else if (entity instanceof EntityNPCBase && (npc = (EntityNPCBase)entity).getEntityToFollowUUID() != null) {
            this.toRemovePartyMembers.computeIfAbsent(npc.getEntityToFollowUUID(), o -> new HashSet()).add(entity.method_5667());
        }
    }

    public Set<UUID> removedPartyMembersFor(class_1657 player) {
        return this.toRemovePartyMembers.computeIfAbsent(player.method_5667(), o -> new HashSet());
    }

    public void load(class_2487 compoundNBT) {
        this.calendar.read(compoundNBT);
        this.lastUpdateDay = compoundNBT.method_10550("LastUpdateDay");
        class_2487 barns = compoundNBT.method_10562("PlayerBarns");
        barns.method_10541().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            class_2499 list = barns.method_10554(key, 10);
            Set map = this.playerBarns.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> {
                BarnData data = BarnData.fromTag((class_2487)t);
                map.add(data);
                this.positionBarnMap.computeIfAbsent((class_5321<class_1937>)data.pos.method_19442(), k -> new Long2ObjectOpenHashMap()).put(data.pos.method_19446().method_10063(), (Object)data);
            });
        });
        class_2487 unloadedParties = compoundNBT.method_10562("UnloadedParties");
        unloadedParties.method_10541().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            class_2499 list = unloadedParties.method_10554(key, 10);
            Set map = this.unloadedPartyMembers.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> {
                class_2487 cTag = (class_2487)t;
                map.add(new UnloadedPartyMember(UUID.fromString(cTag.method_10558("UUID")), (class_4208)class_4208.field_25066.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)cTag.method_10580("Pos"))).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
            });
        });
        class_2487 removedPartyMembers = compoundNBT.method_10562("RemovedPartyMembers");
        removedPartyMembers.method_10541().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            class_2499 list = removedPartyMembers.method_10554(key, 11);
            Set uuids = this.toRemovePartyMembers.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> uuids.add(class_2512.method_25930((class_2520)t)));
        });
        this.npcHandler.load(compoundNBT.method_10562("NPCHandler"));
    }

    public class_2487 method_75(class_2487 compoundNBT) {
        this.calendar.write(compoundNBT);
        compoundNBT.method_10569("LastUpdateDay", this.lastUpdateDay);
        class_2487 barns = new class_2487();
        this.playerBarns.forEach((uuid, pB) -> {
            class_2499 pBTag = new class_2499();
            pB.forEach(b -> {
                if (!b.isInvalid()) {
                    pBTag.add((Object)b.save());
                }
            });
            barns.method_10566(uuid.toString(), (class_2520)pBTag);
        });
        compoundNBT.method_10566("PlayerBarns", (class_2520)barns);
        class_2487 unloadedParties = new class_2487();
        this.unloadedPartyMembers.forEach((uuid, pairs) -> {
            if (!pairs.isEmpty()) {
                class_2499 pTags = new class_2499();
                pairs.forEach(p -> {
                    class_2487 pTag = new class_2487();
                    pTag.method_10582("UUID", p.uuid().toString());
                    class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)p.pos()).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> pTag.method_10566("Pos", t));
                    pTags.add((Object)pTag);
                });
                unloadedParties.method_10566(uuid.toString(), (class_2520)pTags);
            }
        });
        compoundNBT.method_10566("UnloadedParties", (class_2520)unloadedParties);
        class_2487 removedPartyMembers = new class_2487();
        this.toRemovePartyMembers.forEach((uuid, uuids) -> {
            if (!uuids.isEmpty()) {
                class_2499 pTags = new class_2499();
                uuids.forEach(member -> pTags.add((Object)class_2512.method_25929((UUID)member)));
                removedPartyMembers.method_10566(uuid.toString(), (class_2520)pTags);
            }
        });
        compoundNBT.method_10566("RemovedPartyMembers", (class_2520)removedPartyMembers);
        compoundNBT.method_10566("NPCHandler", (class_2520)this.npcHandler.save());
        return compoundNBT;
    }

    public record UnloadedPartyMember(UUID uuid, class_4208 pos) {
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UnloadedPartyMember) {
                UnloadedPartyMember other = (UnloadedPartyMember)obj;
                return other.uuid.equals(this.uuid);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.uuid.hashCode();
        }
    }
}

