/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.farming;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrop;
import io.github.flemmli97.runecraftory.common.blocks.BlockGiantCrop;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CFarmlandRemovePacket;
import io.github.flemmli97.runecraftory.common.network.S2CFarmlandUpdatePacket;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandData;
import io.github.flemmli97.runecraftory.platform.Platform;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public class FarmlandHandler
extends class_18 {
    private static final String ID = "FarmlandData";
    private static final int CHUNK_SECTION_SIZE = 4096;
    private final Map<class_5321<class_1937>, Long2ObjectMap<FarmlandData>> farmland = new HashMap<class_5321<class_1937>, Long2ObjectMap<FarmlandData>>();
    private final Map<class_5321<class_1937>, Long2ObjectMap<Set<FarmlandData>>> farmlandChunks = new HashMap<class_5321<class_1937>, Long2ObjectMap<Set<FarmlandData>>>();
    private final Map<class_5321<class_1937>, Long2ObjectMap<Set<FarmlandData>>> scheduledUpdates = new HashMap<class_5321<class_1937>, Long2ObjectMap<Set<FarmlandData>>>();
    private final Map<class_5321<class_1937>, Long2ObjectMap<Set<class_2338>>> scheduledRemoveUpdates = new HashMap<class_5321<class_1937>, Long2ObjectMap<Set<class_2338>>>();
    private final Map<class_5321<class_1937>, Set<PendingGiantCrops>> pendingGiantGrowth = new HashMap<class_5321<class_1937>, Set<PendingGiantCrops>>();
    private final Map<class_5321<class_1937>, Map<UUID, IrrigationPOI>> irrigationPOI = new HashMap<class_5321<class_1937>, Map<UUID, IrrigationPOI>>();
    private int lastUpdateDay;

    public FarmlandHandler() {
    }

    private FarmlandHandler(class_2487 tag) {
        this.load(tag);
    }

    public static FarmlandHandler get(MinecraftServer server) {
        return (FarmlandHandler)server.method_30002().method_17983().method_17924(FarmlandHandler::new, FarmlandHandler::new, ID);
    }

    public static boolean isFarmBlock(class_2680 state) {
        return state.method_26164(RunecraftoryTags.FARMLAND) && state.method_28498((class_2769)class_2344.field_11009);
    }

    public static void waterLand(class_3218 level, class_2338 pos, class_2680 state) {
        level.method_14199((class_2394)class_2398.field_11244, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.2, (double)pos.method_10260() + 0.5, 4, 0.0, 0.01, 0.0, 0.1);
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(7)), 3);
        level.method_8396(null, pos, class_3417.field_15171, class_3419.field_15245, 1.0f, 1.1f);
        class_2338 up = pos.method_10084();
        class_2680 crop = level.method_8320(up);
        class_2248 class_22482 = crop.method_26204();
        if (class_22482 instanceof BlockCrop) {
            BlockCrop blockCrop = (BlockCrop)class_22482;
            if (((Boolean)crop.method_11654((class_2769)BlockCrop.WILTED)).booleanValue()) {
                blockCrop.onWiltedWatering((class_1937)level, up, crop);
            }
        }
    }

    public static boolean canRainingAt(class_1937 level, class_2338 position) {
        if (!level.method_8311(position)) {
            return false;
        }
        if (level.method_8598(class_2902.class_2903.field_13197, position).method_10264() > position.method_10264()) {
            return false;
        }
        class_1959 biome = (class_1959)level.method_23753(position).comp_349();
        return biome.method_8694() == class_1959.class_1963.field_9382 && biome.method_39927(position);
    }

    public static void sendChangesTo(class_3218 level, class_1923 pos, List<FarmlandData> data) {
        Platform.INSTANCE.sendToTracking(new S2CFarmlandUpdatePacket(pos.method_8324(), data), level, pos);
    }

    public static void onFarmRemoveChange(class_3218 level, class_1923 pos, List<class_2338> data) {
        Platform.INSTANCE.sendToTracking(new S2CFarmlandRemovePacket(pos.method_8324(), data), level, pos);
    }

    public static void unloadChunk(class_3218 level, class_1923 pos) {
        Platform.INSTANCE.sendToTracking(new S2CFarmlandRemovePacket(pos.method_8324()), level, pos);
    }

    public static boolean isNearWater(class_4538 level, class_2338 pos) {
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos.method_10069(-4, 0, -4), (class_2338)pos.method_10069(4, 1, 4))) {
            if (!level.method_8316(blockPos).method_15767(class_3486.field_15517)) continue;
            return true;
        }
        return false;
    }

    public void onFarmlandPlace(class_3218 level, class_2338 pos) {
        FarmlandData data = (FarmlandData)this.farmland.computeIfAbsent((class_5321<class_1937>)level.method_27983(), old -> new Long2ObjectOpenHashMap()).computeIfAbsent(pos.method_10063(), old -> new FarmlandData(pos));
        ((Set)this.farmlandChunks.computeIfAbsent((class_5321<class_1937>)level.method_27983(), old -> new Long2ObjectOpenHashMap()).computeIfAbsent(new class_1923(pos).method_8324(), old -> new HashSet())).add(data);
        data.updateFarmBlock(true);
        data.onLoad(level, false);
        this.scheduleUpdate(level, data);
        this.method_80();
    }

    public void onFarmlandRemove(class_3218 level, class_2338 pos) {
        FarmlandData data;
        Long2ObjectMap<FarmlandData> farms = this.farmland.get(level.method_27983());
        if (farms != null && (data = (FarmlandData)farms.get(pos.method_10063())) != null) {
            data.updateFarmBlock(false);
            this.scheduleRemoveUpdate(level, data);
            if (data.shouldBeRemoved()) {
                farms.remove(pos.method_10063());
                ((Set)this.farmlandChunks.get(level.method_27983()).get(new class_1923(pos).method_8324())).remove(data);
            }
            this.method_80();
        }
    }

    public void onChunkLoad(class_3218 level, class_1923 pos) {
        Set farms;
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(level.method_27983());
        if (chunkFarms != null && (farms = (Set)chunkFarms.get(pos.method_8324())) != null) {
            farms.forEach(d -> {
                d.onLoad(level, true);
                this.scheduleUpdate(level, (FarmlandData)d);
            });
            this.method_80();
        }
    }

    public void onChunkUnLoad(class_3218 level, class_1923 pos) {
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(level.method_27983());
        if (chunkFarms != null) {
            Set farms = (Set)chunkFarms.get(pos.method_8324());
            if (farms != null) {
                farms.forEach(d -> d.onUnload(level));
                this.method_80();
            }
            FarmlandHandler.unloadChunk(level, pos);
        }
    }

    public Optional<FarmlandData> getData(class_3218 level, class_2338 pos) {
        Long2ObjectMap<FarmlandData> farms = this.farmland.get(level.method_27983());
        if (farms != null) {
            return Optional.ofNullable((FarmlandData)farms.get(pos.method_10063()));
        }
        return Optional.empty();
    }

    public void scheduleUpdate(class_3218 level, FarmlandData data) {
        ((Set)this.scheduledUpdates.computeIfAbsent((class_5321<class_1937>)level.method_27983(), key -> new Long2ObjectOpenHashMap()).computeIfAbsent(new class_1923(data.pos).method_8324(), key -> new HashSet())).add(data);
    }

    public void scheduleRemoveUpdate(class_3218 level, FarmlandData data) {
        ((Set)this.scheduledRemoveUpdates.computeIfAbsent((class_5321<class_1937>)level.method_27983(), key -> new Long2ObjectOpenHashMap()).computeIfAbsent(new class_1923(data.pos).method_8324(), key -> new HashSet())).add(data.pos);
    }

    public void scheduleGiantCropMerge(class_3218 level, class_2338 pos, class_2680 state) {
        Set set = this.pendingGiantGrowth.computeIfAbsent((class_5321<class_1937>)level.method_27983(), key -> new HashSet());
        ArrayList<PendingGiantCrops> overlap = new ArrayList<PendingGiantCrops>();
        for (PendingGiantCrops pending : set) {
            if (pending.contains(pos)) {
                overlap.add(pending);
            }
            if (overlap.size() <= 1) continue;
            ((PendingGiantCrops)overlap.get(0)).add(pos, state);
            ((PendingGiantCrops)overlap.get(0)).combine((PendingGiantCrops)overlap.get(1));
            break;
        }
        if (!overlap.isEmpty()) {
            if (overlap.size() == 1) {
                ((PendingGiantCrops)overlap.get(0)).add(pos, state);
            } else {
                set.remove(overlap.get(1));
            }
            return;
        }
        PendingGiantCrops newData = new PendingGiantCrops();
        newData.add(pos, state);
        set.add(newData);
    }

    public void sendChangesTo(class_3222 player, class_1923 pos) {
        Set farms;
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(player.method_14220().method_27983());
        if (chunkFarms != null && (farms = (Set)chunkFarms.get(pos.method_8324())) != null) {
            Platform.INSTANCE.sendToTracking(new S2CFarmlandUpdatePacket(pos.method_8324(), new ArrayList<FarmlandData>(farms)), player.method_14220(), pos);
        }
    }

    public void addIrrigationPOI(class_3218 level, UUID id, class_2338 pos) {
        MonsterCropIrrigation poi = new MonsterCropIrrigation(level.method_8510(), pos);
        this.irrigationPOI.computeIfAbsent((class_5321<class_1937>)level.method_27983(), old -> new HashMap()).put(id, poi);
        this.method_80();
    }

    public void removeIrrigationPOI(class_3218 level, UUID id) {
        Map<UUID, IrrigationPOI> map = this.irrigationPOI.get(level.method_27983());
        if (map != null) {
            map.remove(id);
            this.method_80();
        }
    }

    public boolean hasWater(class_3218 level, class_2338 pos) {
        if (!GeneralConfig.unloadedFarmlandCheckWater || !GeneralConfig.disableFarmlandRandomtick && FarmlandHandler.isNearWater((class_4538)level, pos)) {
            return true;
        }
        Map<UUID, IrrigationPOI> map = this.irrigationPOI.get(level.method_27983());
        if (map != null) {
            for (IrrigationPOI poi : map.values()) {
                if (level.method_8510() - poi.getStartTime() <= 1200L || !poi.isInside(pos)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick(class_3218 level) {
        if (WorldUtils.canUpdateDaily((class_1937)level, this.lastUpdateDay)) {
            ArrayList<class_5321> empty = new ArrayList<class_5321>();
            this.farmlandChunks.forEach((dim, m) -> {
                class_3218 actualLevel = level.method_27983().equals(dim) ? level : level.method_8503().method_3847(dim);
                ArrayList<FarmlandData> removed = new ArrayList<FarmlandData>();
                LongArraySet toRemove = new LongArraySet();
                for (Long2ObjectMap.Entry entry : m.long2ObjectEntrySet()) {
                    if (entry.getValue() == null) {
                        toRemove.add(entry.getLongKey());
                        continue;
                    }
                    ((Set)entry.getValue()).removeIf(d -> {
                        d.tick(actualLevel, false);
                        boolean remove = d.shouldBeRemoved();
                        if (remove) {
                            removed.add((FarmlandData)d);
                        }
                        return remove;
                    });
                    if (!((Set)entry.getValue()).isEmpty()) continue;
                    toRemove.add(entry.getLongKey());
                }
                toRemove.forEach(arg_0 -> ((Long2ObjectMap)m).remove(arg_0));
                if (m.isEmpty()) {
                    empty.add((class_5321)dim);
                } else {
                    removed.forEach(d -> {
                        Long2ObjectMap<FarmlandData> land = this.farmland.get(dim);
                        if (land != null) {
                            land.remove(d.pos.method_10063());
                        }
                    });
                }
            });
            empty.forEach(dim -> {
                this.farmland.remove(dim);
                this.farmlandChunks.remove(dim);
            });
            this.lastUpdateDay = WorldUtils.day((class_1937)level);
        }
        this.farmlandChunks.forEach((dim, m) -> {
            class_3218 actualLevel;
            class_3218 class_32182 = actualLevel = level.method_27983().equals(dim) ? level : level.method_8503().method_3847(dim);
            if (actualLevel != null) {
                this.randomTick(actualLevel, (Long2ObjectMap<Set<FarmlandData>>)m);
            }
        });
        this.scheduledUpdates.forEach((dim, m) -> {
            class_3218 actualLevel;
            class_3218 class_32182 = actualLevel = level.method_27983().equals(dim) ? level : level.method_8503().method_3847(dim);
            if (actualLevel != null) {
                m.forEach((l, data) -> FarmlandHandler.sendChangesTo(actualLevel, new class_1923(l.longValue()), new ArrayList<FarmlandData>((Collection<FarmlandData>)data)));
            }
        });
        this.scheduledUpdates.clear();
        this.scheduledRemoveUpdates.forEach((dim, m) -> {
            class_3218 actualLevel;
            class_3218 class_32182 = actualLevel = level.method_27983().equals(dim) ? level : level.method_8503().method_3847(dim);
            if (actualLevel != null) {
                m.forEach((l, data) -> FarmlandHandler.onFarmRemoveChange(actualLevel, new class_1923(l.longValue()), new ArrayList<class_2338>((Collection<class_2338>)data)));
            }
        });
        this.scheduledRemoveUpdates.clear();
        this.pendingGiantGrowth.forEach((dim, m) -> {
            class_3218 actualLevel;
            class_3218 class_32182 = actualLevel = level.method_27983().equals(dim) ? level : level.method_8503().method_3847(dim);
            if (actualLevel != null) {
                m.forEach(data -> data.tryMerge(actualLevel));
            }
        });
        this.pendingGiantGrowth.clear();
        this.method_80();
    }

    private void randomTick(class_3218 level, Long2ObjectMap<Set<FarmlandData>> m) {
        EnumWeather weather = WorldHandler.get(level.method_8503()).currentWeather();
        Consumer<FarmlandData> cons = null;
        int day = WorldUtils.day((class_1937)level);
        if (weather == EnumWeather.STORM) {
            cons = d -> d.onStorming(level, day);
        } else if (level.method_8419()) {
            cons = d -> d.onWatering(level, day);
        }
        if (cons == null) {
            return;
        }
        int randomTickSpeed = level.method_8450().method_8356(class_1928.field_19399);
        Consumer<FarmlandData> finalCons = cons;
        m.forEach((packedChunk, data) -> {
            ArrayList list;
            if (data != null && !(list = new ArrayList(data)).isEmpty()) {
                int size = list.size();
                int chance = class_3532.method_15386((float)(4096.0f / (float)size));
                for (int l = 0; l < randomTickSpeed; ++l) {
                    if (level.field_9229.nextInt(chance) != 0) continue;
                    finalCons.accept((FarmlandData)list.get(level.field_9229.nextInt(size)));
                }
            }
        });
    }

    public void load(class_2487 compoundTag) {
        this.lastUpdateDay = compoundTag.method_10550("LastUpdateDay");
        class_2487 farmTag = compoundTag.method_10562("Farms");
        farmTag.method_10541().forEach(levelKey -> {
            class_2487 levelTag = farmTag.method_10562(levelKey);
            class_5321 key = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(levelKey));
            levelTag.method_10541().forEach(l -> {
                long packedPos = Long.parseLong(l);
                FarmlandData data = FarmlandData.fromTag(levelTag.method_10562(l), class_2338.method_10092((long)packedPos));
                this.addDataOnRead((class_5321<class_1937>)key, data);
            });
        });
        class_2487 irrigationTag = compoundTag.method_10562("Irrigation");
        irrigationTag.method_10541().forEach(levelKey -> {
            class_2487 t = irrigationTag.method_10562(levelKey);
            class_5321 key = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(levelKey));
            t.method_10541().forEach(uuidKey -> {
                UUID uuid = UUID.fromString(uuidKey);
                this.irrigationPOI.computeIfAbsent((class_5321<class_1937>)key, old -> new HashMap()).put(uuid, IrrigationPOI.load(t.method_10562(uuidKey)));
            });
        });
    }

    private void addDataOnRead(class_5321<class_1937> key, FarmlandData data) {
        this.farmland.computeIfAbsent(key, old -> new Long2ObjectOpenHashMap()).put(data.pos.method_10063(), (Object)data);
        ((Set)this.farmlandChunks.computeIfAbsent(key, old -> new Long2ObjectOpenHashMap()).computeIfAbsent(new class_1923(data.pos).method_8324(), old -> new HashSet())).add(data);
    }

    public class_2487 method_75(class_2487 compoundTag) {
        compoundTag.method_10569("LastUpdateDay", this.lastUpdateDay);
        class_2487 farmTag = new class_2487();
        this.farmland.forEach((key, map) -> {
            class_2487 levelTag = new class_2487();
            map.forEach((l, data) -> levelTag.method_10566(l.toString(), (class_2520)data.save()));
            farmTag.method_10566(key.method_29177().toString(), (class_2520)levelTag);
        });
        compoundTag.method_10566("Farms", (class_2520)farmTag);
        class_2487 irrigationTag = new class_2487();
        this.irrigationPOI.forEach((key, map) -> {
            class_2487 t = new class_2487();
            map.forEach((uuid, poi) -> t.method_10566(uuid.toString(), (class_2520)poi.save()));
            farmTag.method_10566(key.method_29177().toString(), (class_2520)t);
        });
        compoundTag.method_10566("Irrigation", (class_2520)irrigationTag);
        return compoundTag;
    }

    public static class PendingGiantCrops {
        private static final PositionDirection[] OFFSETS = new PositionDirection[]{new PositionDirection(new class_2338(1, 0, 0), class_2350.field_11039), new PositionDirection(new class_2338(1, 0, 1), class_2350.field_11043), new PositionDirection(new class_2338(0, 0, 1), class_2350.field_11034)};
        private class_238 inner;
        private class_238 outer;
        private final Long2ObjectMap<class_2680> crops = new Long2ObjectOpenHashMap();

        public boolean contains(class_2338 pos) {
            return this.outer != null && this.outer.method_1008((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        }

        public void add(class_2338 pos, class_2680 state) {
            this.crops.put(pos.method_10063(), (Object)state);
            this.inner = this.inner == null ? new class_238(pos) : this.inner.method_991(new class_238(pos));
            this.outer = this.inner.method_1009(1.0, 0.0, 1.0);
        }

        public void combine(PendingGiantCrops other) {
            this.inner = this.inner.method_991(other.inner);
            this.outer = this.inner.method_1009(1.0, 0.0, 1.0);
            this.crops.putAll(other.crops);
        }

        public void tryMerge(class_3218 level) {
            int minX = class_3532.method_15357((double)this.inner.field_1323);
            int minZ = class_3532.method_15357((double)this.inner.field_1321);
            int y = class_3532.method_15357((double)this.inner.field_1322);
            int maxX = class_3532.method_15357((double)(this.inner.field_1320 - 1.0));
            int maxZ = class_3532.method_15357((double)(this.inner.field_1324 - 1.0));
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    class_2680 s = (class_2680)this.crops.get(class_2338.method_10064((int)x, (int)y, (int)z));
                    if (s == null) continue;
                    class_2338 p = new class_2338(x, y, z);
                    ArrayList<Pair> list = new ArrayList<Pair>();
                    if (s.method_26204() instanceof BlockGiantCrop) {
                        s = (class_2680)s.method_11657(BlockGiantCrop.DIRECTION, (Comparable)class_2350.field_11035);
                    }
                    for (PositionDirection offset : OFFSETS) {
                        class_2338 newPos = p.method_10081((class_2382)offset.pos());
                        class_2680 s2 = (class_2680)this.crops.get(newPos.method_10063());
                        if (s2 == null || !s2.method_27852(s.method_26204())) continue;
                        if (s2.method_26204() instanceof BlockGiantCrop) {
                            s2 = (class_2680)s2.method_11657(BlockGiantCrop.DIRECTION, (Comparable)offset.direction());
                        }
                        list.add(Pair.of((Object)newPos, (Object)s2));
                    }
                    list.add(Pair.of((Object)p, (Object)s));
                    if (list.size() != 4) continue;
                    for (Pair pair : list) {
                        this.crops.remove(((class_2338)pair.getFirst()).method_10063());
                        level.method_8652((class_2338)pair.getFirst(), (class_2680)pair.getSecond(), 3);
                    }
                }
            }
        }
    }

    public record MonsterCropIrrigation(long startTime, class_2338 pos) implements IrrigationPOI
    {
        public static final String ID = "MonsterIrrigation";

        public MonsterCropIrrigation(class_2487 tag) {
            this(tag.method_10537("Start"), (class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("Pos")).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)));
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public boolean isInside(class_2338 pos) {
            int radius = MobConfig.farmRadius;
            int dX = this.pos.method_10263() - pos.method_10263();
            int dY = this.pos.method_10264() - pos.method_10264();
            int dZ = this.pos.method_10260() - pos.method_10260();
            return Math.abs(dY) < 2 && Math.abs(dX) < radius && Math.abs(dZ) < radius;
        }

        @Override
        public class_2487 save() {
            class_2487 tag = new class_2487();
            tag.method_10582("ID", ID);
            tag.method_10544("Start", this.getStartTime());
            tag.method_10566("Pos", (class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.pos).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)));
            return tag;
        }
    }

    public static interface IrrigationPOI {
        public static IrrigationPOI load(class_2487 tag) {
            String id = tag.method_10558("ID");
            if (id.equals("MonsterIrrigation")) {
                return new MonsterCropIrrigation(tag);
            }
            throw new IllegalStateException("Couldn't parse!");
        }

        public long getStartTime();

        public boolean isInside(class_2338 var1);

        public class_2487 save();
    }

    record PositionDirection(class_2338 pos, class_2350 direction) {
    }
}

