/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.fabric.config;

import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.fabric.config.ConfigHolder;
import io.github.flemmli97.tenshilib.common.config.CommentedJsonConfig;
import io.github.flemmli97.tenshilib.common.config.JsonConfig;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfigSpec {
    public static final Pair<JsonConfig<CommentedJsonConfig>, ClientConfigSpec> SPEC = CommentedJsonConfig.Builder.create((Path)FabricLoader.getInstance().getConfigDir().resolve("runecraftory").resolve("client.json"), (int)1, ClientConfigSpec::new);
    public final CommentedJsonConfig.IntVal healthBarWidgetX;
    public final CommentedJsonConfig.IntVal healthBarWidgetY;
    public final CommentedJsonConfig.CommentedVal<ClientConfig.DisplayPosition> healthBarWidgetPosition;
    public final CommentedJsonConfig.IntVal seasonDisplayX;
    public final CommentedJsonConfig.IntVal seasonDisplayY;
    public final CommentedJsonConfig.CommentedVal<ClientConfig.DisplayPosition> seasonDisplayPosition;
    public final CommentedJsonConfig.IntVal inventoryOffsetX;
    public final CommentedJsonConfig.IntVal inventoryOffsetY;
    public final CommentedJsonConfig.IntVal creativeInventoryOffsetX;
    public final CommentedJsonConfig.IntVal creativeInventoryOffsetY;
    public final CommentedJsonConfig.IntVal farmlandX;
    public final CommentedJsonConfig.IntVal farmlandY;
    public final CommentedJsonConfig.CommentedVal<ClientConfig.DisplayPosition> farmlandPosition;
    public final CommentedJsonConfig.CommentedVal<ClientConfig.HealthRPRenderType> renderHealthRPBar;
    public final CommentedJsonConfig.CommentedVal<Boolean> renderCalendar;
    public final CommentedJsonConfig.CommentedVal<Boolean> inventoryButton;
    public final CommentedJsonConfig.CommentedVal<Boolean> grassColor;
    public final CommentedJsonConfig.CommentedVal<Boolean> foliageColor;
    public final CommentedJsonConfig.CommentedVal<Boolean> bossMusic;
    public final CommentedJsonConfig.IntVal bossMusicFadeDelay;

    private ClientConfigSpec(CommentedJsonConfig.Builder builder) {
        this.healthBarWidgetX = builder.comment(new String[]{"X Position of health bar"}).defineInRange("Health X", ClientConfig.healthBarWidgetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.healthBarWidgetY = builder.comment(new String[]{"Y Position of health bar"}).defineInRange("Health Y", ClientConfig.healthBarWidgetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.healthBarWidgetPosition = builder.comment(new String[]{"Relative Position of the health bar in regards to the screen"}).define("Health Anchor", (Object)ClientConfig.healthBarWidgetPosition);
        this.seasonDisplayX = builder.comment(new String[]{"X Position of calendar display"}).defineInRange("Calendar X", ClientConfig.seasonDisplayX, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.seasonDisplayY = builder.comment(new String[]{"Y Position of calendar display"}).defineInRange("Calendar Y", ClientConfig.seasonDisplayY, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.seasonDisplayPosition = builder.comment(new String[]{"Relative Position of the calendar in regards to the screen"}).define("Calendar Anchor", (Object)ClientConfig.seasonDisplayPosition);
        this.inventoryOffsetX = builder.comment(new String[]{"X offset of inventory button"}).defineInRange("Inventory X", ClientConfig.inventoryOffsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.inventoryOffsetY = builder.comment(new String[]{"Y offset of inventory button"}).defineInRange("Inventory Y", ClientConfig.inventoryOffsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.creativeInventoryOffsetX = builder.comment(new String[]{"X offset of inventory button in creative"}).defineInRange("Creative X", ClientConfig.creativeInventoryOffsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.creativeInventoryOffsetY = builder.comment(new String[]{"Y offset of inventory button in creative"}).defineInRange("Creative Y", ClientConfig.creativeInventoryOffsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.farmlandX = builder.comment(new String[]{"X Position of farmland info with the magnifying glass"}).defineInRange("Farminfo X", ClientConfig.farmlandX, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.farmlandY = builder.comment(new String[]{"Y Position of farmland info with the magnifying glass"}).defineInRange("Farminfo Y", ClientConfig.farmlandY, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.farmlandPosition = builder.comment(new String[]{"Relative Position of the farmland info in regards to the screen"}).define("Farminfo Anchor", (Object)ClientConfig.farmlandPosition);
        this.renderHealthRPBar = builder.comment(new String[]{"Render Health and RP bars"}).define("Health-RP Render", (Object)ClientConfig.renderHealthRpBar);
        this.renderCalendar = builder.define("Render Calendar", (Object)ClientConfig.renderCalendar);
        this.inventoryButton = builder.comment(new String[]{"Adds the button for the extended inventory to the vanilla inventory"}).define("Add Button", (Object)ClientConfig.inventoryButton);
        this.grassColor = builder.comment(new String[]{"Adjust grass color to current season"}).define("Season Grass", (Object)ClientConfig.grassColor);
        this.foliageColor = builder.comment(new String[]{"Adjust foliage color to current season"}).define("Season Foliage", (Object)ClientConfig.foliageColor);
        this.bossMusic = builder.comment(new String[]{"Bosses play a battle music during fight"}).define("Boss Music", (Object)ClientConfig.bossMusic);
        this.bossMusicFadeDelay = builder.comment(new String[]{"Time in ticks for boss music to fade away if the player runs away from the boss"}).defineInRange("Boss Music Fade", ClientConfig.bossMusicFadeDelay, 0, Integer.MAX_VALUE);
        builder.registerReloadHandler(() -> ConfigHolder.loadClient(this));
    }
}

