/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.fabric.config;

import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.network.S2CSyncConfig;
import io.github.flemmli97.runecraftory.fabric.RuneCraftoryFabric;
import io.github.flemmli97.runecraftory.fabric.config.ClientConfigSpec;
import io.github.flemmli97.runecraftory.fabric.config.GeneralConfigSpec;
import io.github.flemmli97.runecraftory.fabric.config.MobConfigSpec;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.config.CommentedJsonConfig;
import io.github.flemmli97.tenshilib.common.config.JsonConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public record ConfigHolder<T>(T configSpec, Consumer<T> loader) {
    public static final Map<JsonConfig<CommentedJsonConfig>, ConfigHolder<?>> CONFIGS = new LinkedHashMap();

    public static void loadGeneral(GeneralConfigSpec spec) {
        GeneralConfig.defenceSystem = (GeneralConfig.DefenceSystem)((Object)spec.defenceSystem.get());
        GeneralConfig.gateSpawning = (Boolean)spec.gateSpawning.get();
        GeneralConfig.disableVanillaSpawning = (Boolean)spec.disableVanillaSpawning.get();
        GeneralConfig.randomDamage = (Boolean)spec.randomDamage.get();
        GeneralConfig.recipeSystem = (GeneralConfig.RecipeSystem)((Object)spec.recipeSystem.get());
        GeneralConfig.useRp = (Boolean)spec.useRP.get();
        GeneralConfig.deathHpPercent = spec.deathHPPercent.get().floatValue();
        GeneralConfig.deathRpPercent = spec.deathRPPercent.get().floatValue();
        GeneralConfig.disableHunger = (Boolean)spec.disableHunger.get();
        GeneralConfig.modifyWeather = (Boolean)spec.modifyWeather.get();
        GeneralConfig.modifyBed = (Boolean)spec.modifyBed.get();
        GeneralConfig.healOnWakeUp = (Boolean)spec.healOnWakeUp.get();
        GeneralConfig.disableFoodSystem = (Boolean)spec.disableFoodSystem.get();
        GeneralConfig.disableItemStatSystem = (Boolean)spec.disableItemStatSystem.get();
        GeneralConfig.disableCropSystem = (Boolean)spec.disableCropSystem.get();
        GeneralConfig.seasonedSnow = (Boolean)spec.seasonedSnow.get();
        GeneralConfig.maxPartySize = spec.maxPartySize.get();
        GeneralConfig.witherChance = spec.witherChance.get().floatValue();
        GeneralConfig.runeyChance = spec.runeyChance.get().floatValue();
        GeneralConfig.disableFarmlandRandomtick = (Boolean)spec.disableFarmlandRandomtick.get();
        GeneralConfig.disableFarmlandTrample = (Boolean)spec.disableFarmlandTrample.get();
        GeneralConfig.tickUnloadedFarmland = (Boolean)spec.tickUnloadedFarmland.get();
        GeneralConfig.unloadedFarmlandCheckWater = (Boolean)spec.unloadedFarmlandCheckWater.get();
        GeneralConfig.maxLevel = spec.maxLevel.get();
        GeneralConfig.startingHealth = spec.startingHealth.get();
        GeneralConfig.startingRp = spec.startingRP.get();
        GeneralConfig.startingMoney = spec.startingMoney.get();
        GeneralConfig.startingStr = spec.startingStr.get();
        GeneralConfig.startingVit = spec.startingVit.get();
        GeneralConfig.startingIntel = spec.startingIntel.get();
        GeneralConfig.hpPerLevel = spec.hpPerLevel.get().floatValue();
        GeneralConfig.rpPerLevel = spec.rpPerLevel.get().floatValue();
        GeneralConfig.strPerLevel = spec.strPerLevel.get().floatValue();
        GeneralConfig.vitPerLevel = spec.vitPerLevel.get().floatValue();
        GeneralConfig.intPerLevel = spec.intPerLevel.get().floatValue();
        GeneralConfig.shortSwordUltimate = spec.shortSwordUltimate.get().floatValue();
        GeneralConfig.longSwordUltimate = spec.longSwordUltimate.get().floatValue();
        GeneralConfig.spearUltimate = spec.spearUltimate.get().floatValue();
        GeneralConfig.hammerAxeUltimate = spec.hammerAxeUltimate.get().floatValue();
        GeneralConfig.dualBladeUltimate = spec.dualBladeUltimate.get().floatValue();
        GeneralConfig.gloveUltimate = spec.gloveUltimate.get().floatValue();
        GeneralConfig.platinumChargeTime = spec.platinumChargeTime.get().floatValue();
        GeneralConfig.scrapWateringCanWater = spec.scrapWateringCanWater.get();
        GeneralConfig.ironWateringCanWater = spec.ironWateringCanWater.get();
        GeneralConfig.silverWateringCanWater = spec.silverWateringCanWater.get();
        GeneralConfig.goldWateringCanWater = spec.goldWateringCanWater.get();
        GeneralConfig.platinumWateringCanWater = spec.platinumWateringCanWater.get();
        GeneralConfig.moveSpeedAttack.read(spec.moveSpeedAttack.get());
        GeneralConfig.xpMultiplier = spec.xpMultiplier.get().floatValue();
        GeneralConfig.skillXpMultiplier = spec.skillXpMultiplier.get().floatValue();
        GeneralConfig.tamingMultiplier = spec.tamingMultiplier.get().floatValue();
        GeneralConfig.debugAttack = (Boolean)spec.debugAttack.get();
        if (RuneCraftoryFabric.getServerInstance() != null) {
            Platform.INSTANCE.sendToAll(new S2CSyncConfig(), RuneCraftoryFabric.getServerInstance());
        }
    }

    public static void loadClient(ClientConfigSpec spec) {
        ClientConfig.healthBarWidgetX = spec.healthBarWidgetX.get();
        ClientConfig.healthBarWidgetY = spec.healthBarWidgetY.get();
        ClientConfig.healthBarWidgetPosition = (ClientConfig.DisplayPosition)((Object)spec.healthBarWidgetPosition.get());
        ClientConfig.seasonDisplayX = spec.seasonDisplayX.get();
        ClientConfig.seasonDisplayY = spec.seasonDisplayY.get();
        ClientConfig.seasonDisplayPosition = (ClientConfig.DisplayPosition)((Object)spec.seasonDisplayPosition.get());
        ClientConfig.inventoryOffsetX = spec.inventoryOffsetX.get();
        ClientConfig.inventoryOffsetY = spec.inventoryOffsetY.get();
        ClientConfig.creativeInventoryOffsetX = spec.creativeInventoryOffsetX.get();
        ClientConfig.creativeInventoryOffsetY = spec.creativeInventoryOffsetY.get();
        ClientConfig.farmlandX = spec.farmlandX.get();
        ClientConfig.farmlandY = spec.farmlandY.get();
        ClientConfig.farmlandPosition = (ClientConfig.DisplayPosition)((Object)spec.farmlandPosition.get());
        ClientConfig.renderHealthRpBar = (ClientConfig.HealthRPRenderType)((Object)spec.renderHealthRPBar.get());
        ClientConfig.renderCalendar = (Boolean)spec.renderCalendar.get();
        ClientConfig.inventoryButton = (Boolean)spec.inventoryButton.get();
        ClientConfig.grassColor = (Boolean)spec.grassColor.get();
        ClientConfig.foliageColor = (Boolean)spec.foliageColor.get();
        ClientConfig.bossMusic = (Boolean)spec.bossMusic.get();
        ClientConfig.bossMusicFadeDelay = spec.bossMusicFadeDelay.get();
    }

    public static void loadMobs(MobConfigSpec spec) {
        MobConfig.disableNaturalSpawn = (Boolean)spec.disableNaturalSpawn.get();
        MobConfig.farmRadius = spec.farmRadius.get();
        MobConfig.mobAttackNpc = (Boolean)spec.mobAttackNPC.get();
        MobConfig.vanillaGiveXp = (Boolean)spec.vanillaGiveXp.get();
        MobConfig.monsterNeedBarn = (Boolean)spec.monsterNeedBarn.get();
        MobConfig.bellRadius = spec.bellRadius.get();
        MobConfig.gateHealth = spec.gateHealth.get();
        MobConfig.gateDef = spec.gateDef.get();
        MobConfig.gateMDef = spec.gateMDef.get();
        MobConfig.gateHealthGain = spec.gateHealthGain.get();
        MobConfig.gateDefGain = spec.gateDefGain.get();
        MobConfig.gateMDefGain = spec.gateMDefGain.get();
        MobConfig.gateXp = spec.gateXP.get();
        MobConfig.gateMoney = spec.gateMoney.get();
        MobConfig.minSpawnDelay = spec.minSpawnDelay.get();
        MobConfig.maxSpawnDelay = Math.max(MobConfig.minSpawnDelay, spec.maxSpawnDelay.get());
        MobConfig.minDist = spec.minDist.get();
        MobConfig.maxGroup = spec.maxGroup.get();
        MobConfig.minNearby = spec.minNearby.get();
        MobConfig.maxNearby = spec.maxNearby.get();
        MobConfig.baseGateLevel = spec.baseGateLevel.get();
        MobConfig.gateLevelType = (MobConfig.GateLevelType)((Object)spec.gateLevelType.get());
        MobConfig.levelZones.readFromString((List)spec.levelZones.get());
        MobConfig.playerLevelType = (MobConfig.PlayerLevelType)((Object)spec.playerLevelType.get());
        MobConfig.treasureChance = spec.treasureChance.get().floatValue();
        MobConfig.mimicChance = spec.mimicChance.get().floatValue();
        MobConfig.mimicStrongChance = spec.mimicStrongChance.get().floatValue();
        MobConfig.npcSpawnRateMin = spec.npcSpawnRateMin.get();
        MobConfig.npcSpawnRateMax = spec.npcSpawnRateMax.get();
        MobConfig.initialProcreationCooldown = spec.initialProcreationCooldown.get();
        MobConfig.procreationCooldown = spec.procreationCooldown.get();
    }

    public void reloadConfig() {
        this.loader.accept(this.configSpec);
    }

    static {
        CONFIGS.put((JsonConfig<CommentedJsonConfig>)((JsonConfig)GeneralConfigSpec.SPEC.getLeft()), new ConfigHolder<GeneralConfigSpec>((GeneralConfigSpec)GeneralConfigSpec.SPEC.getRight(), ConfigHolder::loadGeneral));
        CONFIGS.put((JsonConfig<CommentedJsonConfig>)((JsonConfig)ClientConfigSpec.SPEC.getLeft()), new ConfigHolder<ClientConfigSpec>((ClientConfigSpec)ClientConfigSpec.SPEC.getRight(), ConfigHolder::loadClient));
        CONFIGS.put((JsonConfig<CommentedJsonConfig>)((JsonConfig)MobConfigSpec.SPEC.getLeft()), new ConfigHolder<MobConfigSpec>((MobConfigSpec)MobConfigSpec.SPEC.getRight(), ConfigHolder::loadMobs));
    }
}

