/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.fabric.config;

import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.fabric.config.ConfigHolder;
import io.github.flemmli97.tenshilib.common.config.CommentedJsonConfig;
import io.github.flemmli97.tenshilib.common.config.JsonConfig;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.tuple.Pair;

public class GeneralConfigSpec {
    public static final Pair<JsonConfig<CommentedJsonConfig>, GeneralConfigSpec> SPEC = CommentedJsonConfig.Builder.create((Path)FabricLoader.getInstance().getConfigDir().resolve("runecraftory").resolve("general.json"), (int)1, GeneralConfigSpec::new);
    public final CommentedJsonConfig.CommentedVal<GeneralConfig.DefenceSystem> defenceSystem;
    public final CommentedJsonConfig.CommentedVal<Boolean> gateSpawning;
    public final CommentedJsonConfig.CommentedVal<Boolean> disableVanillaSpawning;
    public final CommentedJsonConfig.CommentedVal<Boolean> randomDamage;
    public final CommentedJsonConfig.CommentedVal<GeneralConfig.RecipeSystem> recipeSystem;
    public final CommentedJsonConfig.CommentedVal<Boolean> useRP;
    public final CommentedJsonConfig.DoubleVal deathHPPercent;
    public final CommentedJsonConfig.DoubleVal deathRPPercent;
    public final CommentedJsonConfig.CommentedVal<Boolean> disableHunger;
    public final CommentedJsonConfig.CommentedVal<Boolean> modifyWeather;
    public final CommentedJsonConfig.CommentedVal<Boolean> modifyBed;
    public final CommentedJsonConfig.CommentedVal<Boolean> healOnWakeUp;
    public final CommentedJsonConfig.CommentedVal<Boolean> disableFoodSystem;
    public final CommentedJsonConfig.CommentedVal<Boolean> disableItemStatSystem;
    public final CommentedJsonConfig.CommentedVal<Boolean> disableCropSystem;
    public final CommentedJsonConfig.CommentedVal<Boolean> seasonedSnow;
    public final CommentedJsonConfig.IntVal maxPartySize;
    public final CommentedJsonConfig.DoubleVal witherChance;
    public final CommentedJsonConfig.DoubleVal runeyChance;
    public final CommentedJsonConfig.CommentedVal<Boolean> disableFarmlandRandomtick;
    public final CommentedJsonConfig.CommentedVal<Boolean> disableFarmlandTrample;
    public final CommentedJsonConfig.CommentedVal<Boolean> tickUnloadedFarmland;
    public final CommentedJsonConfig.CommentedVal<Boolean> unloadedFarmlandCheckWater;
    public final boolean waila = true;
    public final boolean jei = true;
    public final boolean harvestCraft = true;
    public final boolean seasons = true;
    public final boolean dynamicTrees = true;
    public final CommentedJsonConfig.IntVal maxLevel;
    public final CommentedJsonConfig.IntVal startingHealth;
    public final CommentedJsonConfig.IntVal startingRP;
    public final CommentedJsonConfig.IntVal startingMoney;
    public final CommentedJsonConfig.IntVal startingStr;
    public final CommentedJsonConfig.IntVal startingVit;
    public final CommentedJsonConfig.IntVal startingIntel;
    public final CommentedJsonConfig.DoubleVal hpPerLevel;
    public final CommentedJsonConfig.DoubleVal rpPerLevel;
    public final CommentedJsonConfig.DoubleVal strPerLevel;
    public final CommentedJsonConfig.DoubleVal vitPerLevel;
    public final CommentedJsonConfig.DoubleVal intPerLevel;
    public final CommentedJsonConfig.DoubleVal shortSwordUltimate;
    public final CommentedJsonConfig.DoubleVal longSwordUltimate;
    public final CommentedJsonConfig.DoubleVal spearUltimate;
    public final CommentedJsonConfig.DoubleVal hammerAxeUltimate;
    public final CommentedJsonConfig.DoubleVal dualBladeUltimate;
    public final CommentedJsonConfig.DoubleVal gloveUltimate;
    public final CommentedJsonConfig.DoubleVal platinumChargeTime;
    public final CommentedJsonConfig.IntVal scrapWateringCanWater;
    public final CommentedJsonConfig.IntVal ironWateringCanWater;
    public final CommentedJsonConfig.IntVal silverWateringCanWater;
    public final CommentedJsonConfig.IntVal goldWateringCanWater;
    public final CommentedJsonConfig.IntVal platinumWateringCanWater;
    public final CommentedJsonConfig.DoubleVal moveSpeedAttack;
    public final CommentedJsonConfig.DoubleVal xpMultiplier;
    public final CommentedJsonConfig.DoubleVal skillXpMultiplier;
    public final CommentedJsonConfig.DoubleVal tamingMultiplier;
    public final CommentedJsonConfig.CommentedVal<Boolean> debugMode;
    public final CommentedJsonConfig.CommentedVal<Boolean> debugAttack;

    private GeneralConfigSpec(CommentedJsonConfig.Builder builder) {
        builder.comment(new String[]{"The current default values reflect a near vanilla experience since quite a few things are not done yet to my satisfaction.", "You can freely change the things here and they will work but you might also consider tweaking things for balancing"}).push("Modules");
        this.defenceSystem = builder.comment(new String[]{"How the defence stat in from this mod should be handled", "NO_DEFENCE = Defence is ignored. Raising defence will do nothing", "VANILLA_IGNORE: Damage sources not from this mod will ignore defence on attack except", "IGNORE_VANILLA_MOBS = Entity damage sources not from this mod will ignore defence on attack except if its from a player", "IGNORE_VANILLA_PLAYER_ATT = Player damage sources not from this (vanilla attacks) will ignore defence", "IGNORE_VANILLA_PLAYER_HURT = Entity damage sources not from this will ignore defence if hitting the player", "IGNORE_VANILLA_PLAYER = Combines IGNORE_VANILLA_PLAYER_ATT and IGNORE_VANILLA_PLAYER_HURT"}).define("Defence System", (Object)GeneralConfig.defenceSystem);
        this.gateSpawning = builder.comment(new String[]{"Should gates spawn? If disabled will also disable all mobs from this mod to spawn. Needs server restart"}).define("Gate Spawning", (Object)GeneralConfig.gateSpawning);
        this.disableVanillaSpawning = builder.comment(new String[]{"If enabled mobs can only spawn through gates."}).define("Disable vanilla spawn", (Object)GeneralConfig.disableVanillaSpawning);
        this.randomDamage = builder.comment(new String[]{"If enabled damage gets a +-10% randomness."}).define("Random Damage", (Object)GeneralConfig.randomDamage);
        this.recipeSystem = builder.comment(new String[]{"The recipe system to use.", "SKILL = Crafting skill influence the rp cost. Not unlocked recipes will cost more", "SKILLIGNORELOCK = Crafting skill influence the rp cost and unlock system is ignored", "SKILLBLOCKLOCK = Crafting skill influence the rp cost and locked recipes are not craftable at all", "BASE = Rp cost is a fixed base cost but locked recipes cost more", "BASEIGNORELOCK = Rp cost is a fixed base cost and unlock system is ignored", "BASEBLOCKLOCK = Base cost and locked recipes are uncraftable"}).define("Recipe System", (Object)GeneralConfig.recipeSystem);
        this.useRP = builder.comment(new String[]{"If actions consume rune points"}).define("Use RunePoints", (Object)GeneralConfig.useRp);
        this.deathHPPercent = builder.comment(new String[]{"Percent of HP that will be regenerated on death"}).defineInRange("Death HP Percent", (double)GeneralConfig.deathHpPercent, 0.0, 1.0);
        this.deathRPPercent = builder.comment(new String[]{"Percent of RP that will be regenerated on death"}).defineInRange("Death RP Percent", (double)GeneralConfig.deathRpPercent, 0.0, 1.0);
        this.disableHunger = builder.comment(new String[]{"Disable mc hunger system. Makes it so you can always eat food. Also disables hunger bar rendering on client"}).define("Disable Hunger", (Object)GeneralConfig.disableHunger);
        this.modifyWeather = builder.comment(new String[]{"If true weather will change only at specific time.", "Morning, mid day, evening and mid night"}).define("Modify Weather", (Object)GeneralConfig.modifyWeather);
        this.modifyBed = builder.comment(new String[]{"If true players can sleep anytime and upon waking up will restore all health and rp"}).define("Modify Bed", (Object)GeneralConfig.modifyBed);
        this.healOnWakeUp = builder.comment(new String[]{"If true players heal to full hp and rp upon waking up"}).define("Heal On Wake", (Object)GeneralConfig.healOnWakeUp);
        this.disableFoodSystem = builder.comment(new String[]{"If true food will not provide benefits such as hp restoration etc defined per datapack."}).define("Disable Food System", (Object)GeneralConfig.disableFoodSystem);
        this.disableItemStatSystem = builder.comment(new String[]{"If true item get no stats assigned as defined per datapack. ", "Note: Weapons will then do no damage"}).define("Disable Item Stat System", (Object)GeneralConfig.disableItemStatSystem);
        this.disableCropSystem = builder.comment(new String[]{"If true crop data will be disabled.", "Note: Crops from this mod will not function anymore"}).define("Disable Crop System", (Object)GeneralConfig.disableCropSystem);
        this.seasonedSnow = builder.comment(new String[]{"If biome temperature should be adjusted based on current season. Can cause snowfall during winter"}).define("Seasoned Biome Temp", (Object)GeneralConfig.seasonedSnow);
        this.maxPartySize = builder.comment(new String[]{"Max size of a players party (Entities that follow you). Set to 0 for no limit"}).defineInRange("Max Party Size", GeneralConfig.maxPartySize, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Farming");
        this.witherChance = builder.comment(new String[]{"Change for a crop to wither if its not been watered", "If crop is already withered it and it doesnt get watered it will turn into withered grass"}).defineInRange("Wither Chance", (double)GeneralConfig.witherChance, 0.0, 1.0);
        this.runeyChance = builder.comment(new String[]{"Chance for a runey to spawn when harvesting fully grown crops"}).defineInRange("Runey Chance", (double)GeneralConfig.runeyChance, 0.0, 1.0);
        this.disableFarmlandRandomtick = builder.comment(new String[]{"If true farmland dont get random ticked. Which means nearby water don't water it and it doesn't turn to dirt if there is no water", "You would need to manually water the farmland"}).define("Disable farmland random ticks", (Object)GeneralConfig.disableFarmlandRandomtick);
        this.disableFarmlandTrample = builder.comment(new String[]{"If true disables trampling of farmland"}).define("Disable farmland trample", (Object)GeneralConfig.disableFarmlandTrample);
        this.tickUnloadedFarmland = builder.comment(new String[]{"If true unloaded farmland gets ticked. So crops there will grow without it being loaded", "This also means that without water crops will wilt and die"}).define("Tick unloaded farmland", (Object)GeneralConfig.tickUnloadedFarmland);
        this.unloadedFarmlandCheckWater = builder.comment(new String[]{"If true when loading farmland it will not check if the farmland had water during all the unloaded time.", "If the farmland is loaded it will still need water"}).define("Unloaded farmland check water", (Object)GeneralConfig.unloadedFarmlandCheckWater);
        builder.pop();
        builder.push("Multipliers");
        this.xpMultiplier = builder.comment(new String[]{"Gain base xp * multiplier. Default 0 for now cause its not balanced"}).defineInRange("XP Multiplier", (double)GeneralConfig.xpMultiplier, 0.0, Double.MAX_VALUE);
        this.skillXpMultiplier = builder.comment(new String[]{"Gain base skill xp * multiplier. Default 0 for now cause its not balanced"}).defineInRange("Skill XP Multiplier", (double)GeneralConfig.skillXpMultiplier, 0.0, Double.MAX_VALUE);
        this.tamingMultiplier = builder.comment(new String[]{"Increase/Decrease global taming chance"}).defineInRange("Taming Chance Multiplier", (double)GeneralConfig.tamingMultiplier, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.comment(new String[]{"Debug configs"}).push("Debug");
        this.debugMode = builder.comment(new String[]{"Enable debug mode for various things. Does nothing ATM"}).define("Debug Mode", (Object)GeneralConfig.debugAttack);
        this.debugAttack = builder.comment(new String[]{"Show the attack AoE of mobs"}).define("Debug Attack", (Object)GeneralConfig.debugAttack);
        builder.pop();
        builder.comment(new String[]{"Configs for player stats"}).push("Player Stats");
        this.maxLevel = builder.defineInRange("Max Level", GeneralConfig.maxLevel, 1, 1000);
        this.startingHealth = builder.defineInRange("Starting HP", GeneralConfig.startingHealth, 0, Integer.MAX_VALUE);
        this.startingRP = builder.defineInRange("Starting RP", GeneralConfig.startingRp, 0, Integer.MAX_VALUE);
        this.startingMoney = builder.defineInRange("Starting Money", GeneralConfig.startingMoney, 0, Integer.MAX_VALUE);
        this.startingStr = builder.comment(new String[]{"Starting strength value. 1 strength = 1 attack damage"}).defineInRange("Starting Strength", GeneralConfig.startingStr, 0, Integer.MAX_VALUE);
        this.startingVit = builder.comment(new String[]{"Starting vitality value. 1 vitality = 0.5 defence & magic defence"}).defineInRange("Starting Vit", GeneralConfig.startingVit, 0, Integer.MAX_VALUE);
        this.startingIntel = builder.comment(new String[]{"Starting intelligence value. 1 intelligence = 1 magic damage"}).defineInRange("Starting Int", GeneralConfig.startingIntel, 0, Integer.MAX_VALUE);
        this.hpPerLevel = builder.comment(new String[]{"HP increase per level"}).defineInRange("HP Increase", (double)GeneralConfig.hpPerLevel, 0.0, Double.MAX_VALUE);
        this.rpPerLevel = builder.comment(new String[]{"RP increase per level"}).defineInRange("RP Increase", (double)GeneralConfig.rpPerLevel, 0.0, Double.MAX_VALUE);
        this.strPerLevel = builder.comment(new String[]{"Strenghth increase per level"}).defineInRange("Strength Increase", (double)GeneralConfig.strPerLevel, 0.0, Double.MAX_VALUE);
        this.vitPerLevel = builder.comment(new String[]{"Vitality increase per level"}).defineInRange("Vit Increase", (double)GeneralConfig.vitPerLevel, 0.0, Double.MAX_VALUE);
        this.intPerLevel = builder.comment(new String[]{"Intelligence increase per level"}).defineInRange("Int Increase", (double)GeneralConfig.intPerLevel, 0.0, Double.MAX_VALUE);
        this.shortSwordUltimate = builder.comment(new String[]{"RP Cost of shortsword ultimate"}).defineInRange("Shortsword Ultimate", (double)GeneralConfig.shortSwordUltimate, 0.0, Double.MAX_VALUE);
        this.longSwordUltimate = builder.comment(new String[]{"RP Cost of longsword ultimate"}).defineInRange("Longsword Ultimate", (double)GeneralConfig.longSwordUltimate, 0.0, Double.MAX_VALUE);
        this.spearUltimate = builder.comment(new String[]{"RP Cost of spear ultimate"}).defineInRange("Spear Ultimate", (double)GeneralConfig.spearUltimate, 0.0, Double.MAX_VALUE);
        this.hammerAxeUltimate = builder.comment(new String[]{"RP Cost of hammer and axe ultimate"}).defineInRange("Hammer & Axe Ultimatee", (double)GeneralConfig.hammerAxeUltimate, 0.0, Double.MAX_VALUE);
        this.dualBladeUltimate = builder.comment(new String[]{"RP Cost of dual blades ultimate"}).defineInRange("Dualblade Ultimate", (double)GeneralConfig.dualBladeUltimate, 0.0, Double.MAX_VALUE);
        this.gloveUltimate = builder.comment(new String[]{"RP Cost of fist weapon ultimate"}).defineInRange("Glove Ultimate", (double)GeneralConfig.gloveUltimate, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.comment(new String[]{"Configs for weapon and tools"}).push("Weapon and Tools");
        this.platinumChargeTime = builder.comment(new String[]{"Platinum tier charge up time multiplier"}).defineInRange("Platinum Charge", (double)GeneralConfig.platinumChargeTime, 0.0, Double.MAX_VALUE);
        builder.comment(new String[]{"X blocks the watering can can water"}).push("Watering Can Water");
        this.scrapWateringCanWater = builder.defineInRange("Scrap Watering Can Water", GeneralConfig.scrapWateringCanWater, 0, Integer.MAX_VALUE);
        this.ironWateringCanWater = builder.defineInRange("Iron Watering Can Water", GeneralConfig.ironWateringCanWater, 0, Integer.MAX_VALUE);
        this.silverWateringCanWater = builder.defineInRange("Silver Watering Can Water", GeneralConfig.silverWateringCanWater, 0, Integer.MAX_VALUE);
        this.goldWateringCanWater = builder.defineInRange("Gold Watering Can Water", GeneralConfig.goldWateringCanWater, 0, Integer.MAX_VALUE);
        this.platinumWateringCanWater = builder.defineInRange("Platinum Watering Can Water", GeneralConfig.platinumWateringCanWater, 0, Integer.MAX_VALUE);
        this.moveSpeedAttack = builder.comment(new String[]{"Move speed reduction when attacking.", "Allowing movement during attack will look janky as the animation will not match player movements!", "Synced to clients"}).defineInRange("Attack MoveSpeed ", GeneralConfig.moveSpeedAttack.get().doubleValue(), 0.0, 1.0);
        builder.pop();
        builder.pop();
        builder.registerReloadHandler(() -> ConfigHolder.loadGeneral(this));
    }
}

