/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.fabric.config;

import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.fabric.config.ConfigHolder;
import io.github.flemmli97.tenshilib.common.config.CommentedJsonConfig;
import io.github.flemmli97.tenshilib.common.config.JsonConfig;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.tuple.Pair;

public class MobConfigSpec {
    public static final Pair<JsonConfig<CommentedJsonConfig>, MobConfigSpec> SPEC = CommentedJsonConfig.Builder.create((Path)FabricLoader.getInstance().getConfigDir().resolve("runecraftory").resolve("mobs.json"), (int)1, MobConfigSpec::new);
    public final CommentedJsonConfig.CommentedVal<Boolean> disableNaturalSpawn;
    public final CommentedJsonConfig.IntVal farmRadius;
    public final CommentedJsonConfig.CommentedVal<Boolean> mobAttackNPC;
    public final CommentedJsonConfig.CommentedVal<Boolean> vanillaGiveXp;
    public final CommentedJsonConfig.CommentedVal<Boolean> monsterNeedBarn;
    public final CommentedJsonConfig.IntVal bellRadius;
    public final CommentedJsonConfig.DoubleVal gateHealth;
    public final CommentedJsonConfig.DoubleVal gateDef;
    public final CommentedJsonConfig.DoubleVal gateMDef;
    public final CommentedJsonConfig.DoubleVal gateHealthGain;
    public final CommentedJsonConfig.DoubleVal gateDefGain;
    public final CommentedJsonConfig.DoubleVal gateMDefGain;
    public final CommentedJsonConfig.IntVal gateXP;
    public final CommentedJsonConfig.IntVal gateMoney;
    public final CommentedJsonConfig.IntVal minSpawnDelay;
    public final CommentedJsonConfig.IntVal maxSpawnDelay;
    public final CommentedJsonConfig.DoubleVal minDist;
    public final CommentedJsonConfig.IntVal maxGroup;
    public final CommentedJsonConfig.IntVal minNearby;
    public final CommentedJsonConfig.IntVal maxNearby;
    public final CommentedJsonConfig.IntVal baseGateLevel;
    public final CommentedJsonConfig.CommentedVal<MobConfig.GateLevelType> gateLevelType;
    public final CommentedJsonConfig.CommentedVal<List<String>> levelZones;
    public final CommentedJsonConfig.CommentedVal<MobConfig.PlayerLevelType> playerLevelType;
    public final CommentedJsonConfig.DoubleVal treasureChance;
    public final CommentedJsonConfig.DoubleVal mimicChance;
    public final CommentedJsonConfig.DoubleVal mimicStrongChance;
    public final CommentedJsonConfig.IntVal npcSpawnRateMin;
    public final CommentedJsonConfig.IntVal npcSpawnRateMax;
    public final CommentedJsonConfig.IntVal initialProcreationCooldown;
    public final CommentedJsonConfig.IntVal procreationCooldown;

    public MobConfigSpec(CommentedJsonConfig.Builder builder) {
        builder.push("general");
        this.disableNaturalSpawn = builder.comment(new String[]{"Disable all spawning not from gates"}).define("Disable Spawn", (Object)MobConfig.disableNaturalSpawn);
        this.farmRadius = builder.comment(new String[]{"Radius in blocks for mobs to tend crops in", "Chests for seeds and drops can be placed within radius + 2"}).defineInRange("Farm Radius", MobConfig.farmRadius, 0, Integer.MAX_VALUE);
        this.mobAttackNPC = builder.comment(new String[]{"If monsters should attack npcs/villagers. Note if an npc follows you they will always attack"}).define("Attack NPC", (Object)MobConfig.mobAttackNpc);
        this.vanillaGiveXp = builder.comment(new String[]{"If true other mobs also give xp. The amount is based on the health they have"}).define("Vanilla mobs give XP", (Object)MobConfig.vanillaGiveXp);
        this.monsterNeedBarn = builder.comment(new String[]{"If true monster need to have a barn assigned or other interactions will not be possible"}).define("Monster need barn", (Object)MobConfig.monsterNeedBarn);
        this.npcSpawnRateMin = builder.comment(new String[]{"Min spawn rate of npc in villages"}).defineInRange("NPC Spawnrate Min", MobConfig.npcSpawnRateMin, 0, Integer.MAX_VALUE);
        this.npcSpawnRateMax = builder.comment(new String[]{"Max spawn rate of npc in villages"}).defineInRange("NPC Spawnrate Max", MobConfig.npcSpawnRateMax, 0, Integer.MAX_VALUE);
        this.initialProcreationCooldown = builder.comment(new String[]{"Initial procreation cooldown after marrying an npc"}).defineInRange("Initial procreation cooldown", MobConfig.initialProcreationCooldown, 0, Integer.MAX_VALUE);
        this.procreationCooldown = builder.comment(new String[]{"Cooldown for procreating with an npc"}).defineInRange("Procreation cooldown", MobConfig.procreationCooldown, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.comment(new String[]{"Gate Configs"}).push("gate");
        this.bellRadius = builder.comment(new String[]{"Radius in blocks for bells to prevent gate spawning"}).defineInRange("Bell Radius", MobConfig.bellRadius, 0, Integer.MAX_VALUE);
        this.gateHealth = builder.comment(new String[]{"Base health of gates"}).defineInRange("Health", MobConfig.gateHealth, 0.0, Double.MAX_VALUE);
        this.gateDef = builder.comment(new String[]{"Base defence of gates"}).defineInRange("Defence", MobConfig.gateDef, 0.0, Double.MAX_VALUE);
        this.gateMDef = builder.comment(new String[]{"Base magic defence of gates"}).defineInRange("Magic Defence", MobConfig.gateDef, 0.0, Double.MAX_VALUE);
        this.gateHealthGain = builder.comment(new String[]{"Health gain per level of gates"}).defineInRange("Health Gain", MobConfig.gateHealthGain, 0.0, Double.MAX_VALUE);
        this.gateDefGain = builder.comment(new String[]{"Defence gain per level of gates"}).defineInRange("Defence Gain", MobConfig.gateDefGain, 0.0, Double.MAX_VALUE);
        this.gateMDefGain = builder.comment(new String[]{"Magic defence gain per level of gates"}).defineInRange("Magic Defence Gain", MobConfig.gateMDef, 0.0, Double.MAX_VALUE);
        this.gateXP = builder.comment(new String[]{"Base xp a gate gives"}).defineInRange("XP", MobConfig.gateXp, 0, Integer.MAX_VALUE);
        this.gateMoney = builder.comment(new String[]{"Money a gate gives"}).defineInRange("Money", MobConfig.gateMoney, 0, Integer.MAX_VALUE);
        this.minSpawnDelay = builder.comment(new String[]{"Min delay in ticks for gates to spawn the next mob"}).defineInRange("MinSpawnDelay", MobConfig.minSpawnDelay, 0, Integer.MAX_VALUE);
        this.maxSpawnDelay = builder.comment(new String[]{"Max delay in ticks for gates to spawn the next mob"}).defineInRange("MaxSpawnDelay", MobConfig.maxSpawnDelay, 0, Integer.MAX_VALUE);
        this.minDist = builder.comment(new String[]{"Radius to check for other gates. If more than Max Group gates are in that radius no other gates will spawn"}).defineInRange("Min Dist", MobConfig.minDist, 0.0, Double.MAX_VALUE);
        this.maxGroup = builder.comment(new String[]{"Max amount of gates in Min Dist radius that can exist"}).defineInRange("Max Group", MobConfig.maxGroup, 0, Integer.MAX_VALUE);
        this.minNearby = builder.comment(new String[]{"See Max Nearby"}).defineInRange("Min Nearby", MobConfig.minNearby, 0, Integer.MAX_VALUE);
        this.maxNearby = builder.comment(new String[]{"When spawning gates roll a random number between Min Nearby and this to find the max amount of monsters nearby to stop spawning."}).defineInRange("Max Nearby", MobConfig.maxNearby, 0, Integer.MAX_VALUE);
        this.baseGateLevel = builder.comment(new String[]{"Base level for gates. Level will be at least 1"}).defineInRange("Gate Base Level", MobConfig.baseGateLevel, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.gateLevelType = builder.comment(new String[]{"How the level of a gate is calculated.", "Also see -Player Level Type- config", "CONSTANT: Gate level is simply the value defined in <Gate Base Level>", "DISTANCESPAWN: The further away from spawn a gate is the stronger it gets", "DISTANCESPAWNPLAYER: The further away from a players spawn (or world spawn if not exist) a gate is the stronger it gets. Highest level of nearby player counts", "PLAYERLEVEL: The players level will be used to calculate the gates level", "The final gate level gets a 10% randomizer"}).define("Gate Level Calc", (Object)MobConfig.gateLevelType);
        this.levelZones = builder.comment(new String[]{"Define zones for levels here.", "Gate Level Calc needs to be either DISTANCESPAWN or DISTANCESPAWNPLAYER.", "The an entry is defined as: x-y-z", "x: The distance at which this zone gets used", "y: The starting level of that zone", "z: The increase of level per distance away from the center.", "E.g. 5-10-0.01 means a zone that starts at level 10 and from 5 blocks away from the center and the level will increase by 0.01 per block out."}).define("Gate Zones", MobConfig.levelZones.writeToString());
        this.playerLevelType = builder.comment(new String[]{"How players in a 256 radius influence the calculation of a gates level", "For INCREASED an internal player specific value will be added on. That value is increased e.g. by defeating bosses.", "MEAN: The mean of all players will be used. Does nothing if Gate Level Calc is CONSTANT or DISTANCESPAWN", "MEANINCREASED: The mean of all players will be used.", "MAX: The max of all players will be used. Does nothing if Gate Level Calc is CONSTANT or DISTANCESPAWN", "MAXINCREASED: The max of all players will be used."}).define("Player Level Type", (Object)MobConfig.playerLevelType);
        this.treasureChance = builder.comment(new String[]{"Chance for a gate to spawn a treasure chest upon first try"}).defineInRange("Treasure Chest Chance", (double)MobConfig.treasureChance, 0.0, 1.0);
        this.mimicChance = builder.comment(new String[]{"Chance for a spawned treasure chest to be a monster box"}).defineInRange("Mimic Chance", (double)MobConfig.mimicChance, 0.0, 1.0);
        this.mimicStrongChance = builder.comment(new String[]{"Chance for a monster box to be a gobble box"}).defineInRange("Strong Mimic Chance", (double)MobConfig.mimicStrongChance, 0.0, 1.0);
        builder.pop();
        builder.registerReloadHandler(() -> ConfigHolder.loadMobs(this));
    }
}

