/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.fabric.loot;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_217;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5267;
import net.minecraft.class_5270;
import net.minecraft.class_5341;
import org.jetbrains.annotations.NotNull;

public class CropLootModifier {
    public static final Serializer SERIALIZER = new Serializer();
    protected final class_5341[] conditions;
    private final Predicate<class_47> combinedConditions;
    private final class_1792 remove;

    public CropLootModifier(class_5341[] conditions, class_1792 ignore) {
        this.conditions = conditions;
        this.combinedConditions = class_217.method_924((Predicate[])conditions);
        this.remove = ignore;
    }

    @NotNull
    public final List<class_1799> apply(List<class_1799> generatedLoot, class_47 context) {
        return this.combinedConditions.test(context) ? this.doApply(generatedLoot, context) : generatedLoot;
    }

    protected List<class_1799> doApply(List<class_1799> generatedLoot, class_47 context) {
        if (!GeneralConfig.disableCropSystem) {
            ArrayList mod = new ArrayList();
            generatedLoot.removeIf(stack -> stack.method_7909() == this.remove);
            generatedLoot.removeIf(stack -> this.insertMerge(mod, (class_1799)stack));
            generatedLoot.addAll(mod);
        }
        return generatedLoot;
    }

    private boolean insertMerge(List<class_1799> list, class_1799 stack) {
        if (this.remove == null || this.remove == class_1802.field_8162) {
            return false;
        }
        CropProperties prop = DataPackHandler.INSTANCE.cropManager().get(this.remove);
        if (prop != null) {
            for (class_1799 s : list) {
                if (!class_1799.method_31577((class_1799)s, (class_1799)stack)) continue;
                return true;
            }
            stack.method_7939(prop.maxDrops());
            list.add(stack);
            return true;
        }
        return false;
    }

    public static class Serializer {
        private static final Gson GSON_INSTANCE = class_5270.method_27861().create();

        public CropLootModifier read(class_2960 id, JsonObject object) {
            class_5341[] lootConditions = (class_5341[])GSON_INSTANCE.fromJson(object.get("conditions"), class_5341[].class);
            return new CropLootModifier(lootConditions, (class_1792)class_2378.field_11142.method_10223(new class_2960(class_3518.method_15265((JsonObject)object, (String)"exclude"))));
        }

        public JsonObject write(CropLootModifier instance) {
            JsonObject obj = new JsonObject();
            obj.add("conditions", class_5267.field_24420.method_27849(instance.conditions));
            obj.addProperty("exclude", class_2378.field_11142.method_10221((Object)instance.remove).toString());
            return obj;
        }
    }
}

