/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.fabric.platform;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.attachment.ArmorEffectData;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.StaffData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.equipment.ItemArmorBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.fabric.mixin.DamageSourceAccessor;
import io.github.flemmli97.runecraftory.fabric.mixinhelper.EntityDataGetter;
import io.github.flemmli97.runecraftory.fabric.mixinhelper.ItemStackDataGetter;
import io.github.flemmli97.runecraftory.fabric.mixinhelper.PlayerDataGetter;
import io.github.flemmli97.runecraftory.fabric.network.ClientPacketHandler;
import io.github.flemmli97.runecraftory.fabric.platform.ReflectiveInvokers;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1813;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1917;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_2498;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4168;
import net.minecraft.class_47;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class PlatformImpl
implements Platform {
    @Override
    public boolean isDatagen() {
        return false;
    }

    @Override
    public Optional<PlayerData> getPlayerData(class_1657 player) {
        return Optional.of(((PlayerDataGetter)player).runecraftory$getPlayerData());
    }

    @Override
    public Optional<EntityData> getEntityData(class_1309 living) {
        return Optional.of(((EntityDataGetter)living).runecraftory$getEntityData());
    }

    @Override
    public Optional<StaffData> getStaffData(Object stack) {
        if (stack instanceof ItemStackDataGetter) {
            ItemStackDataGetter getter = (ItemStackDataGetter)stack;
            return Optional.ofNullable(getter.runecraftory$getStaffData());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ArmorEffectData> getArmorEffects(Object stack) {
        if (stack instanceof ItemStackDataGetter) {
            ItemStackDataGetter getter = (ItemStackDataGetter)stack;
            return Optional.ofNullable(getter.runecraftory$getArmorEffectData());
        }
        return Optional.empty();
    }

    @Override
    public void openGuiMenu(class_3222 player, class_3908 provider) {
        player.method_17355(provider);
    }

    @Override
    public void openGuiMenu(class_3222 player, final class_3908 provider, final class_2338 pos) {
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.method_10807(pos);
            }

            public class_2561 method_5476() {
                return provider.method_5476();
            }

            @Nullable
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                return provider.createMenu(i, inventory, player);
            }
        });
    }

    @Override
    public void openGuiMenu(class_3222 player, final class_3908 provider, final Consumer<class_2540> writer) {
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                writer.accept(buf);
            }

            public class_2561 method_5476() {
                return provider.method_5476();
            }

            @Nullable
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                return provider.createMenu(i, inventory, player);
            }
        });
    }

    @Override
    public void sendToClient(Packet message, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)message.getID(), (class_2540)buf);
    }

    @Override
    public void sendToServer(Packet message) {
        ClientPacketHandler.sendToServer(message);
    }

    @Override
    public void sendToAll(Packet message, MinecraftServer server) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        PlayerLookup.all((MinecraftServer)server).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)message.getID(), (class_2540)buf));
    }

    @Override
    public void sendToTrackingAndSelf(Packet message, class_1297 e) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        PlayerLookup.tracking((class_1297)e).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)message.getID(), (class_2540)buf));
        if (e instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)e;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)message.getID(), (class_2540)buf);
        }
    }

    @Override
    public void sendToTracking(Packet message, class_3218 level, class_1923 pos) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        PlayerLookup.tracking((class_3218)level, (class_1923)pos).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)message.getID(), (class_2540)buf));
    }

    @Override
    public boolean isShield(class_1799 stack, class_1657 player) {
        return stack.method_7976() == class_1839.field_8949;
    }

    @Override
    public boolean canEquip(class_1799 stack, class_1304 slot, class_1309 entity) {
        return class_1309.method_32326((class_1799)stack) == slot;
    }

    @Override
    public ItemStaffBase staff(EnumElement starterElement, int amount, class_1792.class_1793 properties) {
        return new ItemStaffBase(starterElement, amount, properties);
    }

    @Override
    public ItemArmorBase armor(class_1304 slot, class_1792.class_1793 properties, class_2960 id, boolean useItemTexture) {
        return new ItemArmorBase(slot, properties, id, useItemTexture);
    }

    @Override
    public class_2498 getSoundType(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        return state.method_26231();
    }

    @Override
    public class_1282 createDamageSource(String name, boolean bypassArmor, boolean bypassMagic, boolean bypassInvul) {
        CustomDamageSource source = new CustomDamageSource(name);
        if (bypassArmor) {
            ((DamageSourceAccessor)((Object)source)).setBypassArmor();
        }
        if (bypassMagic) {
            ((DamageSourceAccessor)((Object)source)).setBypassMagic();
        }
        if (bypassInvul) {
            ((DamageSourceAccessor)((Object)source)).setBypassInvul();
        }
        return source;
    }

    @Override
    public class_2400 simple(boolean overrideLimiter) {
        return ReflectiveInvokers.simpleParticleType(overrideLimiter);
    }

    @Override
    public <T extends class_2586> class_2591<T> blockEntityType(BiFunction<class_2338, class_2680, T> create, class_2248 ... valid) {
        return FabricBlockEntityTypeBuilder.create(create::apply, (class_2248[])valid).build();
    }

    @Override
    public <T extends class_2586> class_2591<T> blockEntityType(BiFunction<class_2338, class_2680, T> create, Set<class_2248> valid) {
        return FabricBlockEntityTypeBuilder.create(create::apply, (class_2248[])valid.toArray(new class_2248[0])).build();
    }

    @Override
    public <T extends class_1703> class_3917<T> menuType(BiFunction<Integer, class_1661, T> create) {
        return new class_3917(create::apply);
    }

    @Override
    public <T extends class_1703> class_3917<T> menuType(TriFunction<Integer, class_1661, class_2540, T> create) {
        return new ExtendedScreenHandlerType((arg_0, arg_1, arg_2) -> create.apply(arg_0, arg_1, arg_2));
    }

    @Override
    public class_4168 activity(String name) {
        return ReflectiveInvokers.activity(name);
    }

    @Override
    public class_1761 tab(String label, Supplier<class_1799> icon) {
        return FabricItemGroupBuilder.build((class_2960)new class_2960("runecraftory", label), icon);
    }

    @Override
    public boolean matchingInventory(class_2586 blockEntity, Predicate<class_1799> func) {
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof class_1263) {
            class_1263 container = (class_1263)blockEntity;
            for (int i = 0; i < container.method_5439(); ++i) {
                if (!func.test(container.method_5438(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public class_1799 findMatchingItem(class_2586 blockEntity, Predicate<class_1799> func, int amount) {
        if (blockEntity == null) {
            return class_1799.field_8037;
        }
        if (blockEntity instanceof class_1263) {
            class_1263 container = (class_1263)blockEntity;
            for (int i = 0; i < container.method_5439(); ++i) {
                if (!func.test(container.method_5438(i))) continue;
                return container.method_5434(i, amount);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 insertInto(class_2586 blockEntity, class_1799 stack) {
        if (blockEntity == null || stack.method_7960()) {
            return stack;
        }
        if (blockEntity instanceof class_1263) {
            class_1263 container = (class_1263)blockEntity;
            for (int i = 0; i < container.method_5439() && !stack.method_7960(); ++i) {
                if (!container.method_5437(i, stack)) continue;
                class_1799 itemStack = container.method_5438(i);
                if (itemStack.method_7960()) {
                    container.method_5447(i, stack);
                    return class_1799.field_8037;
                }
                if (!itemStack.method_31574(stack.method_7909()) || itemStack.method_7919() != stack.method_7919() || itemStack.method_7947() >= stack.method_7914() || !class_1799.method_7975((class_1799)itemStack, (class_1799)stack)) continue;
                int size = Math.min(stack.method_7947(), stack.method_7914() - itemStack.method_7947());
                stack.method_7934(size);
                itemStack.method_7933(size);
                if (!stack.method_7960()) continue;
                return class_1799.field_8037;
            }
        }
        return stack;
    }

    @Override
    public void cropGrowEvent(class_1937 level, class_2338 pos, class_2680 state) {
    }

    @Override
    public void craftingEvent(class_1657 player, class_1799 stack, class_1263 containerMenu) {
    }

    @Override
    public void destroyItem(class_1657 player, class_1799 stack, class_1268 hand) {
    }

    @Override
    public boolean onLivingUpdate(class_1309 entity) {
        return false;
    }

    @Override
    public boolean canEntitySpawnSpawner(class_1308 entity, class_1936 level, double x, double y, double z, class_1917 spawner, class_3730 spawnReason) {
        return true;
    }

    @Override
    public float onLivingHurt(class_1309 entity, class_1282 damageSrc, float damageAmount) {
        return damageAmount;
    }

    @Override
    public int getLootingFromCtx(class_47 ctx) {
        class_1297 entity = (class_1297)ctx.method_296(class_181.field_1230);
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            return class_1890.method_8226((class_1309)living);
        }
        return 0;
    }

    @Override
    public int getLootingFromEntity(class_1297 entity, class_1297 killer, class_1282 source) {
        if (killer instanceof class_1309) {
            class_1309 living = (class_1309)killer;
            return class_1890.method_8226((class_1309)living);
        }
        return 0;
    }

    @Override
    public Supplier<class_1792> registerRecord(int analogOutput, RegistryEntrySupplier<class_3414> sound, class_1792.class_1793 properties) {
        return () -> new class_1813(analogOutput, (class_3414)sound.get(), properties);
    }

    public static class CustomDamageSource
    extends class_1282 {
        public CustomDamageSource(String string) {
            super(string);
        }
    }
}

