/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jei;

import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.integration.jei.SextupleRecipeCategory;
import io.github.flemmli97.runecraftory.integration.jei.SextupleRecipeTransfer;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.recipes.collect.RecipeTypeData;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_746;

@REIPluginCompatIgnore
@JeiPlugin
public class JEI
implements IModPlugin {
    private static final class_2960 ID = new class_2960("runecraftory", "jei_integration");
    public static IJeiRuntime JEI_RUNTIME;

    public class_2960 getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), SextupleRecipeCategory.FORGECATEGORY, (class_1792)ModItems.ITEM_BLOCK_FORGE.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), SextupleRecipeCategory.COOKINGCATEGORY, (class_1792)ModItems.ITEM_BLOCK_COOKING.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), SextupleRecipeCategory.ARMORCATEGORY, (class_1792)ModItems.ITEM_BLOCK_ACCESS.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), SextupleRecipeCategory.CHEMISTRYCATEGORY, (class_1792)ModItems.ITEM_BLOCK_CHEM.get())});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        if (class_310.method_1551() == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        reg.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, ModItems.NOTEX.stream().map(sup -> new class_1799((class_1935)sup.get())).toList());
        class_1863 manager = class_310.method_1551().field_1687.method_8433();
        reg.addRecipes(SextupleRecipeCategory.FORGECATEGORY, JEI.sorted(manager, (class_3956)ModCrafting.FORGE.get()));
        reg.addRecipes(SextupleRecipeCategory.ARMORCATEGORY, JEI.sorted(manager, (class_3956)ModCrafting.ARMOR.get()));
        reg.addRecipes(SextupleRecipeCategory.COOKINGCATEGORY, JEI.sorted(manager, (class_3956)ModCrafting.COOKING.get()));
        reg.addRecipes(SextupleRecipeCategory.CHEMISTRYCATEGORY, JEI.sorted(manager, (class_3956)ModCrafting.CHEMISTRY.get()));
    }

    private static <T extends SextupleRecipe> List<T> sorted(class_1863 manager, class_3956<T> type) {
        List l = manager.method_30027(type);
        l.sort(Comparator.comparingInt(SextupleRecipe::getCraftingLevel));
        return l;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(SextupleRecipeCategory.FORGECATEGORY));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(SextupleRecipeCategory.COOKINGCATEGORY));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(SextupleRecipeCategory.ARMORCATEGORY));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(SextupleRecipeCategory.CHEMISTRYCATEGORY));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new class_1799((class_1935)ModItems.ITEM_BLOCK_FORGE.get()), new RecipeType[]{SextupleRecipeCategory.FORGECATEGORY});
        registration.addRecipeCatalyst(new class_1799((class_1935)ModItems.ITEM_BLOCK_ACCESS.get()), new RecipeType[]{SextupleRecipeCategory.ARMORCATEGORY});
        registration.addRecipeCatalyst(new class_1799((class_1935)ModItems.ITEM_BLOCK_COOKING.get()), new RecipeType[]{SextupleRecipeCategory.COOKINGCATEGORY});
        registration.addRecipeCatalyst(new class_1799((class_1935)ModItems.ITEM_BLOCK_CHEM.get()), new RecipeType[]{SextupleRecipeCategory.CHEMISTRYCATEGORY});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEI_RUNTIME = jeiRuntime;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CraftingGui.class, (IGuiContainerHandler)new IGuiContainerHandler<CraftingGui>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(CraftingGui gui, double mouseX, double mouseY) {
                RecipeType<SextupleRecipe> type = switch (gui.type()) {
                    default -> throw new IncompatibleClassChangeError();
                    case EnumCrafting.FORGE -> SextupleRecipeCategory.FORGECATEGORY;
                    case EnumCrafting.COOKING -> SextupleRecipeCategory.COOKINGCATEGORY;
                    case EnumCrafting.ARMOR -> SextupleRecipeCategory.ARMORCATEGORY;
                    case EnumCrafting.CHEM -> SextupleRecipeCategory.CHEMISTRYCATEGORY;
                };
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)80, (int)30, (int)26, (int)26, (RecipeType[])new RecipeType[]{type});
                return List.of(clickableArea);
            }
        });
    }

    public static <T> Stream<T> filterLocked(Stream<T> recipes, RecipeTypeData<T> recipeTypeData, IFocusGroup focusGroup) {
        if (recipeTypeData.getRecipeCategory().getRecipeType().equals(SextupleRecipeCategory.FORGECATEGORY) || recipeTypeData.getRecipeCategory().getRecipeType().equals(SextupleRecipeCategory.ARMORCATEGORY) || recipeTypeData.getRecipeCategory().getRecipeType().equals(SextupleRecipeCategory.CHEMISTRYCATEGORY) || recipeTypeData.getRecipeCategory().getRecipeType().equals(SextupleRecipeCategory.COOKINGCATEGORY)) {
            class_746 player = class_310.method_1551().field_1724;
            boolean ingredient = focusGroup.getFocuses(RecipeIngredientRole.INPUT).findAny().isPresent();
            Predicate<Object> match = arg_0 -> JEI.lambda$filterLocked$2((class_1657)player, ingredient, arg_0);
            return recipes.filter(match);
        }
        return recipes;
    }

    private static /* synthetic */ boolean lambda$filterLocked$2(class_1657 player, boolean ingredient, Object recipe) {
        return player == null || Platform.INSTANCE.getPlayerData(player).map(cap -> {
            if (ingredient) {
                return cap.getRecipeKeeper().isUnlocked((class_1860)recipe);
            }
            return cap.getRecipeKeeper().isUnlockedForCrafting((class_1860)recipe);
        }).orElse(false) != false;
    }
}

