/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.rei;

import dev.architectury.event.EventResult;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.integration.rei.SextupleCategory;
import io.github.flemmli97.runecraftory.integration.rei.SextupleDisplay;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_746;

public class ReiClientPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<SextupleDisplay> FORGING = CategoryIdentifier.of((class_2960)new class_2960("runecraftory", EnumCrafting.FORGE.getId() + "_category"));
    public static final CategoryIdentifier<SextupleDisplay> CHEM = CategoryIdentifier.of((class_2960)new class_2960("runecraftory", EnumCrafting.CHEM.getId() + "chemistry_category"));
    public static final CategoryIdentifier<SextupleDisplay> COOKING = CategoryIdentifier.of((class_2960)new class_2960("runecraftory", EnumCrafting.COOKING.getId() + "cooking_category"));
    public static final CategoryIdentifier<SextupleDisplay> ARMOR = CategoryIdentifier.of((class_2960)new class_2960("runecraftory", EnumCrafting.ARMOR.getId() + "armor_category"));

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new SextupleCategory(EnumCrafting.FORGE, FORGING));
        registry.addWorkstations(FORGING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)ModItems.ITEM_BLOCK_FORGE.get()))});
        registry.add((DisplayCategory)new SextupleCategory(EnumCrafting.CHEM, CHEM));
        registry.addWorkstations(CHEM, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)ModItems.ITEM_BLOCK_CHEM.get()))});
        registry.add((DisplayCategory)new SextupleCategory(EnumCrafting.COOKING, COOKING));
        registry.addWorkstations(COOKING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)ModItems.ITEM_BLOCK_COOKING.get()))});
        registry.add((DisplayCategory)new SextupleCategory(EnumCrafting.ARMOR, ARMOR));
        registry.addWorkstations(ARMOR, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)ModItems.ITEM_BLOCK_ACCESS.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        for (SextupleRecipe r : ReiClientPlugin.sorted(RecipeManagerContext.getInstance().getRecipeManager(), (class_3956)ModCrafting.FORGE.get())) {
            registry.add((Display)new SextupleDisplay(r, EnumCrafting.FORGE), (Object)r);
        }
        for (SextupleRecipe r : ReiClientPlugin.sorted(RecipeManagerContext.getInstance().getRecipeManager(), (class_3956)ModCrafting.ARMOR.get())) {
            registry.add((Display)new SextupleDisplay(r, EnumCrafting.ARMOR), (Object)r);
        }
        for (SextupleRecipe r : ReiClientPlugin.sorted(RecipeManagerContext.getInstance().getRecipeManager(), (class_3956)ModCrafting.COOKING.get())) {
            registry.add((Display)new SextupleDisplay(r, EnumCrafting.COOKING), (Object)r);
        }
        for (SextupleRecipe r : ReiClientPlugin.sorted(RecipeManagerContext.getInstance().getRecipeManager(), (class_3956)ModCrafting.CHEMISTRY.get())) {
            registry.add((Display)new SextupleDisplay(r, EnumCrafting.CHEM), (Object)r);
        }
        registry.registerVisibilityPredicate((cat, display) -> {
            if (cat.getCategoryIdentifier().equals(FORGING) || cat.getCategoryIdentifier().equals(ARMOR) || cat.getCategoryIdentifier().equals(COOKING) || cat.getCategoryIdentifier().equals(CHEM)) {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null && Platform.INSTANCE.getPlayerData((class_1657)player).map(cap -> cap.getRecipeKeeper().isUnlockedForCrafting(((SextupleDisplay)display).recipe())).orElse(false).booleanValue()) {
                    return EventResult.pass();
                }
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }

    private static <T extends SextupleRecipe> List<T> sorted(class_1863 manager, class_3956<T> type) {
        List l = manager.method_30027(type);
        l.sort(Comparator.comparingInt(SextupleRecipe::getCraftingLevel));
        return l;
    }

    public void registerEntries(EntryRegistry registry) {
        List<class_1792> list = ModItems.NOTEX.stream().map(Supplier::get).toList();
        registry.removeEntryIf(e -> e.getType() == VanillaEntryTypes.ITEM && list.contains(((class_1799)e.castValue()).method_7909()));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(EnumCrafting.FORGE, new Rectangle(80, 30, 26, 26), FORGING));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(EnumCrafting.COOKING, new Rectangle(80, 30, 26, 26), COOKING));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(EnumCrafting.ARMOR, new Rectangle(80, 30, 26, 26), ARMOR));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(EnumCrafting.CHEM, new Rectangle(80, 30, 26, 26), CHEM));
    }

    private static ClickArea<CraftingGui> clickAreaFor(EnumCrafting type, Rectangle rect, CategoryIdentifier<?> ... categories) {
        return ctx -> {
            CraftingGui screen = (CraftingGui)ctx.getScreen();
            Rectangle rectangle = rect.clone();
            rectangle.translate(screen.getLeft(), screen.getTop());
            if (((CraftingGui)ctx.getScreen()).type() == type && rectangle.contains(ctx.getMousePosition())) {
                return ClickArea.Result.success().categories(Arrays.asList(categories));
            }
            return ClickArea.Result.fail();
        };
    }
}

