/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.client.ArmorModels;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.ItemModelProps;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerWeaponHandler;
import io.github.flemmli97.runecraftory.common.items.BigWeapon;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemDualBladeBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemGloveBase;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.CalendarImpl;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1007;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_809;

public class ClientMixinUtils {
    public static final int LEAVE_SPRING = 870913;
    public static final int LEAVE_FALL = 0xFF4646;
    private static final Map<SeasonedTint, Integer> LEAVE_TINTS = new ConcurrentHashMap<SeasonedTint, Integer>();
    private static final Map<SeasonedTint, Integer> GRASS_TINTS = new ConcurrentHashMap<SeasonedTint, Integer>();
    private static boolean ItemRenderContext;

    public static int modifyColoredTint(class_1920 getter, int old) {
        CalendarImpl calendar = ClientHandlers.CLIENT_CALENDAR;
        if (calendar.currentSeason() == EnumSeason.SUMMER) {
            return old;
        }
        return LEAVE_TINTS.computeIfAbsent(new SeasonedTint(old, calendar.currentSeason()), ClientMixinUtils::getLeaveTint);
    }

    public static int modifyColoredTintGrass(class_1920 getter, int old) {
        CalendarImpl calendar = ClientHandlers.CLIENT_CALENDAR;
        if (calendar.currentSeason() == EnumSeason.SUMMER) {
            return old;
        }
        return GRASS_TINTS.computeIfAbsent(new SeasonedTint(old, calendar.currentSeason()), ClientMixinUtils::getGrassTint);
    }

    private static int getLeaveTint(SeasonedTint tint) {
        return switch (tint.season) {
            default -> throw new IncompatibleClassChangeError();
            case EnumSeason.SPRING -> ClientMixinUtils.desaturate(ClientMixinUtils.add(tint.origin, 870913), 0.1f);
            case EnumSeason.SUMMER -> tint.origin;
            case EnumSeason.FALL -> ClientMixinUtils.desaturate(ClientMixinUtils.add(class_5253.class_5254.method_27763((int)tint.origin, (int)0xFF4646), 3939840), 0.2f);
            case EnumSeason.WINTER -> ClientMixinUtils.desaturate(ClientMixinUtils.add(class_5253.class_5254.method_27763((int)tint.origin, (int)0xFF4646), 3939840), 0.6f);
        };
    }

    private static int getGrassTint(SeasonedTint tint) {
        return switch (tint.season) {
            default -> throw new IncompatibleClassChangeError();
            case EnumSeason.SPRING -> ClientMixinUtils.desaturate(ClientMixinUtils.add(tint.origin, 870913), 0.1f);
            case EnumSeason.SUMMER -> tint.origin;
            case EnumSeason.FALL -> ClientMixinUtils.desaturate(tint.origin, 0.25f);
            case EnumSeason.WINTER -> ClientMixinUtils.desaturate(tint.origin, 0.7f);
        };
    }

    private static int desaturate(int color, float perc) {
        int r = class_5253.class_5254.method_27765((int)color);
        int g = class_5253.class_5254.method_27766((int)color);
        int b = class_5253.class_5254.method_27767((int)color);
        int gray = Math.max(b, Math.max(r, g));
        return class_5253.class_5254.method_27764((int)class_5253.class_5254.method_27762((int)color), (int)((int)((float)r + (float)(gray - r) * perc)), (int)((int)((float)g + (float)(gray - g) * perc)), (int)((int)((float)b + (float)(gray - b) * perc)));
    }

    private static int add(int packedColourOne, int packedColorTwo) {
        return class_5253.class_5254.method_27764((int)Math.min(255, class_5253.class_5254.method_27762((int)packedColourOne) + class_5253.class_5254.method_27762((int)packedColorTwo)), (int)Math.min(255, class_5253.class_5254.method_27765((int)packedColourOne) + class_5253.class_5254.method_27765((int)packedColorTwo)), (int)Math.min(255, class_5253.class_5254.method_27766((int)packedColourOne) + class_5253.class_5254.method_27766((int)packedColorTwo)), (int)Math.min(255, class_5253.class_5254.method_27767((int)packedColourOne) + class_5253.class_5254.method_27767((int)packedColorTwo)));
    }

    public static void translateSleepingEntity(class_1309 entity, class_4587 poseStack, float flipDegrees) {
        if (EntityData.getSleepStateFrom(entity) == EntityData.SleepState.VANILLA && flipDegrees != 0.0f) {
            poseStack.method_22907(class_1160.field_20703.method_23214(flipDegrees));
            float standOffset = entity.method_18381(class_4050.field_18076) * 0.6f;
            poseStack.method_22904(0.0, (double)(-standOffset), 0.0);
        }
    }

    public static boolean shouldAnimate(class_1309 entity) {
        return ClientHandlers.getAnimatedPlayerModel() != null && (entity instanceof class_1657 || entity instanceof IAnimated);
    }

    public static void transformHumanoidModel(class_1309 entity, class_572<?> model) {
        class_1268 off;
        class_1268 main = entity.method_6068() == class_1306.field_6183 ? class_1268.field_5808 : class_1268.field_5810;
        class_1268 class_12682 = off = entity.method_6068() == class_1306.field_6183 ? class_1268.field_5810 : class_1268.field_5808;
        if (model.field_3395 == class_572.class_573.field_3410 && entity.method_5998(main).method_31574((class_1792)ModItems.UMBRELLA.get())) {
            model.field_3401.field_3654 -= 1.2217305f;
        }
        if (model.field_3399 == class_572.class_573.field_3410 && entity.method_5998(off).method_31574((class_1792)ModItems.UMBRELLA.get())) {
            model.field_27433.field_3654 -= 1.2217305f;
        }
        if (ClientHandlers.getAnimatedPlayerModel() != null) {
            PlayerWeaponHandler weaponHandler;
            float partialTicks = ClientHandlers.getPartialTicks();
            if (entity instanceof IAnimated) {
                boolean result = ClientHandlers.getAnimatedPlayerModel().setUpModel(entity, model, null, partialTicks);
                if (result) {
                    ClientHandlers.getAnimatedPlayerModel().copyTo(model);
                }
                return;
            }
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                v1 = Platform.INSTANCE.getPlayerData(player).map(PlayerData::getWeaponHandler).orElse(null);
            } else {
                v1 = weaponHandler = null;
            }
            if (weaponHandler == null) {
                return;
            }
            boolean ignoreRiding = weaponHandler.getCurrentAction() == ModAttackActions.DUAL_USE.get();
            boolean result = ClientHandlers.getAnimatedPlayerModel().setUpModel(entity, model, weaponHandler, partialTicks);
            if (result) {
                ClientHandlers.getAnimatedPlayerModel().copyTo(model);
                if (ItemRenderContext) {
                    model.method_2805(false);
                    model.field_27433.field_3665 = true;
                    model.field_3401.field_3665 = true;
                    if (model instanceof class_591) {
                        class_591 playerModel = (class_591)model;
                        playerModel.field_3484.method_17138(model.field_27433);
                        playerModel.field_3486.method_17138(model.field_3401);
                    }
                }
            }
        }
    }

    public static void onRenderHand(class_4587 poseStack, class_742 player, boolean rightArm, class_591<class_742> arm, class_4597 buffer, int combinedLight) {
        for (class_1799 stack : player.method_5661()) {
            ArmorModels.FirstPersonArmorRenderer r;
            if (stack.method_7960() || (r = ArmorModels.getFirstPersonRenderer(stack)) == null) continue;
            r.render(player, stack, rightArm, arm, poseStack, buffer, combinedLight);
        }
    }

    public static void adjustForHeldModel(class_1799 itemStack, class_809.class_811 transformType) {
        if (itemStack.method_7909() instanceof ItemGloveBase || itemStack.method_7909() instanceof BigWeapon) {
            ItemModelProps.HELD_TYPE = switch (transformType) {
                case class_809.class_811.field_4321, class_809.class_811.field_4323 -> 1;
                case class_809.class_811.field_4322, class_809.class_811.field_4320 -> 2;
                default -> 0;
            };
        } else if (itemStack.method_7909() instanceof ItemDualBladeBase) {
            ItemModelProps.HELD_TYPE = switch (transformType) {
                case class_809.class_811.field_4321, class_809.class_811.field_4323, class_809.class_811.field_4322, class_809.class_811.field_4320 -> 1;
                default -> 0;
            };
        }
    }

    public static void resetHeldModel() {
        ItemModelProps.HELD_TYPE = 0;
    }

    public static boolean onRenderHeldItem(class_1309 livingEntity, class_1799 itemStack, class_809.class_811 transformType, boolean leftHand, class_4587 poseStack, class_4597 buffer, int combinedLight) {
        if (livingEntity instanceof class_742) {
            PlayerData data;
            class_742 player = (class_742)livingEntity;
            if (transformType.method_29998() && (data = (PlayerData)Platform.INSTANCE.getPlayerData((class_1657)player).orElse(null)) != null) {
                class_1007 playerRenderer = (class_1007)class_310.method_1551().method_1561().method_3953((class_1297)player);
                float partialTicks = ClientHandlers.getPartialTicks();
                boolean animated = ClientHandlers.getAnimatedPlayerModel().setUpModel((class_1309)player, (class_572)playerRenderer.method_4038(), data.getWeaponHandler(), partialTicks);
                if (!animated) {
                    return false;
                }
                if (leftHand == (livingEntity.method_6068() == class_1306.field_6183)) {
                    return true;
                }
                player.method_7350();
                poseStack = new class_4587();
                poseStack.method_22903();
                class_243 camPos = class_310.method_1551().field_1773.method_19418().method_19326();
                double camX = camPos.method_10216();
                double camY = camPos.method_10214();
                double camZ = camPos.method_10215();
                class_243 vec3 = playerRenderer.method_23206(player, partialTicks);
                double x = class_3532.method_16436((double)partialTicks, (double)player.field_6038, (double)player.method_23317());
                double y = class_3532.method_16436((double)partialTicks, (double)player.field_5971, (double)player.method_23318());
                double z = class_3532.method_16436((double)partialTicks, (double)player.field_5989, (double)player.method_23321());
                poseStack.method_22904(x += vec3.method_10216() - camX, y += vec3.method_10214() - camY, z += vec3.method_10215() - camZ);
                poseStack.method_22904(0.0, 0.1, 0.1);
                float rot = class_3532.method_16439((float)partialTicks, (float)player.field_5982, (float)player.method_36454());
                poseStack.method_22907(class_1160.field_20705.method_23214(rot + 180.0f));
                ItemRenderContext = true;
                playerRenderer.method_4215(player, 0.0f, partialTicks, poseStack, buffer, combinedLight);
                ItemRenderContext = false;
                poseStack.method_22909();
                return true;
            }
        }
        return ItemNBT.isInvis(itemStack);
    }

    public static ModelPartHandler.ModelPartExtended createPlayerItemPart(boolean left) {
        class_630 item = new class_630(List.of(), Map.of());
        item.method_32085(class_5603.method_32090((float)(left ? -1.0f : 1.0f), (float)-8.0f, (float)0.0f));
        class_630 root = new class_630(List.of(), Map.of(left ? "LeftItem" : "RightItem", item));
        root.method_32085(class_5603.method_32090((float)(left ? 1.0f : -1.0f), (float)8.0f, (float)0.0f));
        return new ModelPartHandler.ModelPartExtended(root);
    }

    record SeasonedTint(int origin, EnumSeason season) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SeasonedTint) {
                SeasonedTint tint = (SeasonedTint)obj;
                return tint.origin == this.origin && tint.season == this.season;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (String.valueOf((Object)this.season) + ";" + this.origin).hashCode();
        }
    }
}

