/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixinhelper.PrevEntityPosition;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import net.minecraft.class_4050;

public class MixinUtils {
    public static boolean stop(class_1657 player, class_1799 stack, class_239 hitResult) {
        class_1792 item = stack.method_7909();
        return hitResult.method_17783() != class_239.class_240.field_1332 && item instanceof IItemUsable && player.method_7357().method_7904(item);
    }

    public static boolean playerPose(class_1657 player) {
        if (Platform.INSTANCE.getEntityData((class_1309)player).map(EntityData::isSleeping).orElse(false).booleanValue()) {
            if (player.method_18376() != class_4050.field_18078) {
                player.method_18380(class_4050.field_18078);
            }
            return true;
        }
        class_4050 pose = Platform.INSTANCE.getPlayerData(player).map(d -> d.getWeaponHandler().getCurrentAction().getPose((class_1309)player, d.getWeaponHandler())).orElse(null);
        if (pose != null) {
            if (player.method_18376() != pose) {
                player.method_18380(pose);
            }
            return true;
        }
        return false;
    }

    public static void onPlayerThrowItem(class_1657 player, class_1542 entity) {
        if (!player.method_29504()) {
            entity.method_6981(player.method_5667());
            PrevEntityPosition pos = (PrevEntityPosition)player;
            double dX = player.method_23317() - pos.runecraftory$getOldPlayerX();
            double dZ = player.method_23321() - pos.runecraftory$getOldPlayerZ();
            double spd = dX * dX + dZ * dZ;
            if (spd > 0.01) {
                double scale = ArmorEffect.hasArmorEffect((class_1309)player, (ArmorEffect)((Object)ModArmorEffects.THROWING_RING.get())) ? 2.5 : 1.7;
                entity.method_18799(entity.method_18798().method_1021(scale));
            }
        }
    }

    public static boolean handleEntityCollision(class_1542 entity) {
        if (entity.method_5799() || entity.method_5771() || entity.method_6978() == null || entity.field_6002.field_9236) {
            return true;
        }
        class_239 hitResult = class_1675.method_18074((class_1297)entity, t -> MixinUtils.canHitEntity(entity, t));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            return true;
        }
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            class_3966 result = (class_3966)hitResult;
            class_1297 class_12972 = result.method_17782();
            if (class_12972 instanceof IBaseMob) {
                class_1657 thrower;
                IBaseMob mob = (IBaseMob)class_12972;
                class_1799 stack = entity.method_6983();
                class_1297 e = ((class_3218)entity.field_6002).method_14190(entity.method_6978());
                if (e instanceof class_1657 && mob.onGivingItem(thrower = (class_1657)e, stack) && stack.method_7960()) {
                    entity.method_31472();
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean canHitEntity(class_1542 entity, class_1297 target) {
        if (target.method_7325() || !target.method_5805() || !target.method_5863()) {
            return false;
        }
        return !target.method_5667().equals(entity.method_6978());
    }

    public static void onBlockStateChange(class_3218 level, class_2338 pos, class_2680 blockState, class_2680 newState) {
        if (FarmlandHandler.isFarmBlock(newState)) {
            if (!FarmlandHandler.isFarmBlock(blockState) || FarmlandHandler.get(level.method_8503()).getData(level, pos).isEmpty()) {
                FarmlandHandler.get(level.method_8503()).onFarmlandPlace(level, pos);
            }
        } else if (FarmlandHandler.isFarmBlock(blockState)) {
            FarmlandHandler.get(level.method_8503()).onFarmlandRemove(level, pos);
        } else {
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof class_2302) {
                class_2302 pre = (class_2302)class_22482;
                class_2248 class_22483 = newState.method_26204();
                if (!(class_22483 instanceof class_2302)) {
                    FarmlandHandler.get(level.method_8503()).getData(level, pos.method_10074()).ifPresent(d -> d.onCropRemove(level, pos, newState));
                } else {
                    class_2302 post = (class_2302)class_22483;
                    if ((Integer)blockState.method_11654((class_2769)pre.method_9824()) > (Integer)newState.method_11654((class_2769)post.method_9824())) {
                        FarmlandHandler.get(level.method_8503()).getData(level, pos.method_10074()).ifPresent(d -> d.onRegrowableHarvest(level, pos, newState));
                    }
                }
            }
        }
    }

    public static void recheckFarmland(class_3218 level, class_2680 state, class_2338 pos) {
        if (FarmlandHandler.get(level.method_8503()).getData(level, pos).map(d -> !d.isFarmBlock()).orElse(true).booleanValue()) {
            FarmlandHandler.get(level.method_8503()).onFarmlandPlace(level, pos);
        }
    }

    public static void triggerArmorStepEffect(class_1309 living) {
        for (class_1304 slot : class_1304.values()) {
            class_1799 stack;
            if (slot.method_5925() != class_1304.class_1305.field_6178 || (stack = living.method_6118(slot)).method_7960()) continue;
            Platform.INSTANCE.getArmorEffects(stack).ifPresent(d -> d.triggerEvent(stack, e -> e.onStep(living, stack)));
        }
    }
}

