/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.tenshilib.api.config.SimpleItemStackWrapper;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.lang.reflect.Type;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class ExtendedItemStackWrapper
extends SimpleItemStackWrapper {
    protected class_2487 nbtTagCompound;

    public ExtendedItemStackWrapper(class_2487 compound) {
        this(compound.method_10558("id"), compound.method_10550("Count"), compound.method_10562("nbt"));
    }

    public ExtendedItemStackWrapper(String item) {
        this(item, 1);
    }

    public ExtendedItemStackWrapper(String item, int count) {
        this(item, count, null);
    }

    public ExtendedItemStackWrapper(String item, int count, class_2487 nbt) {
        super(item, count);
    }

    public ExtendedItemStackWrapper setNBT(class_2487 nbt) {
        this.nbtTagCompound = nbt;
        return this;
    }

    public ExtendedItemStackWrapper ignoreNBT() {
        this.nbtTagCompound = null;
        return this;
    }

    @Override
    public boolean match(class_1799 stack) {
        return super.match(stack) && (this.nbtTagCompound == null && stack.method_7969() == null || this.nbtTagCompound != null && this.nbtTagCompound.equals((Object)stack.method_7969()));
    }

    @Override
    public ExtendedItemStackWrapper readFromString(String s) {
        try {
            class_2487 nbt = class_2522.method_10718((String)s);
            this.nbtTagCompound = nbt.method_10562("nbt");
            this.count = nbt.method_10550("Count");
            this.reg = nbt.method_10558("id");
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public String writeToString() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("nbt", (class_2520)this.nbtTagCompound.method_10553());
        nbt.method_10582("id", PlatformUtils.INSTANCE.items().getIDFrom(this.item).toString());
        nbt.method_10569("Count", this.count);
        return nbt.toString();
    }

    public static String usage() {
        return "Complete ItemStack nbt (meaning with id and count)";
    }

    @Nullable
    public class_2487 getTag() {
        return this.nbtTagCompound == null ? null : this.nbtTagCompound.method_10553();
    }

    @Override
    public class_1799 getStack() {
        class_1799 stack = super.getStack();
        if (!stack.method_7960() && this.nbtTagCompound != null) {
            stack.method_7980(this.nbtTagCompound.method_10553());
        }
        return stack;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtendedItemStackWrapper) {
            ExtendedItemStackWrapper prop = (ExtendedItemStackWrapper)obj;
            return prop.toString().equals(this.toString());
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<ExtendedItemStackWrapper>,
    JsonSerializer<ExtendedItemStackWrapper> {
        public JsonElement serialize(ExtendedItemStackWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("item", (JsonElement)new JsonPrimitive(src.reg));
            if (src.count != 1) {
                obj.add("count", (JsonElement)new JsonPrimitive((Number)src.count));
            }
            if (src.nbtTagCompound != null) {
                obj.add("nbt", (JsonElement)new JsonPrimitive(src.nbtTagCompound.toString()));
            }
            return obj;
        }

        public ExtendedItemStackWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int count = class_3518.method_15282((JsonObject)obj, (String)"count", (int)1);
            JsonObject nbt = obj.has("nbt") ? obj.get("nbt").getAsJsonObject() : null;
            class_2487 compound = null;
            if (nbt != null) {
                try {
                    compound = class_2522.method_10718((String)nbt.toString());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            return new ExtendedItemStackWrapper(obj.get("item").getAsString(), count, compound);
        }
    }
}

